/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.common.gui;

import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.quartzarsenal.common.QuartzArsenalIdentifierUtil;
import com.ultramega.universalgrid.common.UniversalGridIdentifierUtil;
import com.ultramega.universalgrid.common.gui.view.GridTypes;
import com.ultramega.universalgrid.common.interfaces.MixinGridType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GridTypeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = UniversalGridIdentifierUtil.createUniversalGridTranslation("gui", "grid.grid_type");
    private static final ResourceLocation WIRELESS_GRID = UniversalGridIdentifierUtil.createUniversalGridIdentifier("widget/side_button/wireless_grid/inactive");
    private static final ResourceLocation WIRELESS_CRAFTING_GRID = UniversalGridIdentifierUtil.createUniversalGridIdentifier("widget/side_button/wireless_crafting_grid/inactive");
    private static final ResourceLocation WIRELESS_AUTOCRAFTING_MONITOR = UniversalGridIdentifierUtil.createUniversalGridIdentifier("widget/side_button/wireless_autocrafting_monitor/inactive");
    private static final List<MutableComponent> SUBTEXT_WIRELESS_GRID = List.of(IdentifierUtil.createTranslation((String)"item", (String)"wireless_grid").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_WIRELESS_CRAFTING_GRID = List.of(QuartzArsenalIdentifierUtil.createQuartzArsenalTranslation((String)"item", (String)"wireless_crafting_grid").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_AUTOCRAFTING_MONITOR = List.of(IdentifierUtil.createTranslation((String)"item", (String)"wireless_autocrafting_monitor").withStyle(ChatFormatting.GRAY));
    private final AbstractBaseContainerMenu menu;

    public GridTypeSideButtonWidget(AbstractBaseContainerMenu menu) {
        super(GridTypeSideButtonWidget.createPressAction(menu));
        this.menu = menu;
    }

    private static Button.OnPress createPressAction(AbstractBaseContainerMenu menu) {
        return btn -> ((MixinGridType)menu).universalgrid$setGridType(GridTypeSideButtonWidget.toggle(((MixinGridType)menu).universalgrid$getGridType()), (Player)Minecraft.getInstance().player);
    }

    private static GridTypes toggle(GridTypes gridType) {
        return switch (gridType) {
            default -> throw new MatchException(null, null);
            case GridTypes.WIRELESS_GRID -> GridTypes.WIRELESS_CRAFTING_GRID;
            case GridTypes.WIRELESS_CRAFTING_GRID -> GridTypes.WIRELESS_AUTOCRAFTING_MONITOR;
            case GridTypes.WIRELESS_AUTOCRAFTING_MONITOR -> GridTypes.WIRELESS_GRID;
        };
    }

    protected ResourceLocation getSprite() {
        return switch (((MixinGridType)this.menu).universalgrid$getGridType()) {
            default -> throw new MatchException(null, null);
            case GridTypes.WIRELESS_GRID -> WIRELESS_GRID;
            case GridTypes.WIRELESS_CRAFTING_GRID -> WIRELESS_CRAFTING_GRID;
            case GridTypes.WIRELESS_AUTOCRAFTING_MONITOR -> WIRELESS_AUTOCRAFTING_MONITOR;
        };
    }

    protected MutableComponent getTitle() {
        return TITLE;
    }

    protected List<MutableComponent> getSubText() {
        return switch (((MixinGridType)this.menu).universalgrid$getGridType()) {
            default -> throw new MatchException(null, null);
            case GridTypes.WIRELESS_GRID -> SUBTEXT_WIRELESS_GRID;
            case GridTypes.WIRELESS_CRAFTING_GRID -> SUBTEXT_WIRELESS_CRAFTING_GRID;
            case GridTypes.WIRELESS_AUTOCRAFTING_MONITOR -> SUBTEXT_AUTOCRAFTING_MONITOR;
        };
    }
}

