/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestParticles;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhostyEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level serverWorld;
    private static final double ANGULAR_SPEED = 0.1;
    private double angle;
    private double baseY;
    Player target;

    public GhostyEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.serverWorld = world;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.63f).add(Attributes.FOLLOW_RANGE, 35.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        this.serverWorld.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + 0.5, this.getZ(), 1.2, 0.0, 0.0);
        this.serverWorld.playSound(null, this.blockPosition(), SoundEvents.FOX_SCREECH, SoundSource.HOSTILE, 1.0f, 1.0f);
        this.remove(Entity.RemovalReason.KILLED);
        return false;
    }

    public void tick() {
        List nearbyMonsters;
        super.tick();
        if (this.isSunBurnTick()) {
            this.setRemainingFireTicks(40);
        }
        if (this.tickCount % 15 == 0) {
            nearbyMonsters = this.serverWorld.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(1.0));
            for (Player player : nearbyMonsters) {
                if (player.isCreative()) continue;
                player.hurt(this.damageSources().generic(), 1.0f);
                Vec3 direction = player.position().subtract(this.position()).normalize().scale(0.1);
                player.push(direction.x, direction.y + 0.5, direction.z);
            }
        }
        nearbyMonsters = this.serverWorld.getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate((double)KQConfigValues.INVULNERABILITY_RADIUS_GHOSTY.get().floatValue()));
        for (Monster monster : nearbyMonsters) {
            monster.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1, 4, false, false, false));
            if (monster instanceof GhostyEntity) continue;
            for (int i = 0; i < 4 && this.tickCount % 25 == 0; ++i) {
                this.serverWorld.addParticle(KnightQuestCommon.COMMON_PLATFORM.getStartsetParticle().get(), monster.getX(), monster.getY() - 0.48, monster.getZ(), 1.2, 0.0, 0.0);
            }
        }
        if (this.baseY == 0.0 && this.getY() != 0.0) {
            this.baseY = this.getY();
        }
        this.target = this.serverWorld.getNearestPlayer((Entity)this, 20.0);
        double offsetY = Math.sin(this.angle * 2.0) * 0.1;
        double currentX = this.getX();
        double currentY = this.getY();
        double currentZ = this.getZ();
        if (this.target != null && !this.target.isCreative()) {
            this.lookAt((Entity)this.target, 360.0f, 360.0f);
            double speed = 0.1;
            double dx = this.target.getX() - currentX;
            double dy = this.target.getY() + 0.5 - currentY;
            double dz = this.target.getZ() - currentZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distance > 1.0) {
                double motionX = dx / distance * speed;
                double motionY = dy / distance * speed;
                double motionZ = dz / distance * speed;
                currentX += motionX;
                currentY += motionY + offsetY;
                currentZ += motionZ;
            } else {
                currentY += offsetY;
            }
        } else {
            currentY += offsetY;
        }
        this.setPos(currentX, currentY, currentZ);
        if (this.serverWorld.getNearestPlayer((Entity)this, -1.0) != null) {
            this.lookAt((Entity)Objects.requireNonNull(this.serverWorld.getNearestPlayer((Entity)this, -1.0)), 360.0f, 360.0f);
        }
        this.angle += 0.1;
        if (this.angle >= Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
        ParticleOptions particleType = (ParticleOptions)KnightQuestParticles.GHOSTY_PARTICLE.get();
        for (int i = 0; i < 1 && this.tickCount % 15 == 0; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.serverWorld.addParticle(particleType, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 1.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    public boolean isFallFlying() {
        return super.isFallFlying();
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    protected void removeEffectParticles() {
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    protected void pushEntities() {
    }

    public void push(@NotNull Entity pEntity) {
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isInLava() {
        return false;
    }

    public boolean isInWater() {
        return false;
    }

    public boolean isInWall() {
        return false;
    }

    protected void spawnSprintParticle() {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public void playSound(@NotNull SoundEvent pSound) {
    }

    public void playSound(@NotNull SoundEvent pSound, float pVolume, float pPitch) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return null;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }
}

