/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xylonity.knightquest.client.entity.model.GremlinModel;
import dev.xylonity.knightquest.common.entity.entities.GremlinEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GremlinRenderer
extends GeoEntityRenderer<GremlinEntity> {
    public GremlinRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GremlinModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(GremlinEntity animatable) {
        if (animatable.getPhase() == 2) {
            return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/gremlin_angry.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/gremlin.png");
    }

    public void render(GremlinEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(1.1f, 1.1f, 1.1f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

