/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.piglinnames_common_forge.util;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.piglinnames_common_forge.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class Names {
    public static List<String> customPiglinNames = new ArrayList<String>();

    public static void setCustomNames() throws IOException {
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "piglinnames";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "customnames.txt");
        if (dir.isDirectory() && file.isFile()) {
            String[] cns;
            Path customNamePath = Paths.get(dirpath + File.separator + "customnames.txt", new String[0]);
            String cn = Files.readString(customNamePath);
            cn = cn.replace("\n", "").replace("\r", "").strip();
            for (String n : cns = cn.split("[,\\n]")) {
                String name = n.strip();
                if (name.isEmpty()) continue;
                customPiglinNames.add(name);
            }
        } else {
            boolean ignored = dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "customnames.txt", StandardCharsets.UTF_8);
            writer.close();
        }
    }

    public static String getRandomName() {
        ArrayList<String> piglinNameList = new ArrayList<String>();
        if (ConfigHandler.useCustomNames && !customPiglinNames.isEmpty()) {
            if (ConfigHandler.useBothCustomAndDefaultNames) {
                piglinNameList.add(Names.randomFromList(customPiglinNames));
            } else {
                String name2 = Names.randomFromList(customPiglinNames);
                if (ConfigHandler.shouldCapitalizeNames) {
                    return StringFunctions.capitalizeEveryWord((String)name2);
                }
                return name2;
            }
        }
        if (ConfigHandler.useDefaultFemaleNames) {
            piglinNameList.add(Names.randomFromList(GlobalVariables.femaleNames));
        }
        if (ConfigHandler.useDefaultMaleNames) {
            piglinNameList.add(Names.randomFromList(GlobalVariables.maleNames));
        }
        piglinNameList.removeIf(name -> name.equals(""));
        if (piglinNameList.isEmpty()) {
            return "";
        }
        String name3 = Names.randomFromList(piglinNameList);
        if (ConfigHandler.shouldCapitalizeNames) {
            return StringFunctions.capitalizeEveryWord((String)name3);
        }
        return name3;
    }

    private static String randomFromList(List<String> list) {
        if (list.size() == 0) {
            return "";
        }
        return list.get(GlobalVariables.random.nextInt(list.size()));
    }
}

