/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.mixin.event;

import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.swedz.tesseract.neoforge.event.PlayerInventoryChangeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public final class PlayerInventoryChangeEventMixin {
    @Unique
    private ContainerListener playerInventoryChangeListener;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(MinecraftServer server, ServerLevel level, GameProfile gameProfile, ClientInformation clientInformation, CallbackInfo callback) {
        final ServerPlayer player = (ServerPlayer)this;
        this.playerInventoryChangeListener = new ContainerListener(){

            public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
                Slot slot = containerToSend.getSlot(dataSlotIndex);
                if (!(slot instanceof ResultSlot) && slot.container == player.getInventory()) {
                    NeoForge.EVENT_BUS.post((Event)new PlayerInventoryChangeEvent((Player)player, player.getInventory(), stack));
                }
            }

            public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
            }
        };
    }

    @Inject(method={"initMenu"}, at={@At(value="HEAD")})
    private void initMenu(AbstractContainerMenu openedMenu, CallbackInfo callback) {
        openedMenu.addSlotListener(this.playerInventoryChangeListener);
    }
}

