/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.recipe;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.data.recipes.RecipeOutput;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.MaterialRegistry;
import net.swedz.tesseract.neoforge.material.recipe.MaterialRecipeContext;
import net.swedz.tesseract.neoforge.material.recipe.MaterialRecipeContextFactory;
import net.swedz.tesseract.neoforge.material.recipe.MaterialRecipeCreator;

public class MaterialRecipeGroup<C extends MaterialRecipeContext> {
    protected final MaterialRecipeContextFactory<C> contextFactory;
    protected final Map<String, MaterialRecipeCreator<C>> creators;

    protected MaterialRecipeGroup(MaterialRecipeContextFactory<C> contextFactory, Map<String, MaterialRecipeCreator<C>> creators) {
        this.contextFactory = contextFactory;
        this.creators = Maps.newHashMap(creators);
    }

    public static <C extends MaterialRecipeContext> MaterialRecipeGroup<C> create(MaterialRecipeContextFactory<C> contextFactory) {
        return new MaterialRecipeGroup<C>(contextFactory, Maps.newHashMap());
    }

    public static MaterialRecipeGroup<MaterialRecipeContext> create() {
        return MaterialRecipeGroup.create(MaterialRecipeContext::new);
    }

    public MaterialRecipeGroup<C> copy() {
        return new MaterialRecipeGroup<C>(this.contextFactory, this.creators);
    }

    public MaterialRecipeGroup<C> add(String reference, MaterialRecipeCreator<C> creator) {
        MaterialRecipeGroup<C> copy = this.copy();
        if (copy.creators.put(reference, creator) != null) {
            throw new IllegalArgumentException("There is already a recipe creator with the reference '%s' on this group".formatted(reference));
        }
        return copy;
    }

    public MaterialRecipeGroup<C> filtered(Predicate<String> predicate) {
        MaterialRecipeGroup filtered = MaterialRecipeGroup.create(this.contextFactory);
        this.creators.forEach((reference, creator) -> {
            if (predicate.test((String)reference)) {
                filtered.add((String)reference, (MaterialRecipeCreator)creator);
            }
        });
        return filtered;
    }

    public MaterialRecipeGroup<C> only(Collection<String> references) {
        return this.filtered(references::contains);
    }

    public MaterialRecipeGroup<C> only(String ... references) {
        return this.only(Arrays.asList(references));
    }

    public MaterialRecipeGroup<C> without(Collection<String> references) {
        return this.filtered(reference -> !references.contains(reference));
    }

    public MaterialRecipeGroup<C> without(String ... references) {
        return this.without(Arrays.asList(references));
    }

    public void create(MaterialRegistry registry, Material material, RecipeOutput recipes) {
        Object context = this.contextFactory.create(registry, material, recipes);
        this.creators.forEach((reference, creator) -> creator.create(context));
    }

    public <T extends MaterialRecipeContext> MaterialRecipeGroup<T> then(MaterialRecipeContextFactory<T> contextFactory) {
        return new MaterialRecipeGroup<T>(contextFactory, Maps.newHashMap()){

            @Override
            public void create(MaterialRegistry registry, Material material, RecipeOutput recipes) {
                MaterialRecipeGroup.this.create(registry, material, recipes);
                super.create(registry, material, recipes);
            }
        };
    }
}

