/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.part;

import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public interface RegisteredMaterialPart
extends ItemLike {
    default public String itemReference() {
        return BuiltInRegistries.ITEM.getKey((Object)this.asItem()).toString();
    }

    public boolean hasBlock();

    public Block asBlock();

    public static RegisteredMaterialPart existingItem(final String itemReference, final Supplier<? extends Item> item) {
        return new RegisteredMaterialPart(){

            public Item asItem() {
                return (Item)item.get();
            }

            @Override
            public String itemReference() {
                return itemReference == null ? RegisteredMaterialPart.super.itemReference() : itemReference;
            }

            @Override
            public boolean hasBlock() {
                return false;
            }

            @Override
            public Block asBlock() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RegisteredMaterialPart existingItem(String itemReference, ResourceLocation itemId) {
        return RegisteredMaterialPart.existingItem(itemReference, () -> (Item)BuiltInRegistries.ITEM.get(itemId));
    }

    public static RegisteredMaterialPart existingItem(String itemReference, String itemId) {
        return RegisteredMaterialPart.existingItem(itemReference, ResourceLocation.parse((String)itemId));
    }

    public static RegisteredMaterialPart existingBlock(final Supplier<? extends Block> block) {
        return new RegisteredMaterialPart(){

            public Item asItem() {
                return ((Block)block.get()).asItem();
            }

            @Override
            public boolean hasBlock() {
                return true;
            }

            @Override
            public Block asBlock() {
                return (Block)block.get();
            }
        };
    }

    public static RegisteredMaterialPart existingBlock(ResourceLocation blockId) {
        return RegisteredMaterialPart.existingBlock(() -> (Block)BuiltInRegistries.BLOCK.get(blockId));
    }

    public static RegisteredMaterialPart existingBlock(String blockId) {
        return RegisteredMaterialPart.existingBlock(ResourceLocation.tryParse((String)blockId));
    }
}

