/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.proxy;

import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.config.ClientConfig;
import fuzs.armorstatues.init.ModRegistry;
import fuzs.armorstatues.network.client.data.CommandDataSyncHandler;
import fuzs.armorstatues.network.client.data.VanillaTweaksDataSyncHandler;
import fuzs.armorstatues.proxy.ServerProxy;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandScreenFactory;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.entity.decoration.ArmorStandDataProvider;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class ClientProxy
extends ServerProxy {
    @Override
    public void openArmorStandScreen(final ArmorStand armorStand, Player player) {
        ArmorStandHolder holder = new ArmorStandHolder(){

            public ArmorStand getArmorStand() {
                return armorStand;
            }

            public ArmorStandDataProvider getDataProvider() {
                return ModRegistry.ARMOR_STAND_DATA_PROVIDER;
            }
        };
        Screen screen = ArmorStandScreenFactory.createLastScreenType((ArmorStandHolder)holder, (Inventory)player.getInventory(), (Component)armorStand.getDisplayName(), (DataSyncHandler)ClientProxy.createDataSyncHandler(holder, (LocalPlayer)player));
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen(screen);
    }

    private static DataSyncHandler createDataSyncHandler(ArmorStandHolder holder, LocalPlayer player) {
        if ((!player.hasPermissions(2) || ((ClientConfig)ArmorStatues.CONFIG.get(ClientConfig.class)).overrideClientPermissionsCheck) && ((ClientConfig)ArmorStatues.CONFIG.get(ClientConfig.class)).useVanillaTweaksTriggers) {
            return new VanillaTweaksDataSyncHandler(holder, player);
        }
        return new CommandDataSyncHandler(holder, player);
    }
}

