/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.mojang.serialization.MapCodec;
import com.thevortex.allthemodium.AllTheModium;
import com.thevortex.allthemodium.registry.LevelRegistry;
import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleportPad
extends Block {
    MapCodec<? extends TeleportPad> codec = TeleportPad.simpleCodec(TeleportPad::new);
    protected static final VoxelShape TELEPORTPAD_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public TeleportPad(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer && player.isCrouching()) {
            this.transferPlayer((ServerPlayer)player, pos);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.0, 1.0, 0.0);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return !player.level().dimension().registry().getNamespace().contains("allthemodium");
    }

    public void transferPlayer(ServerPlayer player, BlockPos pos) {
        BlockPos targetPos;
        ServerLevel targetWorld;
        int config = 1;
        if (player.level().dimension().equals(LevelRegistry.Mining)) {
            int y;
            ServerLevel targetWorld2 = player.server.getLevel(AllTheModium.OverWorld);
            boolean located = false;
            for (y = 256; y >= 1; --y) {
                BlockPos posa = new BlockPos(Math.round(pos.getX()), y, Math.round(pos.getZ()));
                Block potential = targetWorld2.getBlockState(posa).getBlock();
                if (!potential.getName().toString().contains("teleport_pad")) continue;
                located = true;
                break;
            }
            if (located) {
                targetWorld2.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
                player.teleportTo(targetWorld2, (double)pos.getX() + 0.5, (double)y + 0.25, (double)pos.getZ() + 0.5, player.rotA, player.yya);
                return;
            }
            if (targetWorld2.getBlockState(pos).hasBlockEntity() || targetWorld2.getBlockState(pos).canEntityDestroy((BlockGetter)targetWorld2, pos, (Entity)player)) {
                // empty if block
            }
            targetWorld2.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
            player.teleportTo(targetWorld2, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, player.rotA, player.yya);
        } else if (player.level().dimension().equals(AllTheModium.Nether)) {
            BlockPos targetPos2;
            ServerLevel targetWorld3 = player.server.getLevel(LevelRegistry.THE_OTHER);
            if (!targetWorld3.getBlockState(targetPos2 = new BlockPos(Math.round(pos.getX()), Math.round(pos.getY()), Math.round(pos.getZ()))).hasBlockEntity()) {
                LevelHeightAccessor accessor = targetWorld3.getChunk(pos).getHeightAccessorForGeneration();
                int y = targetWorld3.getChunkSource().getGenerator().getSpawnHeight(accessor);
                targetWorld3.setBlockAndUpdate(new BlockPos(targetPos2.getX(), y, targetPos2.getZ()), ((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState());
                targetWorld3.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
                player.teleportTo(targetWorld3, (double)targetPos2.getX() + 0.5, (double)y + 0.25, (double)targetPos2.getZ() + 0.5, 0.0f, 0.0f);
            }
        } else if (player.level().dimension().equals(LevelRegistry.THE_OTHER)) {
            int y;
            ServerLevel targetWorld4 = player.server.getLevel(AllTheModium.Nether);
            boolean located = false;
            for (y = 128; y >= 1; --y) {
                BlockPos posa = new BlockPos(Math.round(pos.getX()), y, Math.round(pos.getZ()));
                Block potential = targetWorld4.getBlockState(posa).getBlock();
                if (!potential.getName().toString().contains("teleport_pad")) continue;
                located = true;
                break;
            }
            if (located) {
                targetWorld4.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
                player.teleportTo(targetWorld4, (double)pos.getX() + 0.5, (double)y + 0.25, (double)pos.getZ() + 0.5, player.rotA, player.yya);
                return;
            }
            BlockPos newpos = new BlockPos(pos.getX(), 90, pos.getZ());
            if (!targetWorld4.getBlockState(newpos).hasBlockEntity() && targetWorld4.getBlockState(newpos).canEntityDestroy((BlockGetter)targetWorld4, newpos, (Entity)player)) {
                targetWorld4.setBlockAndUpdate(newpos, ((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState());
            }
            targetWorld4.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)newpos.getX(), (double)newpos.getY(), (double)newpos.getZ(), 0.0, 1.0, 0.0);
            player.teleportTo(targetWorld4, (double)newpos.getX() + 0.5, (double)newpos.getY() + 0.25, (double)newpos.getZ() + 0.5, player.rotA, player.yya);
        } else if (player.level().dimension().equals(AllTheModium.The_End)) {
            BlockPos targetPos3;
            ServerLevel targetWorld5 = player.server.getLevel(LevelRegistry.THE_BEYOND);
            if (!targetWorld5.getBlockState(targetPos3 = new BlockPos(Math.round(pos.getX() * 50), Math.round(pos.getY()), Math.round(pos.getZ() * 50))).hasBlockEntity()) {
                LevelHeightAccessor accessor = targetWorld5.getChunk(pos).getHeightAccessorForGeneration();
                int y = targetWorld5.getChunkSource().getGenerator().getSpawnHeight(accessor);
                targetWorld5.setBlockAndUpdate(new BlockPos(targetPos3.getX(), y, targetPos3.getZ()), ((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState());
                if (targetWorld5.getBlockState(new BlockPos(targetPos3.getX(), y - 1, targetPos3.getZ())).is(Blocks.AIR)) {
                    targetWorld5.setBlockAndUpdate(new BlockPos(targetPos3.getX(), y - 1, targetPos3.getZ()), ((Block)ModRegistry.ANCIENT_POLISHED_STONE.get()).defaultBlockState());
                }
                targetWorld5.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
                player.teleportTo(targetWorld5, (double)targetPos3.getX() + 0.5, (double)y + 0.25, (double)targetPos3.getZ() + 0.5, 0.0f, 0.0f);
            }
        } else if (player.level().dimension().equals(LevelRegistry.THE_BEYOND)) {
            int y;
            ServerLevel targetWorld6 = player.server.getLevel(AllTheModium.The_End);
            boolean located = false;
            for (y = 384; y >= -63; --y) {
                BlockPos posa = new BlockPos(Math.round(pos.getX() / 50), y, Math.round(pos.getZ()) / 50);
                Block potential = targetWorld6.getBlockState(posa).getBlock();
                if (!potential.getName().toString().contains("teleport_pad")) continue;
                located = true;
                break;
            }
            if (located) {
                targetWorld6.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
                player.teleportTo(targetWorld6, (double)(pos.getX() / 50) + 0.5, (double)y + 0.25, (double)(pos.getZ() / 50) + 0.5, player.rotA, player.yya);
                return;
            }
            BlockPos newpos = new BlockPos(pos.getX() / 50, 90, pos.getZ() / 50);
            if (!targetWorld6.getBlockState(newpos).hasBlockEntity() && targetWorld6.getBlockState(newpos).canEntityDestroy((BlockGetter)targetWorld6, newpos, (Entity)player)) {
                targetWorld6.setBlockAndUpdate(newpos, ((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState());
            }
            targetWorld6.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)newpos.getX(), (double)newpos.getY(), (double)newpos.getZ(), 0.0, 1.0, 0.0);
            player.teleportTo(targetWorld6, (double)newpos.getX() + 0.5, (double)newpos.getY() + 0.25, (double)newpos.getZ() + 0.5, player.rotA, player.yya);
        } else if (player.level().dimension().equals(AllTheModium.OverWorld) && config != 5 && !(targetWorld = player.server.getLevel(LevelRegistry.Mining)).getBlockState(targetPos = new BlockPos(Math.round(pos.getX()), 253, Math.round(pos.getZ()))).hasBlockEntity()) {
            targetWorld.setBlockAndUpdate(targetPos, ((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState());
            targetWorld.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 1.0, 0.0);
            player.teleportTo(targetWorld, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.25, (double)targetPos.getZ() + 0.5, 0.0f, 0.0f);
        }
    }
}

