/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.renderer.entity;

import fuzs.tinyskeletons.TinySkeletons;
import fuzs.tinyskeletons.client.init.ModClientRegistry;
import fuzs.tinyskeletons.client.renderer.entity.layers.BackItemLayer;
import fuzs.tinyskeletons.client.renderer.entity.layers.MainHandItemLayer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractSkeleton;

public class BabySkeletonRenderer
extends MobRenderer<AbstractSkeleton, SkeletonModel<AbstractSkeleton>> {
    public static final ResourceLocation BABY_SKELETON_LOCATION = TinySkeletons.id("textures/entity/skeleton/baby_skeleton.png");

    public BabySkeletonRenderer(EntityRendererProvider.Context entityRendererManager) {
        this(entityRendererManager, ModClientRegistry.BABY_SKELETON, ModClientRegistry.BABY_SKELETON_INNER_ARMOR, ModClientRegistry.BABY_SKELETON_OUTER_ARMOR);
    }

    public BabySkeletonRenderer(EntityRendererProvider.Context context, ModelLayerLocation entityLocation, ModelLayerLocation innerArmorLocation, ModelLayerLocation outerArmorLocation) {
        super(context, (EntityModel)new SkeletonModel(context.bakeLayer(entityLocation)), 0.5f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer(new MainHandItemLayer(this, context.getItemInHandRenderer()));
        this.addLayer(new BackItemLayer(this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new SkeletonModel(context.bakeLayer(innerArmorLocation)), (HumanoidModel)new SkeletonModel(context.bakeLayer(outerArmorLocation)), context.getModelManager()));
    }

    public ResourceLocation getTextureLocation(AbstractSkeleton entity) {
        return BABY_SKELETON_LOCATION;
    }

    protected boolean isShaking(AbstractSkeleton abstractSkeleton) {
        return abstractSkeleton.isShaking();
    }
}

