/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.packs;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.tinyskeletons.client.renderer.entity.BabyBoggedRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabySkeletonRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyStrayRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyWitherSkeletonRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class BabySkeletonPackResources
extends AbstractModPackResources {
    private static final ResourceLocation SKELETON_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation STRAY_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/skeleton/stray.png");
    private static final ResourceLocation WITHER_SKELETON_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png");
    private static final ResourceLocation BOGGED_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/skeleton/bogged.png");
    private static final BiMap<ResourceLocation, ResourceLocation> BABY_SKELETON_LOCATIONS = ImmutableBiMap.of((Object)BabySkeletonRenderer.BABY_SKELETON_LOCATION, (Object)SKELETON_LOCATION, (Object)BabyStrayRenderer.BABY_STRAY_SKELETON_LOCATION, (Object)STRAY_LOCATION, (Object)BabyWitherSkeletonRenderer.BABY_WITHER_SKELETON_LOCATION, (Object)WITHER_SKELETON_LOCATION, (Object)BabyBoggedRenderer.BABY_BOGGED_SKELETON_LOCATION, (Object)BOGGED_LOCATION);
    private static final int VANILLA_SKELETON_TEXTURE_WIDTH = 64;
    private static final int VANILLA_SKELETON_TEXTURE_HEIGHT = 32;
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;

    public BabySkeletonPackResources() {
        Minecraft minecraft = Minecraft.getInstance();
        this.resourceManager = minecraft.getResourceManager();
        this.vanillaPackResources = minecraft.getVanillaPackResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        ResourceLocation vanillaSkeletonLocation = (ResourceLocation)BABY_SKELETON_LOCATIONS.get((Object)location);
        if (vanillaSkeletonLocation == null) {
            return null;
        }
        Optional resource = this.resourceManager.getResource(vanillaSkeletonLocation);
        if (!resource.isPresent()) return null;
        try (NativeImage image = NativeImage.read((InputStream)((Resource)resource.get()).open());){
            if (image.getWidth() / image.getHeight() == 2) return () -> ((Resource)((Resource)resource.get())).open();
            IoSupplier ioSupplier = this.vanillaPackResources.getResource(packType, vanillaSkeletonLocation);
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)resource.get())).open();
    }

    public Set<String> getNamespaces(PackType type) {
        return BABY_SKELETON_LOCATIONS.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
    }
}

