/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.campfirespawnandtweaks_common_forge.config.ConfigHandler;
import com.natamus.campfirespawnandtweaks_common_forge.events.CampfireEvent;
import com.natamus.collective_common_forge.functions.DimensionFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Util {
    public static void loadCampfireSpawnsFromWorld(Level level) {
        String campfirespawnfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        File dir = new File(campfirespawnfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        for (File listOfFile : listOfFiles) {
            String[] cs;
            String filecontent;
            String filename = listOfFile.getName();
            if (!filename.endsWith(".spawnpoint")) continue;
            String playername = filename.toLowerCase().replace(".spawnpoint", "");
            try {
                filecontent = new String(Files.readAllBytes(Paths.get(campfirespawnfolder + File.separator + filename, new String[0])));
            }
            catch (IOException e) {
                System.out.println("[Error] Campfire Spawn: Something went wrong while loading a campfire spawn location for player " + playername + ".");
                continue;
            }
            if (StringFunctions.sequenceCount((String)filecontent, (String)"_") < 2 || (cs = filecontent.trim().split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            BlockPos spawnpos = new BlockPos(x, y, z);
            CampfireEvent.playercampfires.put(playername, (Pair<Level, BlockPos>)new Pair((Object)level, (Object)spawnpos.immutable()));
        }
    }

    public static boolean setCampfireSpawn(Level level, String playername, BlockPos campfirepos) {
        String campfirespawnfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        File dir = new File(campfirespawnfolder);
        dir.mkdirs();
        String filename = playername.toLowerCase() + ".spawnpoint";
        try {
            PrintWriter writer = new PrintWriter(campfirespawnfolder + File.separator + filename, StandardCharsets.UTF_8);
            writer.println(campfirepos.getX() + "_" + campfirepos.getY() + "_" + campfirepos.getZ());
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[Error] Campfire Spawn: Something went wrong while saving a campfire spawn location for player " + playername + ".");
            return false;
        }
        CampfireEvent.playercampfires.put(playername.toLowerCase(), (Pair<Level, BlockPos>)new Pair((Object)level, (Object)campfirepos.immutable()));
        return true;
    }

    public static boolean checkForCampfireSpawnRemoval(Level level, String playername, BlockPos campfirepos) {
        ArrayList<String> fromplayernames = new ArrayList<String>();
        for (String pname : CampfireEvent.playercampfires.keySet()) {
            Pair<Level, BlockPos> pair = CampfireEvent.playercampfires.get(pname);
            if (!campfirepos.equals(pair.getSecond())) continue;
            fromplayernames.add(pname);
        }
        boolean removed = false;
        for (String fromplayername : fromplayernames) {
            Player target;
            if (!CampfireEvent.playercampfires.containsKey(fromplayername)) continue;
            for (Level looplevel : CampfireEvent.playerstorespawn.keySet()) {
                String campfirespawnfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)looplevel)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)looplevel);
                File dir = new File(campfirespawnfolder);
                dir.mkdirs();
                String filename = fromplayername.toLowerCase() + ".spawnpoint";
                try {
                    PrintWriter writer = new PrintWriter(campfirespawnfolder + File.separator + filename, StandardCharsets.UTF_8);
                    writer.print("");
                    writer.close();
                }
                catch (Exception e) {
                    System.out.println("[Error] Campfire Spawn: Something went wrong while removing a campfire spawn location for player " + playername + ".");
                }
            }
            CampfireEvent.playercampfires.remove(fromplayername);
            removed = true;
            if (!ConfigHandler.sendMessageOnCampfireSpawnUnset || fromplayername.equalsIgnoreCase(playername) || (target = PlayerFunctions.matchPlayer((Level)level, (String)fromplayername)) == null) continue;
            MessageFunctions.sendMessage((Player)target, (String)"Campfire spawn point removed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        }
        return removed && fromplayernames.contains(playername.toLowerCase());
    }
}

