/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.campfirespawnandtweaks_common_fabric.config.ConfigHandler;
import com.natamus.campfirespawnandtweaks_common_fabric.events.CampfireEvent;
import com.natamus.collective_common_fabric.functions.DimensionFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.collective_common_fabric.functions.PlayerFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.collective_common_fabric.functions.WorldFunctions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class Util {
    public static void loadCampfireSpawnsFromWorld(class_1937 level) {
        String campfirespawnfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)level)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)level);
        File dir = new File(campfirespawnfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        for (File listOfFile : listOfFiles) {
            String[] cs;
            String filecontent;
            String filename = listOfFile.getName();
            if (!filename.endsWith(".spawnpoint")) continue;
            String playername = filename.toLowerCase().replace(".spawnpoint", "");
            try {
                filecontent = new String(Files.readAllBytes(Paths.get(campfirespawnfolder + File.separator + filename, new String[0])));
            }
            catch (IOException e) {
                System.out.println("[Error] Campfire Spawn: Something went wrong while loading a campfire spawn location for player " + playername + ".");
                continue;
            }
            if (StringFunctions.sequenceCount((String)filecontent, (String)"_") < 2 || (cs = filecontent.trim().split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            class_2338 spawnpos = new class_2338(x, y, z);
            CampfireEvent.playercampfires.put(playername, (Pair<class_1937, class_2338>)new Pair((Object)level, (Object)spawnpos.method_10062()));
        }
    }

    public static boolean setCampfireSpawn(class_1937 level, String playername, class_2338 campfirepos) {
        String campfirespawnfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)level)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)level);
        File dir = new File(campfirespawnfolder);
        dir.mkdirs();
        String filename = playername.toLowerCase() + ".spawnpoint";
        try {
            PrintWriter writer = new PrintWriter(campfirespawnfolder + File.separator + filename, StandardCharsets.UTF_8);
            writer.println(campfirepos.method_10263() + "_" + campfirepos.method_10264() + "_" + campfirepos.method_10260());
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[Error] Campfire Spawn: Something went wrong while saving a campfire spawn location for player " + playername + ".");
            return false;
        }
        CampfireEvent.playercampfires.put(playername.toLowerCase(), (Pair<class_1937, class_2338>)new Pair((Object)level, (Object)campfirepos.method_10062()));
        return true;
    }

    public static boolean checkForCampfireSpawnRemoval(class_1937 level, String playername, class_2338 campfirepos) {
        ArrayList<String> fromplayernames = new ArrayList<String>();
        for (String pname : CampfireEvent.playercampfires.keySet()) {
            Pair<class_1937, class_2338> pair = CampfireEvent.playercampfires.get(pname);
            if (!campfirepos.equals(pair.getSecond())) continue;
            fromplayernames.add(pname);
        }
        boolean removed = false;
        for (String fromplayername : fromplayernames) {
            class_1657 target;
            if (!CampfireEvent.playercampfires.containsKey(fromplayername)) continue;
            for (class_1937 looplevel : CampfireEvent.playerstorespawn.keySet()) {
                String campfirespawnfolder = WorldFunctions.getWorldPath((class_3218)((class_3218)looplevel)) + File.separator + "data" + File.separator + "campfirespawn" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)looplevel);
                File dir = new File(campfirespawnfolder);
                dir.mkdirs();
                String filename = fromplayername.toLowerCase() + ".spawnpoint";
                try {
                    PrintWriter writer = new PrintWriter(campfirespawnfolder + File.separator + filename, StandardCharsets.UTF_8);
                    writer.print("");
                    writer.close();
                }
                catch (Exception e) {
                    System.out.println("[Error] Campfire Spawn: Something went wrong while removing a campfire spawn location for player " + playername + ".");
                }
            }
            CampfireEvent.playercampfires.remove(fromplayername);
            removed = true;
            if (!ConfigHandler.sendMessageOnCampfireSpawnUnset || fromplayername.equalsIgnoreCase(playername) || (target = PlayerFunctions.matchPlayer((class_1937)level, (String)fromplayername)) == null) continue;
            MessageFunctions.sendMessage((class_1657)target, (String)"Campfire spawn point removed.", (class_124)class_124.field_1063);
        }
        return removed && fromplayernames.contains(playername.toLowerCase());
    }
}

