/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PickaxeHeaterItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heater").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"capacity").initialValue(20.0, 25.0).upgradeModifier(UpgradeOperation.ADD, 5.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"duration").initialValue(140.0, 120.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.083).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)1)).build()).research(ResearchData.builder().star(0, 11, 28).star(1, 11, 18).star(2, 19, 24).star(3, 11, 6).star(4, 4, 9).star(5, 18, 9).link(0, 1).link(1, 2).link(3, 1).link(3, 4).link(3, 5).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7103326).borderBottom(-9868420).build()).beams(BeamsData.builder().startColor(-7103326).endColor(6908796).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"heater").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.CAVE, LootEntries.MINESHAFT}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                Player player = (Player)livingEntity;
                if ((long)player.tickCount % Math.round(this.getStatValue(stack, "heater", "duration")) == 0L && (long)PickaxeHeaterItem.getCharges(stack) < Math.round(this.getStatValue(stack, "heater", "capacity"))) break block3;
            }
            return;
        }
        PickaxeHeaterItem.addCharges(stack, 1);
    }

    public static void addCharges(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)(PickaxeHeaterItem.getCharges(stack) + amount));
    }

    public static int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public static ItemStack getSmeltingResult(ItemStack stack, ServerLevel level) {
        ItemStack result;
        Optional entry = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level);
        if (entry.isPresent() && !(result = ((SmeltingRecipe)((RecipeHolder)entry.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess())).isEmpty()) {
            return result.copyWithCount(stack.getCount() * result.getCount());
        }
        return stack;
    }

    @EventBusSubscriber
    public static class PickaxeHeaterEvent {
        @SubscribeEvent
        public static void onPlayerAttack(BlockDropsEvent event) {
            PickaxeHeaterItem relic;
            Item item;
            Entity entity = event.getBreaker();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PICKAXE_HEATER.value()));
            Level level = player.getCommandSenderWorld();
            if (level.isClientSide() || !((item = stack.getItem()) instanceof PickaxeHeaterItem) || !(relic = (PickaxeHeaterItem)item).isAbilityTicking(stack, "heater") || PickaxeHeaterItem.getCharges(stack) <= 1) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            boolean smelted = false;
            for (ItemEntity drop : event.getDrops()) {
                ItemStack source = drop.getItem();
                ItemStack result = PickaxeHeaterItem.getSmeltingResult(source, serverLevel);
                if (!smelted && source != result) {
                    smelted = true;
                }
                drop.setItem(result);
            }
            if (smelted) {
                Vec3 center = event.getPos().getCenter();
                RandomSource random = level.getRandom();
                serverLevel.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(106), random.nextInt(50), 50 + random.nextInt(51), 255), (float)0.6f, (int)20, (float)0.85f), center.x(), center.y(), center.z(), 25, 0.3, 0.3, 0.3, 0.01);
                PickaxeHeaterItem.addCharges(stack, -1);
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

