/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.PolarBear;

public class BrownBearModel<T extends PolarBear>
extends QuadrupedModel<T> {
    public static final ModelLayerLocation BODY_LAYER = new ModelLayerLocation(Constants.id("brown_bear"), "main");

    public BrownBearModel(ModelPart root) {
        super(root, true, 16.0f, 4.0f, 2.25f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -5.0f, -7.0f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 56).addBox(-2.5f, -2.0f, -11.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(21, 61).addBox(3.5f, -6.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(21, 61).addBox(-5.5f, -6.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.0f, (float)-13.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 30).addBox(-5.0f, -13.0f, -7.0f, 14.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(-4.0f, -25.0f, -7.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)9.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(50, 30).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)14.0f, (float)6.0f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(50, 30).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)14.0f, (float)6.0f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(50, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)14.0f, (float)-8.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(50, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)14.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)((PolarBear)entity).tickCount;
        float standAnimationScale = entity.getStandingAnimationScale(partialTick);
        standAnimationScale *= standAnimationScale;
        float complement = 1.0f - standAnimationScale;
        this.body.xRot = 1.5707964f - standAnimationScale * (float)Math.PI * 0.35f;
        this.body.y = 9.0f * complement + 11.0f * standAnimationScale;
        this.rightFrontLeg.y = 14.0f * complement - 6.0f * standAnimationScale;
        this.rightFrontLeg.z = -8.0f * complement - 4.0f * standAnimationScale;
        ModelPart modelPart = this.rightFrontLeg;
        modelPart.xRot -= standAnimationScale * (float)Math.PI * 0.45f;
        this.leftFrontLeg.y = this.rightFrontLeg.y;
        this.leftFrontLeg.z = this.rightFrontLeg.z;
        modelPart = this.leftFrontLeg;
        modelPart.xRot -= standAnimationScale * (float)Math.PI * 0.45f;
        if (this.young) {
            this.head.y = 10.0f * complement - 9.0f * standAnimationScale;
            this.head.z = -14.0f * complement - 8.0f * standAnimationScale;
        } else {
            this.head.y = 10.0f * complement - 12.0f * standAnimationScale;
            this.head.z = -14.0f * complement - 1.0f * standAnimationScale;
        }
        modelPart = this.head;
        modelPart.xRot += standAnimationScale * (float)Math.PI * 0.15f;
    }
}

