/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.core.registry;

import dev.orderedchaos.projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BeachGrassBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BeachedKelpBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BoggedRemainsBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.CindercaneBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.DoubleHighWaterPlantBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.FallenLeavesBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GlowcapBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GlowingFungusBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.HollowLogBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.IcicleBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.LotusBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.MuddyBonesBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.NaturalCobwebBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.NetherPlantBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.PinkVinesBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.PinkVinesPlantBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.SandySproutsBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.SeaOatsBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.ShortGrassBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.SlimeNoduleBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.SmallCactusBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.ThornsBlock;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PVJBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"projectvibrantjourneys");
    public static final DeferredBlock<Block> BEACH_GRASS = PVJBlocks.registerBlock("beach_grass", () -> new BeachGrassBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT));
    public static final DeferredBlock<Block> SEA_OATS = PVJBlocks.registerBlock("sea_oats", () -> new SeaOatsBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT));
    public static final DeferredBlock<Block> CATTAIL = PVJBlocks.registerBlock("cattail", () -> new DoubleHighWaterPlantBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT, true));
    public static final DeferredBlock<Block> BARK_MUSHROOM = PVJBlocks.registerBlock("bark_mushroom", () -> new BarkMushroomBlock(BlockBehaviorTemplates.BARK_MUSHROOM));
    public static final DeferredBlock<Block> LIGHT_BROWN_BARK_MUSHROOM = PVJBlocks.registerBlock("light_brown_bark_mushroom", () -> new BarkMushroomBlock(BlockBehaviorTemplates.BARK_MUSHROOM));
    public static final DeferredBlock<Block> ORANGE_BARK_MUSHROOM = PVJBlocks.registerBlock("orange_bark_mushroom", () -> new BarkMushroomBlock(BlockBehaviorTemplates.BARK_MUSHROOM));
    public static final DeferredBlock<Block> WHITE_BARK_MUSHROOM = PVJBlocks.registerBlock("white_bark_mushroom", () -> new BarkMushroomBlock(BlockBehaviorTemplates.BARK_MUSHROOM));
    public static final DeferredBlock<Block> GLOWING_BLUE_FUNGUS = PVJBlocks.registerBlock("glowing_blue_fungus", () -> new GlowingFungusBlock(BlockBehaviorTemplates.BARK_MUSHROOM.lightLevel(state -> 6).sound(SoundType.SMALL_DRIPLEAF).emissiveRendering((state, level, pos) -> true)));
    public static final DeferredBlock<Block> SHORT_GRASS = PVJBlocks.registerBlock("short_grass", () -> new ShortGrassBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT));
    public static final DeferredBlock<Block> SMALL_CACTUS = PVJBlocks.registerBlock("small_cactus", () -> new SmallCactusBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).noCollission().instabreak().ignitedByLava().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<Block> PRICKLY_BUSH = PVJBlocks.registerBlock("prickly_bush", () -> new ThornsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).mapColor(MapColor.COLOR_BROWN)));
    public static final DeferredBlock<Block> REEDS = PVJBlocks.registerBlock("reeds", () -> new DoubleHighWaterPlantBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT, true));
    public static final DeferredBlock<Block> ICICLE = PVJBlocks.registerBlock("icicle", () -> new IcicleBlock(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).noOcclusion().sound(SoundType.GLASS).randomTicks().strength(1.5f, 3.0f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<Block> SANDY_SPROUTS = PVJBlocks.registerBlock("sandy_sprouts", () -> new SandySproutsBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT));
    public static final DeferredBlock<Block> WATERGRASS = PVJBlocks.registerBlock("watergrass", () -> new DoubleHighWaterPlantBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT, false));
    public static final DeferredBlock<Block> BEACHED_KELP = PVJBlocks.registerBlockWithoutItem("beached_kelp", () -> new BeachedKelpBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT.sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.NONE)));
    public static final DeferredBlock<Block> DRIED_BEACHED_KELP = PVJBlocks.registerBlockWithoutItem("dried_beached_kelp", () -> new BeachedKelpBlock(BlockBehaviorTemplates.REPLACEABLE_PLANT.sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.NONE)));
    public static final DeferredBlock<Block> PINK_LOTUS = PVJBlocks.registerBlockWithoutItem("pink_lotus", () -> new LotusBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().sound(SoundType.LILY_PAD).noCollission().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> YELLOW_WILDFLOWERS = PVJBlocks.registerBlock("yellow_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> ORANGE_WILDFLOWERS = PVJBlocks.registerBlock("orange_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> BLUE_WILDFLOWERS = PVJBlocks.registerBlock("blue_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> PURPLE_WILDFLOWERS = PVJBlocks.registerBlock("purple_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> WHITE_WILDFLOWERS = PVJBlocks.registerBlock("white_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> MIXED_WILDFLOWERS = PVJBlocks.registerBlock("mixed_wildflowers", () -> new PinkPetalsBlock(BlockBehaviorTemplates.WILDFLOWERS));
    public static final DeferredBlock<Block> BOGGED_REMAINS = PVJBlocks.registerBlock("bogged_remains", () -> new BoggedRemainsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).dynamicShape().sound(SoundType.BONE_BLOCK).pushReaction(PushReaction.DESTROY).offsetType(BlockBehaviour.OffsetType.XYZ).instrument(NoteBlockInstrument.SKELETON).strength(1.0f)));
    public static final DeferredBlock<Block> SLIME_NODULE = PVJBlocks.registerBlock("slime_nodule", () -> new SlimeNoduleBlock(BlockBehaviour.Properties.of().noCollission().lightLevel(state -> 5).sound(SoundType.SLIME_BLOCK).destroyTime(0.2f)));
    public static final DeferredBlock<Block> PINK_VINES_PLANT = PVJBlocks.registerBlockWithoutItem("pink_vines_plant", () -> new PinkVinesPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollission().instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> PINK_VINES = PVJBlocks.registerBlock("pink_vines", () -> new PinkVinesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollission().instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> CRIMSON_NETTLE = PVJBlocks.registerBlock("crimson_nettle", () -> new NetherPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_NYLIUM).noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> WARPED_NETTLE = PVJBlocks.registerBlock("warped_nettle", () -> new NetherPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_NYLIUM).noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> CINDERCANE = PVJBlocks.registerBlock("cindercane", () -> new CindercaneBlock(BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).noCollission().randomTicks().instabreak().sound(SoundType.TWISTING_VINES).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> GLOWCAP = PVJBlocks.registerBlock("glowcap", () -> new GlowcapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 12).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> GLOWCAP_BLOCK = PVJBlocks.registerBlock("huge_glowcap_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(0.2f).lightLevel(state -> 12).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> FALLEN_LEAVES = PVJBlocks.registerBlock("oak_fallen_leaves", () -> new FallenLeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).noCollission().strength(0.1f, 0.0f).ignitedByLava().sound(SoundType.GRASS).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> DEAD_FALLEN_LEAVES = PVJBlocks.registerBlock("dead_fallen_leaves", () -> new FallenLeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).noCollission().strength(0.1f, 0.0f).ignitedByLava().sound(SoundType.GRASS).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> TWIGS = PVJBlocks.registerBlock("twigs", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.CROP, true)));
    public static final DeferredBlock<Block> BIRCH_TWIGS = PVJBlocks.registerBlock("birch_twigs", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.CROP, true)));
    public static final DeferredBlock<Block> ROCKS = PVJBlocks.registerBlock("rocks", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.STONE, false)));
    public static final DeferredBlock<Block> MOSSY_ROCKS = PVJBlocks.registerBlock("mossy_rocks", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.STONE, false)));
    public static final DeferredBlock<Block> SANDSTONE_ROCKS = PVJBlocks.registerBlock("sandstone_rocks", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.STONE, false)));
    public static final DeferredBlock<Block> RED_SANDSTONE_ROCKS = PVJBlocks.registerBlock("red_sandstone_rocks", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.STONE, false)));
    public static final DeferredBlock<Block> ICE_CHUNKS = PVJBlocks.registerBlock("ice_chunks", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.GLASS, false)));
    public static final DeferredBlock<Block> BONES = PVJBlocks.registerBlock("bones", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.BONE_BLOCK, false)));
    public static final DeferredBlock<Block> CHARRED_BONES = PVJBlocks.registerBlock("charred_bones", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.BONE_BLOCK, false)));
    public static final DeferredBlock<Block> PINECONES = PVJBlocks.registerBlock("pinecones", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.CROP, true)));
    public static final DeferredBlock<Block> SEASHELLS = PVJBlocks.registerBlock("seashells", () -> new GroundcoverBlock(BlockBehaviorTemplates.groundcover(SoundType.STONE, false)));
    public static final DeferredBlock<Block> FERROUS_GRAVEL = PVJBlocks.registerBlock("ferrous_gravel", () -> new ColoredFallingBlock(new ColorRGBA(-8356741), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GRAVEL)));
    public static final DeferredBlock<Block> GILDED_GRAVEL = PVJBlocks.registerBlock("gilded_gravel", () -> new ColoredFallingBlock(new ColorRGBA(-8356741), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GRAVEL)));
    public static final DeferredBlock<Block> GILDED_RED_SAND = PVJBlocks.registerBlock("gilded_red_sand", () -> new ColoredFallingBlock(new ColorRGBA(11098145), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND)));
    public static final DeferredBlock<Block> MUDDY_BONES = PVJBlocks.registerBlock("muddy_bones", () -> new MuddyBonesBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.TERRACOTTA_CYAN).isValidSpawn(BlockBehaviorTemplates::always).isRedstoneConductor(BlockBehaviorTemplates::always).isViewBlocking(BlockBehaviorTemplates::always).isSuffocating(BlockBehaviorTemplates::always).sound(SoundType.MUD)));
    public static final DeferredBlock<Block> NATURAL_COBWEB = PVJBlocks.registerBlockWithoutItem("natural_cobweb", NaturalCobwebBlock::new);
    public static final DeferredBlock<Block> OAK_HOLLOW_LOG = PVJBlocks.registerBlock("oak_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> BIRCH_HOLLOW_LOG = PVJBlocks.registerBlock("birch_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BIRCH_LOG)));
    public static final DeferredBlock<Block> SPRUCE_HOLLOW_LOG = PVJBlocks.registerBlock("spruce_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_LOG)));
    public static final DeferredBlock<Block> JUNGLE_HOLLOW_LOG = PVJBlocks.registerBlock("jungle_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_LOG)));
    public static final DeferredBlock<Block> ACACIA_HOLLOW_LOG = PVJBlocks.registerBlock("acacia_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LOG)));
    public static final DeferredBlock<Block> DARK_OAK_HOLLOW_LOG = PVJBlocks.registerBlock("dark_oak_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_OAK_LOG)));
    public static final DeferredBlock<Block> CHERRY_HOLLOW_LOG = PVJBlocks.registerBlock("cherry_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LOG)));
    public static final DeferredBlock<Block> MANGROVE_HOLLOW_LOG = PVJBlocks.registerBlock("mangrove_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_LOG)));
    public static final DeferredBlock<Block> POTTED_GLOWCAP = PVJBlocks.registerBlockWithoutItem("potted_glowcap", () -> PVJBlocks.createFlowerPot((Block)GLOWCAP.get()));
    public static final DeferredBlock<Block> POTTED_CRIMSON_NETTLE = PVJBlocks.registerBlockWithoutItem("potted_crimson_nettle", () -> PVJBlocks.createFlowerPot((Block)CRIMSON_NETTLE.get()));
    public static final DeferredBlock<Block> POTTED_WARPED_NETTLE = PVJBlocks.registerBlockWithoutItem("potted_warped_nettle", () -> PVJBlocks.createFlowerPot((Block)WARPED_NETTLE.get()));
    public static final DeferredBlock<Block> POTTED_CINDERCANE = PVJBlocks.registerBlockWithoutItem("potted_cindercane", () -> PVJBlocks.createFlowerPot((Block)CINDERCANE.get()));
    public static final DeferredBlock<Block> POTTED_SMALL_CACTUS = PVJBlocks.registerBlockWithoutItem("potted_small_cactus", () -> PVJBlocks.createFlowerPot((Block)SMALL_CACTUS.get()));
    public static final DeferredBlock<Block> POTTED_PRICKLY_BUSH = PVJBlocks.registerBlockWithoutItem("potted_prickly_bush", () -> PVJBlocks.createFlowerPot((Block)PRICKLY_BUSH.get()));

    public static DeferredBlock<Block> registerBlock(String name, Supplier<Block> supplier, boolean addToCreativeTab) {
        DeferredBlock block = BLOCKS.register(name, supplier);
        DeferredItem blockItem = PVJItems.ITEMS.registerSimpleBlockItem(name, (Supplier)block);
        if (addToCreativeTab) {
            PVJItems.ITEMS_FOR_CREATIVE_TAB.add(blockItem);
        }
        return block;
    }

    public static DeferredBlock<Block> registerBlock(String name, Supplier<Block> supplier) {
        return PVJBlocks.registerBlock(name, supplier, true);
    }

    public static DeferredBlock<Block> registerBlockWithoutItem(String name, Supplier<Block> supplier) {
        return BLOCKS.register(name, supplier);
    }

    public static Block createFlowerPot(Block plant) {
        FlowerPotBlock block = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, () -> plant, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).lightLevel(state -> plant == GLOWCAP.get() ? 12 : 0));
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BuiltInRegistries.BLOCK.getKey((Object)plant), () -> PVJBlocks.lambda$createFlowerPot$72((Block)block));
        return block;
    }

    private static /* synthetic */ Block lambda$createFlowerPot$72(Block block) {
        return block;
    }

    public static class BlockBehaviorTemplates {
        public static final BlockBehaviour.Properties REPLACEABLE_PLANT = BlockBehaviorTemplates.replaceablePlant(null);
        public static final BlockBehaviour.Properties BARK_MUSHROOM = BlockBehaviour.Properties.of().noCollission().sound(SoundType.WOOD).destroyTime(0.2f);
        public static final BlockBehaviour.Properties WILDFLOWERS = BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY);

        public static BlockBehaviour.Properties replaceablePlant(@Nullable MapColor mapColorOverride) {
            return BlockBehaviour.Properties.of().replaceable().noCollission().instabreak().mapColor(mapColorOverride != null ? mapColorOverride : MapColor.PLANT).sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY);
        }

        private static BlockBehaviour.Properties groundcover(SoundType soundType, boolean isFlammable) {
            BlockBehaviour.Properties groundcover = BlockBehaviour.Properties.of().strength(0.05f, 0.0f).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).sound(soundType);
            if (isFlammable) {
                groundcover = groundcover.ignitedByLava();
            }
            return groundcover;
        }

        public static boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
            return true;
        }

        public static boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> entityType) {
            return true;
        }
    }
}

