/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.orderedchaos.projectvibrantjourneys.common.world.modifiers.PVJBiomeModifier;
import dev.orderedchaos.projectvibrantjourneys.common.world.modifiers.PVJSpawnModifier;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacements;
import dev.orderedchaos.projectvibrantjourneys.data.tags.PVJTags;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class PVJBiomeModifiers {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"projectvibrantjourneys");
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<PVJBiomeModifier>> BIOME_MODIFIER_SERIALIZER = BIOME_MODIFIER_SERIALIZERS.register("biome_modifier", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("dimension").forGetter(PVJBiomeModifier::dimension), (App)Biome.LIST_CODEC.listOf().fieldOf("biomes").forGetter(PVJBiomeModifier::biomes), (App)Biome.LIST_CODEC.listOf().fieldOf("blacklist").forGetter(PVJBiomeModifier::blacklist), (App)GenerationStep.Decoration.CODEC.fieldOf("decoration").forGetter(PVJBiomeModifier::decoration), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(PVJBiomeModifier::feature), (App)Codec.STRING.fieldOf("configOption").forGetter(PVJBiomeModifier::configOption)).apply((Applicative)builder, PVJBiomeModifier::new)));
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<PVJSpawnModifier>> SPAWN_MODIFIER_SERIALIZER = BIOME_MODIFIER_SERIALIZERS.register("spawn_modifier", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("dimension").forGetter(PVJSpawnModifier::dimension), (App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(PVJSpawnModifier::biomes), (App)MobCategory.CODEC.fieldOf("category").forGetter(PVJSpawnModifier::category), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("data").forGetter(PVJSpawnModifier::data), (App)PrimitiveCodec.STRING.fieldOf("configOption").forGetter(PVJSpawnModifier::configOption)).apply((Applicative)builder, PVJSpawnModifier::new)));

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        PVJBiomeModifiers.bootstrapBiomeModifiers(context);
        PVJBiomeModifiers.bootstrapSpawnModifiers(context);
    }

    public static void bootstrapBiomeModifiers(BootstrapContext<BiomeModifier> context) {
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.TWIGS, new PVJBiomeModifier.Builder(context, "enableTwigs").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.desert(), PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BIRCH_TWIGS, new PVJBiomeModifier.Builder(context, "enableTwigs").tag(List.of(PVJTags.HAS_BIRCH_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.desert(), PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DEAD_FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").extraBiomes(Biomes.WOODED_BADLANDS));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DENSE_DEAD_FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").extraBiomes(Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PINECONES, new PVJBiomeModifier.Builder(context, "enablePinecones").tag(PVJBiomeModifiers.coniferous()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SEASHELLS, new PVJBiomeModifier.Builder(context, "enableSeashells").tag(PVJBiomeModifiers.oceanOrBeach()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.OCEAN_FLOOR_SEASHELLS, new PVJBiomeModifier.Builder(context, "enableSeashells").tag(PVJBiomeModifiers.oceanOrBeach()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ROCKS, new PVJBiomeModifier.Builder(context, "enableRocks").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BONES, new PVJBiomeModifier.Builder(context, "enableBones").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_ROCKS, new PVJBiomeModifier.Builder(context, "enableRocks").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_BONES, new PVJBiomeModifier.Builder(context, "enableBones").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ICE_CHUNKS, new PVJBiomeModifier.Builder(context, "enableIceChunks").tag(PVJBiomeModifiers.snowy()).extraBlacklist(Biomes.SNOWY_BEACH));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MOSS_CARPET, new PVJBiomeModifier.Builder(context, "enableMossCarpets").extraBiomes(Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BARK_MUSHROOM, new PVJBiomeModifier.Builder(context, "enableBarkMushrooms").tag(PVJBiomeModifiers.overworld()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SEA_OATS, new PVJBiomeModifier.Builder(context, "enableSeaOats").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BEACH_GRASS, new PVJBiomeModifier.Builder(context, "enableBeachGrass").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CATTAILS, new PVJBiomeModifier.Builder(context, "enableCattails").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.badlands()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SHORT_GRASS, new PVJBiomeModifier.Builder(context, "enableShortGrass").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(Biomes.SNOWY_PLAINS));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.NATURAL_COBWEB, new PVJBiomeModifier.Builder(context, "enableNaturalCobwebs").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(Biomes.SNOWY_PLAINS));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SMALL_CACTUS, new PVJBiomeModifier.Builder(context, "enableSmallCacti").tag(PVJBiomeModifiers.desert()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_SEAGRASS, new PVJBiomeModifier.Builder(context, "enableExtraSeagrass").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.desert()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_LILYPADS, new PVJBiomeModifier.Builder(context, "enableExtraLilypads").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.desert()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_GRASS, new PVJBiomeModifier.Builder(context, "enableExtraRiverGrass").tag(PVJBiomeModifiers.river()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.TIDE_POOL, new PVJBiomeModifier.Builder(context, "enableTidePools").extraBiomes(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_ROOTS, new PVJBiomeModifier.Builder(context, "enableCaveRoots").tag(PVJBiomeModifiers.overworld()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.REEDS, new PVJBiomeModifier.Builder(context, "enableReeds").tag(PVJBiomeModifiers.plainsType()).extraBlacklist(Biomes.SNOWY_PLAINS));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PRICKLY_BUSH, new PVJBiomeModifier.Builder(context, "enablePricklyBush").extraBiomes(Biomes.WOODED_BADLANDS));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ICICLE, new PVJBiomeModifier.Builder(context, "enableIcicles").tag(PVJBiomeModifiers.snowy()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MORE_ICICLES, new PVJBiomeModifier.Builder(context, "enableIcicles").extraBiomes(Biomes.FROZEN_PEAKS, Biomes.SNOWY_SLOPES));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_ICICLES, new PVJBiomeModifier.Builder(context, "enableIcicles").extraBiomes(Biomes.ICE_SPIKES));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SANDY_SPROUTS, new PVJBiomeModifier.Builder(context, "enableSandySprouts").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.WATERGRASS, new PVJBiomeModifier.Builder(context, "enableWatergrass").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.badlands()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.STONY_SHORE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.GRAVEL_PIT, new PVJBiomeModifier.Builder(context, "enableGravelPits").decoration(GenerationStep.Decoration.LOCAL_MODIFICATIONS).extraBiomes(Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.BIRCH_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.GOLD_PIT, new PVJBiomeModifier.Builder(context, "enableGoldPits").decoration(GenerationStep.Decoration.LOCAL_MODIFICATIONS).tag(List.of(BiomeTags.IS_BADLANDS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BEACHED_KELP, new PVJBiomeModifier.Builder(context, "enableBeachedKelp").extraBiomes(Biomes.BEACH));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DRIED_BEACHED_KELP, new PVJBiomeModifier.Builder(context, "enableDriedBeachedKelp").extraBiomes(Biomes.BEACH));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.GLOWING_BLUE_FUNGUS, new PVJBiomeModifier.Builder(context, "enableGlowingBlueFungus").extraBiomes(Biomes.DEEP_DARK));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CHERRY_GROVE_BAMBOO, new PVJBiomeModifier.Builder(context, "enableCherryGroveBamboo").extraBiomes(Biomes.CHERRY_GROVE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MUDDY_BONES, new PVJBiomeModifier.Builder(context, "enableMuddyBones").extraBiomes(Biomes.MANGROVE_SWAMP));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.LOTUS_POND, new PVJBiomeModifier.Builder(context, "enableLotusPonds").decoration(GenerationStep.Decoration.LOCAL_MODIFICATIONS).extraBiomes(Biomes.CHERRY_GROVE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.FLOATING_PINK_LOTUS, new PVJBiomeModifier.Builder(context, "enableFloatingPinkLotus").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.HOT_SPRINGS, new PVJBiomeModifier.Builder(context, "enableHotSprings").tag(List.of(BiomeTags.IS_TAIGA)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.OAK_BUSH, new PVJBiomeModifier.Builder(context, "enableBushes").tag(PVJBiomeModifiers.plainsType()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.YELLOW_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ORANGE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BLUE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PURPLE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.WHITE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MIXED_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.MEADOW));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_YELLOW_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_ORANGE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_BLUE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_PURPLE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_WHITE_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANY_MIXED_WILDFLOWERS, new PVJBiomeModifier.Builder(context, "enableWildflowers").extraBiomes(Biomes.FLOWER_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BOGGED_REMAINS, new PVJBiomeModifier.Builder(context, "enableBoggedRemains").tag(List.of(Tags.Biomes.IS_SWAMP)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SLIME_NODULE, new PVJBiomeModifier.Builder(context, "enableSlimeNodules").tag(List.of(Tags.Biomes.IS_SWAMP)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PINK_VINES, new PVJBiomeModifier.Builder(context, "enablePinkVines").extraBiomes(Biomes.CHERRY_GROVE));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.OAK_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_OAK_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BIRCH_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_BIRCH_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SPRUCE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_SPRUCE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.JUNGLE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_JUNGLE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ACACIA_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_ACACIA_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DARK_OAK_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_DARK_OAK_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CHERRY_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_CHERRY_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANGROVE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_MANGROVE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CHARRED_BONES, new PVJBiomeModifier.Builder(context, "enableCharredBones").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.IS_NETHER)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.GLOWCAP, new PVJBiomeModifier.Builder(context, "enableGlowcap").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.IS_NETHER)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CINDERCANE, new PVJBiomeModifier.Builder(context, "enableCindercane").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.IS_NETHER)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.WARPED_NETTLE, new PVJBiomeModifier.Builder(context, "enableNetherNettles").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).extraBiomes(Biomes.WARPED_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CRIMSON_NETTLE, new PVJBiomeModifier.Builder(context, "enableNetherNettles").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).extraBiomes(Biomes.CRIMSON_FOREST));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.NETHER_BONES, new PVJBiomeModifier.Builder(context, "enableBones").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).extraBiomes(Biomes.SOUL_SAND_VALLEY));
    }

    public static void bootstrapSpawnModifiers(BootstrapContext<BiomeModifier> context) {
        PVJBiomeModifiers.addSpawnModifier(context, "tropical_fish_in_jungles", (TagKey<Biome>)BiomeTags.IS_OVERWORLD, (TagKey<Biome>)BiomeTags.IS_JUNGLE, MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 5, 5), "enableJungleTropicalFish");
    }

    private static void addBiomeModifier(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeatureKey, PVJBiomeModifier.Builder builder) {
        PVJBiomeModifier modifier = builder.placedFeature(placedFeatureKey).build();
        ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)placedFeatureKey.location());
        context.register(key, (Object)modifier);
    }

    private static void addSpawnModifier(BootstrapContext<BiomeModifier> context, String spawnName, TagKey<Biome> dimension, TagKey<Biome> biomes, MobCategory mobCategory, MobSpawnSettings.SpawnerData spawnerData, String configOption) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectvibrantjourneys", (String)spawnName));
        PVJSpawnModifier modifier = new PVJSpawnModifier(dimension, (HolderSet<Biome>)biomeGetter.getOrThrow(biomes), mobCategory, spawnerData, configOption);
        context.register(key, (Object)modifier);
    }

    private static List<TagKey<Biome>> forestOrPlains() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.IS_FOREST);
    }

    private static List<TagKey<Biome>> plainsType() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.IS_SAVANNA);
    }

    private static List<TagKey<Biome>> oceanOrBeach() {
        return List.of(BiomeTags.IS_BEACH, BiomeTags.IS_OCEAN);
    }

    private static List<TagKey<Biome>> badlands() {
        return List.of(BiomeTags.IS_BADLANDS);
    }

    private static List<TagKey<Biome>> beach() {
        return List.of(BiomeTags.IS_BEACH);
    }

    private static List<TagKey<Biome>> river() {
        return List.of(BiomeTags.IS_RIVER);
    }

    private static List<TagKey<Biome>> coniferous() {
        return List.of(Tags.Biomes.IS_CONIFEROUS_TREE);
    }

    private static List<TagKey<Biome>> snowy() {
        return List.of(Tags.Biomes.IS_SNOWY);
    }

    private static List<TagKey<Biome>> mushroom() {
        return List.of(Tags.Biomes.IS_MUSHROOM);
    }

    private static List<ResourceKey<Biome>> veryCold() {
        return List.of(Biomes.FROZEN_RIVER, Biomes.SNOWY_PLAINS, Biomes.SNOWY_BEACH, Biomes.SNOWY_SLOPES, Biomes.ICE_SPIKES, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.JAGGED_PEAKS);
    }

    private static List<TagKey<Biome>> desert() {
        return List.of(BiomeTags.HAS_DESERT_PYRAMID, BiomeTags.IS_BADLANDS, BiomeTags.HAS_VILLAGE_DESERT);
    }

    private static List<TagKey<Biome>> overworld() {
        return List.of(BiomeTags.IS_OVERWORLD);
    }

    private static List<TagKey<Biome>> nether() {
        return List.of(BiomeTags.IS_NETHER);
    }
}

