/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal;

import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.RuinedPortalDecoratorBase;
import dev.orderedchaos.projectvibrantjourneys.core.util.LevelUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;

public class CrimsonForestRuinedPortalDecorator
extends RuinedPortalDecoratorBase {
    public CrimsonForestRuinedPortalDecorator() {
        super("crimson_forest_ruined_portal_decorator");
    }

    @Override
    @Nullable
    public BlockState getTopSoil(WorldGenLevel level, RandomSource random) {
        float chance = random.nextFloat();
        if (chance <= 0.75f) {
            return Blocks.CRIMSON_NYLIUM.defaultBlockState();
        }
        return null;
    }

    @Override
    @Nullable
    public BlockState getFillerSoil(WorldGenLevel level, RandomSource random) {
        float oreChance = random.nextFloat();
        if (oreChance <= 0.03f) {
            return Blocks.NETHER_QUARTZ_ORE.defaultBlockState();
        }
        if (oreChance <= 0.05f) {
            return Blocks.NETHER_GOLD_ORE.defaultBlockState();
        }
        return null;
    }

    @Override
    public void decorate(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos groundPos) {
        BlockPos pos = groundPos.above();
        if (LevelUtils.isEmptyOrReplaceable((ServerLevelAccessor)level, pos)) {
            float chance = random.nextFloat();
            if (chance < 0.02f) {
                Optional bigMushroom = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(TreeFeatures.CRIMSON_FUNGUS);
                bigMushroom.ifPresent(feature -> ((ConfiguredFeature)feature.value()).place(level, generator, random, pos));
            } else if (chance < 0.15f) {
                Optional warpedForestVegetation = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(NetherFeatures.CRIMSON_FOREST_VEGETATION);
                warpedForestVegetation.ifPresent(feature -> ((ConfiguredFeature)feature.value()).place(level, generator, random, pos));
            } else if (chance < 0.25f) {
                Optional twistingVines = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(NetherFeatures.WEEPING_VINES);
                twistingVines.ifPresent(feature -> ((ConfiguredFeature)feature.value()).place(level, generator, random, pos));
            }
        }
    }
}

