/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class LithostitchedSurfaceRules
extends SurfaceRules {

    public record TransientMergedRuleSource(List<SurfaceRules.RuleSource> sequence, SurfaceRules.RuleSource original) implements SurfaceRules.RuleSource
    {
        public static final KeyDispatchDataCodec<SurfaceRules.RuleSource> CODEC = KeyDispatchDataCodec.of((MapCodec)SurfaceRules.RuleSource.CODEC.xmap(source -> source, source -> {
            SurfaceRules.RuleSource ruleSource;
            if (source instanceof TransientMergedRuleSource) {
                TransientMergedRuleSource transientMergedRuleSource = (TransientMergedRuleSource)source;
                ruleSource = transientMergedRuleSource.original;
            } else {
                ruleSource = source;
            }
            return ruleSource;
        }).fieldOf("original_source"));

        public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            if (this.sequence.size() == 1) {
                return (SurfaceRules.SurfaceRule)this.sequence.get(0).apply((Object)context);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SurfaceRules.RuleSource ruleSource : this.sequence) {
                builder.add((Object)((SurfaceRules.SurfaceRule)ruleSource.apply((Object)context)));
            }
            builder.add((Object)((SurfaceRules.SurfaceRule)this.original.apply((Object)context)));
            return new SequenceRule((List<SurfaceRules.SurfaceRule>)builder.build());
        }
    }

    private record SequenceRule(List<SurfaceRules.SurfaceRule> rules) implements SurfaceRules.SurfaceRule
    {
        public BlockState tryApply(int x, int y, int z) {
            for (SurfaceRules.SurfaceRule surfaceRule : this.rules) {
                BlockState blockstate = surfaceRule.tryApply(x, y, z);
                if (blockstate == null) continue;
                return blockstate;
            }
            return null;
        }
    }
}

