/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import java.nio.Buffer;
import java.util.stream.Stream;

@FunctionalInterface
public interface MapWriter<T> {
    public <S> S serialize(T var1, NodeEmitter<S> var2);

    public static interface NodeEmitter<S> {
        public S makeEmpty();

        public S makeBoolean(boolean var1);

        public S makeByte(byte var1);

        public S makeShort(short var1);

        public S makeInt(int var1);

        public S makeLong(long var1);

        public S makeFloat(float var1);

        public S makeDouble(double var1);

        public S makeString(String var1);

        public S makeBlob(Buffer var1);

        public S makeList(Stream<S> var1);

        public ListBuilder<S> buildList();

        public MapBuilder<S> buildMap();

        public static interface MapBuilder<S> {
            public MapBuilder<S> put(String var1, S var2);

            public S make();
        }

        public static interface ListBuilder<S> {
            public ListBuilder<S> add(S var1);

            public ListBuilder<S> addAll(Iterable<S> var1);

            public S make();
        }
    }

    @FunctionalInterface
    public static interface Unchecked<T, S> {
        public S serialize(T var1, NodeEmitter<S> var2);
    }
}

