/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.registries.CoreContent;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;

public class CodecUtils {
    private static final Codec.ResultFunction<ItemStack> MISSING_CONTENT_ITEMSTACK_RESULT = new Codec.ResultFunction<ItemStack>(){
        public static final Set<String> existingDesErrors = new HashSet<String>();
        public static final Set<String> existingSerErrors = new HashSet<String>();

        public <T> DataResult<Pair<ItemStack, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<ItemStack, T>> a) {
            if (a instanceof DataResult.Error) {
                Object object;
                DataResult.Error error = (DataResult.Error)a;
                ItemStack missingContent = CoreContent.Item.Errored.stack();
                Tag convert = (Tag)Dynamic.convert(ops, (DynamicOps)NbtOps.INSTANCE, input);
                if (convert instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)convert;
                    missingContent.set(CoreItemDataComponents.MissingContent, (Object)CustomData.of((CompoundTag)compoundTag));
                }
                if (!existingDesErrors.contains(error.message())) {
                    existingDesErrors.add(error.message());
                    XyCore.Logger.error("Failed to deserialize ItemStack: {}", (Object)error.message());
                }
                if (input instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)input;
                    object = "Was " + tag.getString("id");
                } else {
                    object = "Unknown Item";
                }
                String id = object;
                missingContent.set(CoreItemDataComponents.MissingContentError, (Object)new CoreItemDataComponents.ComponentErrorData(error.message(), id));
                return DataResult.success((Object)Pair.of((Object)missingContent, input), (Lifecycle)Lifecycle.stable());
            }
            return a;
        }

        public <T> DataResult<T> coApply(DynamicOps<T> ops, ItemStack input, DataResult<T> t) {
            CustomData originalData;
            if (t instanceof DataResult.Error) {
                DataResult.Error error = (DataResult.Error)t;
                ItemStack missingContent = CoreContent.Item.Errored.stack();
                if (!existingSerErrors.contains(error.message())) {
                    existingSerErrors.add(error.message());
                    XyCore.Logger.error("Failed to serialize ItemStack {}: {}", (Object)input, (Object)error.message());
                }
                missingContent.set(CoreItemDataComponents.MissingContentError, (Object)new CoreItemDataComponents.ComponentErrorData(error.message(), "Was " + input.getDescriptionId()));
                return ItemStack.SINGLE_ITEM_CODEC.encodeStart(ops, (Object)missingContent).setLifecycle(t.lifecycle());
            }
            if (CodecUtils.isEqualItemType(CoreContent.Item.Errored.stack(), input) && (originalData = (CustomData)input.get(CoreItemDataComponents.MissingContent)) != null) {
                return DataResult.success((Object)Dynamic.convert((DynamicOps)NbtOps.INSTANCE, ops, (Object)originalData.getUnsafe()), (Lifecycle)t.lifecycle());
            }
            return t;
        }
    };
    private static final Codec.ResultFunction<FluidStack> MISSING_CONTENT_FLUIDSTACK_RESULT = new Codec.ResultFunction<FluidStack>(){
        public static final Set<String> existingDesErrors = new HashSet<String>();
        public static final Set<String> existingSerErrors = new HashSet<String>();

        public <T> DataResult<Pair<FluidStack, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<FluidStack, T>> a) {
            if (a instanceof DataResult.Error) {
                Object object;
                DataResult.Error error = (DataResult.Error)a;
                FluidStack missingContent = CoreContent.Fluid.Errored.fluid(1);
                Tag convert = (Tag)Dynamic.convert(ops, (DynamicOps)NbtOps.INSTANCE, input);
                if (convert instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)convert;
                    missingContent.set(CoreItemDataComponents.MissingContent, (Object)CustomData.of((CompoundTag)compoundTag));
                }
                if (!existingDesErrors.contains(error.message())) {
                    existingDesErrors.add(error.message());
                    XyCore.Logger.error("Failed to deserialize FluidStack: {}", (Object)error.message());
                }
                if (input instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)input;
                    object = "Was " + tag.getString("id");
                } else {
                    object = "Unknown Fluid";
                }
                String id = object;
                missingContent.set(CoreItemDataComponents.MissingContentError, (Object)new CoreItemDataComponents.ComponentErrorData(error.message(), id));
                return DataResult.success((Object)Pair.of((Object)missingContent, input), (Lifecycle)Lifecycle.stable());
            }
            return a;
        }

        public <T> DataResult<T> coApply(DynamicOps<T> ops, FluidStack input, DataResult<T> t) {
            CustomData originalData;
            if (t instanceof DataResult.Error) {
                DataResult.Error error = (DataResult.Error)t;
                ItemStack missingContent = CoreContent.Item.Errored.stack();
                if (!existingSerErrors.contains(error.message())) {
                    existingSerErrors.add(error.message());
                    XyCore.Logger.error("Failed to serialize FluidStack {}: {}", (Object)input, (Object)error.message());
                }
                missingContent.set(CoreItemDataComponents.MissingContentError, (Object)new CoreItemDataComponents.ComponentErrorData(error.message(), "Was " + input.getDescriptionId()));
                return ItemStack.SINGLE_ITEM_CODEC.encodeStart(ops, (Object)missingContent).setLifecycle(t.lifecycle());
            }
            if (CodecUtils.isEqualFluidType(CoreContent.Fluid.Errored.fluid(1), input) && (originalData = (CustomData)input.get(CoreItemDataComponents.MissingContent)) != null) {
                return DataResult.success((Object)Dynamic.convert((DynamicOps)NbtOps.INSTANCE, ops, (Object)originalData.getUnsafe()), (Lifecycle)t.lifecycle());
            }
            return t;
        }
    };

    private CodecUtils() {
    }

    private static boolean isEqualItemType(ItemStack that, ItemStack other) {
        return !that.isEmpty() && !other.isEmpty() && ItemStack.isSameItem((ItemStack)that, (ItemStack)other);
    }

    private static boolean isEqualFluidType(FluidStack that, FluidStack other) {
        return !that.isEmpty() && !other.isEmpty() && FluidStack.isSameFluid((FluidStack)that, (FluidStack)other);
    }

    public static <TKey, TValue> Codec<Map<TKey, TValue>> tupleOf(Codec<TKey> keyCodec, Codec<TValue> valueCodec) {
        return CodecUtils.tupleOf(keyCodec, valueCodec, HashMap::new);
    }

    public static <TKey, TValue, TMap extends Map<TKey, TValue>> Codec<TMap> tupleOf(Codec<TKey> keyCodec, Codec<TValue> valueCodec, Supplier<TMap> mapConstructor) {
        return new GenericMapEntryCodec<TKey, TValue>(keyCodec, valueCodec).listOf().xmap(entries -> {
            Map map = (Map)mapConstructor.get();
            for (Map.Entry entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }, input -> input.entrySet().stream().toList());
    }

    public static <T> Codec<Pair<T, T>> pairOf(Codec<T> codecA) {
        return codecA.listOf().xmap(lst -> Pair.of(lst.getFirst(), lst.get(1)), p -> List.of(p.getFirst(), p.getSecond()));
    }

    public static <T> IAttachmentSerializer<Tag, T> holderWith(final Codec<T> codec, final BiConsumer<T, IAttachmentHolder> setter) {
        return new IAttachmentSerializer<Tag, T>(){

            @NotNull
            public T read(@NotNull IAttachmentHolder holder, @NotNull Tag tag, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                DataResult parse = codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag);
                if (parse.error().isPresent()) {
                    throw new RuntimeException(((DataResult.Error)parse.error().get()).toString());
                }
                if (parse.result().isEmpty()) {
                    throw new RuntimeException("Result not present");
                }
                Object data = parse.result().get();
                setter.accept(data, holder);
                return data;
            }

            public Tag write(@NotNull T attachment, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                DataResult encode = codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), attachment);
                if (encode.error().isPresent()) {
                    throw new RuntimeException(((DataResult.Error)encode.error().get()).toString());
                }
                if (encode.result().isEmpty()) {
                    throw new RuntimeException("Result not present");
                }
                return (Tag)encode.result().get();
            }
        };
    }

    public static class GenericMapEntryCodec<KEY, VALUE>
    implements Codec<Map.Entry<KEY, VALUE>> {
        private final Codec<KEY> keyCodec;
        private final Codec<VALUE> valueCodec;

        public GenericMapEntryCodec(Codec<KEY> keyCodec, Codec<VALUE> valueCodec) {
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        public <T> DataResult<Pair<Map.Entry<KEY, VALUE>, T>> decode(DynamicOps<T> ops, T input) {
            Optional inputList = ops.getList(input).result();
            if (inputList.isEmpty()) {
                return DataResult.error(() -> "Input is not a list");
            }
            ArrayList entries = new ArrayList();
            ((Consumer)inputList.get()).accept(entries::add);
            if (entries.size() != 2) {
                return DataResult.error(() -> "Input not a list of 2 elements");
            }
            return this.keyCodec.decode(ops, entries.get(0)).flatMap(key -> this.valueCodec.decode(ops, entries.get(1)).map(p -> Pair.of(Map.entry(key.getFirst(), p.getFirst()), (Object)p.getSecond())));
        }

        public <T> DataResult<T> encode(Map.Entry<KEY, VALUE> input, DynamicOps<T> ops, T prefix) {
            ListBuilder listBuilder = ops.listBuilder();
            listBuilder.add(this.keyCodec.encodeStart(ops, input.getKey()));
            listBuilder.add(this.valueCodec.encodeStart(ops, input.getValue()));
            return listBuilder.build(prefix);
        }
    }

    @Deprecated(forRemoval=true, since="1.21.0")
    public static interface ISetAttachmentHolder {
        public void setAttachmentHolder(IAttachmentHolder var1);
    }

    public static class Codecs {
        public static final Codec<ItemStack> ITEM_STACK_NON_EMPTY = ItemStack.CODEC.mapResult(MISSING_CONTENT_ITEMSTACK_RESULT);
        public static final Codec<ItemStack> ITEM_STACK_OPTIONAL = ItemStack.OPTIONAL_CODEC.mapResult(MISSING_CONTENT_ITEMSTACK_RESULT);
        public static final Codec<FluidStack> FLUID_STACK_NONEMPTY = FluidStack.CODEC.mapResult(MISSING_CONTENT_FLUIDSTACK_RESULT);
        public static final Codec<FluidStack> FLUID_STACK_OPTIONAL = FluidStack.OPTIONAL_CODEC.mapResult(MISSING_CONTENT_FLUIDSTACK_RESULT);
        public static final Codec<Either<FluidStack, ItemStack>> ContentObject = Codec.either((Codec)FluidStack.OPTIONAL_CODEC, (Codec)ItemStack.OPTIONAL_CODEC);
        public static final Codec<Either<SizedFluidIngredient, SizedIngredient>> ContentObjectIngredient = Codec.either((Codec)SizedFluidIngredient.FLAT_CODEC, (Codec)SizedIngredient.FLAT_CODEC);

        private Codecs() {
        }
    }
}

