/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public enum DyeColors implements IColorSource,
StringRepresentable
{
    White(DyeColor.WHITE),
    Orange(DyeColor.ORANGE),
    Magenta(DyeColor.MAGENTA),
    LightBlue(DyeColor.LIGHT_BLUE),
    Yellow(DyeColor.YELLOW),
    Lime(DyeColor.LIME),
    Pink(DyeColor.PINK),
    Gray(DyeColor.GRAY),
    LightGray(DyeColor.LIGHT_GRAY),
    Cyan(DyeColor.CYAN),
    Purple(DyeColor.PURPLE),
    Blue(DyeColor.BLUE),
    Brown(DyeColor.BROWN),
    Green(DyeColor.GREEN),
    Red(DyeColor.RED),
    Black(DyeColor.BLACK);

    private final int _color;
    private final DyeColor _dye;
    private static Map<DyeColor, DyeColors> colorMapping;
    private final String cachedName;

    private DyeColors(DyeColor color) {
        this._color = ColorUtils.getColorFromDye(color);
        this._dye = color;
        this.cachedName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
    }

    public static DyeColors from(DyeColor dye) {
        return colorMapping.get(dye);
    }

    public String toString() {
        return StringUtils.capitalize((String)this.getSerializedName());
    }

    @NotNull
    public String getSerializedName() {
        return this.cachedName;
    }

    @Override
    public int getColor() {
        return this._color;
    }

    public DyeColor getDye() {
        return this._dye;
    }

    static {
        colorMapping = Arrays.stream(DyeColors.values()).collect(Collectors.toMap(DyeColors::getDye, Function.identity()));
    }
}

