/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TiledIcon {
    public static void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale, @NotNull TextureAtlasSprite sprite, TileConfiguration configuration) {
        SpriteContents spriteContents = sprite.contents();
        TiledIcon.render(matrixStack, x, y, width, height, scale, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), spriteContents.width(), spriteContents.height(), configuration);
    }

    public static void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale, float spriteU0, float spriteU1, float spriteV0, float spriteV1, int spriteWidth, int spriteHeight, TileConfiguration configuration) {
        int yCoord;
        int xCoord;
        int yCoord2;
        int xCoord2;
        float invScale = 1.0f / scale;
        int tileX = (int)(width * invScale / (float)spriteWidth);
        int tileY = (int)(height * invScale / (float)spriteHeight);
        float modWidth = width * invScale % (float)spriteWidth;
        float modHeight = height * invScale % (float)spriteHeight;
        matrixStack.pushPose();
        matrixStack.translate(x, y, 0.0f);
        if (!configuration.reverse) {
            matrixStack.translate(configuration.maxWidth, configuration.maxHeight, 0.0f);
        }
        matrixStack.scale(configuration.reverse ? scale : -scale, configuration.reverse ? scale : -scale, scale);
        float u = 16.0f * modWidth / (float)spriteWidth;
        float v = 16.0f * modHeight / (float)spriteHeight;
        if (!configuration.reverse) {
            u = 16.0f - u;
            v = 16.0f - v;
        }
        float u0 = configuration.reverse ? spriteU0 : spriteU1;
        float u1 = configuration.reverse ? spriteU1 : spriteU0;
        float v0 = configuration.reverse ? spriteV0 : spriteV1;
        float v1 = configuration.reverse ? spriteV1 : spriteV0;
        boolean offset = false;
        BlitStream blitStream = BlitStream.create();
        blitStream.begin();
        for (int i = 0; i < tileX; ++i) {
            for (int j = 0; j < tileY; ++j) {
                xCoord2 = i * spriteWidth;
                yCoord2 = j * spriteHeight;
                int xCoordWidth = xCoord2 + spriteWidth;
                int yCoordHeight = yCoord2 + spriteHeight;
                blitStream.blit(matrixStack.last().pose(), xCoord2, xCoordWidth, yCoord2, yCoordHeight, (float)offset, u0, u1, v0, v1);
            }
        }
        float spriteVCommon = spriteV0 + (spriteV1 - spriteV0) * v / 16.0f;
        float spriteUCommon = spriteU0 + (spriteU1 - spriteU0) * u / 16.0f;
        u1 = configuration.reverse ? spriteU1 : spriteU0;
        v1 = spriteVCommon;
        for (int i = 0; i < tileX; ++i) {
            xCoord = i * spriteWidth;
            yCoord = tileY * spriteHeight;
            int xCoordWidth = xCoord + spriteWidth;
            float yCoordHeight = (float)yCoord + modHeight;
            blitStream.blit(matrixStack.last().pose(), xCoord, xCoordWidth, yCoord, yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        u1 = spriteUCommon;
        v1 = configuration.reverse ? spriteV1 : spriteV0;
        for (int j = 0; j < tileY; ++j) {
            xCoord = tileX * spriteWidth;
            yCoord = j * spriteHeight;
            float xCoordWidth = (float)xCoord + modWidth;
            int yCoordHeight = yCoord + spriteHeight;
            blitStream.blit(matrixStack.last().pose(), xCoord, xCoordWidth, yCoord, yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        xCoord2 = tileX * spriteWidth;
        yCoord2 = tileY * spriteHeight;
        float xCoordWidth = (float)xCoord2 + modWidth;
        float yCoordHeight = (float)yCoord2 + modHeight;
        u1 = spriteUCommon;
        v1 = spriteVCommon;
        blitStream.blit(matrixStack.last().pose(), xCoord2, xCoordWidth, yCoord2, yCoordHeight, (float)offset, u0, u1, v0, v1);
        blitStream.draw();
        matrixStack.popPose();
    }

    public static void innerBlit(@NotNull GuiGraphics graphics, float x0, float x1, float y0, float y1, float offset, float u0, float u1, float v0, float v1) {
        TiledIcon.innerBlit(graphics.pose().last().pose(), x0, x1, y0, y1, offset, u0, u1, v0, v1);
    }

    public static void innerBlit(Matrix4f matrix, float x0, float x1, float y0, float y1, float zOffset, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix, x0, y1, zOffset).setUv(u0, v1);
        bufferbuilder.addVertex(matrix, x1, y1, zOffset).setUv(u1, v1);
        bufferbuilder.addVertex(matrix, x1, y0, zOffset).setUv(u1, v0);
        bufferbuilder.addVertex(matrix, x0, y0, zOffset).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public record TileConfiguration(boolean reverse, float maxWidth, float maxHeight) {
        public TileConfiguration() {
            this(true, 0.0f, 0.0f);
        }
    }

    public static class BlitStream {
        private BufferBuilder bufferBuilder;

        private BlitStream() {
        }

        public static BlitStream create() {
            return new BlitStream();
        }

        public void begin() {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            this.bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        }

        public void blit(Matrix4f matrix, float x0, float x1, float y0, float y1, float zOffset, float u0, float u1, float v0, float v1) {
            this.bufferBuilder.addVertex(matrix, x0, y1, zOffset).setUv(u0, v1);
            this.bufferBuilder.addVertex(matrix, x1, y1, zOffset).setUv(u1, v1);
            this.bufferBuilder.addVertex(matrix, x1, y0, zOffset).setUv(u1, v0);
            this.bufferBuilder.addVertex(matrix, x0, y0, zOffset).setUv(u0, v0);
        }

        public void draw() {
            BufferUploader.drawWithShader((MeshData)this.bufferBuilder.buildOrThrow());
        }
    }
}

