/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotClickPacket;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotScrollPacket;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.slots.ColoredSlot;
import tv.soaryn.xycraft.core.ui.slots.GhostSlot;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IClickCallback;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IDragCallback;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableBackground;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableCanvas;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFrame;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableImage;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;

public class BaseMenuUI<T extends BaseMenu>
extends AbstractContainerScreen<T> {
    public float Time;
    public DrawableCanvas rootCanvas = DrawableCanvas.create();
    private final ResourceLocation _lockResource = XyCore.resource("textures/gui/lock.png");
    final NineSlicedResource slotUi = new NineSlicedResource(XyCore.resource("textures/gui/sliced/slot.png"));
    final NineSlicedResource slotHighlight = new NineSlicedResource(XyCore.resource("textures/gui/sliced/slot_highlight.png"));

    public BaseMenuUI(T menu, Inventory playerInv, Component title, int width, int height) {
        super(menu, playerInv, title);
        this.imageWidth = width;
        this.imageHeight = height;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public static void setLerpTargetForBlockEntity(DrawableBackground widget, BlockEntity blockEntity, LerpContext context) {
        int targetColor = FavoredColor.of((IAttachmentHolder)blockEntity);
        if (context.TargetColor == targetColor) {
            return;
        }
        context.TargetColor = targetColor;
        context.CurrentColor = widget.Color;
        context.Time = 0.0f;
    }

    public static void lerpWidgetColorForBlockEntity(DrawableBackground widget, float partialTick, LerpContext context) {
        if (context.Time >= 1.0f) {
            return;
        }
        context.Time += partialTick * ((Double)XyCore.ClientConfig.UIInterpolationSpeed.get()).floatValue();
        int result = context.Time >= 1.0f ? context.TargetColor : FastColor.ARGB32.lerp((float)context.Time, (int)context.CurrentColor, (int)context.TargetColor);
        widget.color(result);
    }

    protected void init() {
        super.init();
        this.rootCanvas = (DrawableCanvas)DrawableCanvas.create().dimensions(0.0f, 0.0f, this.imageWidth, this.imageHeight);
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected void containerTick() {
        super.containerTick();
        this.rootCanvas.containerTick(this.Time);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.Time += partialTick;
        this.rootCanvas.draw(graphics, this.leftPos, this.topPos, mouseX - this.leftPos, mouseY - this.topPos, 0);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        graphics.setColor(0.6f, 0.6f, 0.6f, 0.9f);
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        for (Slot slot : ((BaseMenu)this.menu).slots) {
            this.slotUi.render(poseStack, left + slot.x - 1, top + slot.y - 1, 18.0f, 18.0f, 1.0f);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (Slot slot : ((BaseMenu)this.menu).slots) {
            ColoredSlot s;
            int color;
            if (!(slot instanceof ColoredSlot) || (color = (s = (ColoredSlot)slot).getColor()) == 0) continue;
            graphics.fill(this.leftPos + slot.x, this.topPos + slot.y, this.leftPos + slot.x + 16, this.topPos + slot.y + 16, color);
        }
        Vector4f rgba = ColorUtils.convertToRGBAVec(-867893334);
        poseStack.pushPose();
        RenderSystem.enableBlend();
        graphics.setColor(rgba.x(), rgba.y(), rgba.z(), rgba.w());
        for (Slot slot : ((BaseMenu)this.menu).slots) {
            GhostSlot s;
            if (!(slot instanceof GhostSlot) || !(s = (GhostSlot)slot).isStrict()) continue;
            this.slotHighlight.render(poseStack, left + slot.x - 1, top + slot.y - 1, 18.0f, 18.0f, 1.0f);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
    }

    protected void renderSlotContents(@NotNull GuiGraphics guiGraphics, @NotNull ItemStack itemstack, @NotNull Slot slot, @Nullable String countString) {
        GhostSlot s;
        if (slot instanceof GhostSlot && (s = (GhostSlot)slot).isGhostedRender()) {
            this.renderGhostSlot(guiGraphics, itemstack, s, countString);
        } else {
            super.renderSlotContents(guiGraphics, itemstack, slot, countString);
        }
    }

    private void renderGhostSlot(@NotNull GuiGraphics graphics, @NotNull ItemStack itemstack, @NotNull GhostSlot slot, @Nullable String countString) {
        graphics.renderItem(slot.getItem(), slot.x, slot.y);
        graphics.fill(RenderType.guiGhostRecipeOverlay(), slot.x, slot.y, slot.x + 16, slot.y + 16, 0x70888888);
        if (!(itemstack.isEmpty() || itemstack.getCount() == 1 && countString == null)) {
            graphics.pose().pushPose();
            String s = countString == null ? String.valueOf(itemstack.getCount()) : countString;
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            graphics.drawString(this.font, s, slot.x + 19 - 2 - this.font.width(s), slot.y + 6 + 3, -855638017, false);
            graphics.pose().popPose();
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        Vector4f rgba = ColorUtils.convertToRGBAVec(-867893334);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)rgba.x(), (float)rgba.y(), (float)rgba.z(), (float)rgba.w());
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._lockResource);
        Matrix4f pose = graphics.pose().last().pose();
        for (Slot slot : ((BaseMenu)this.menu).slots) {
            GhostSlot s;
            if (!(slot instanceof GhostSlot) || !(s = (GhostSlot)slot).isStrict()) continue;
            TiledIcon.innerBlit(pose, (float)(this.leftPos + slot.x + 10), (float)(this.leftPos + slot.x + 16), (float)(this.topPos + slot.y), (float)(this.topPos + slot.y + 6), 301.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderTooltip(graphics, mouseX, mouseY);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.rootCanvas.renderTick(graphics, this.leftPos, this.topPos, mouseX - this.leftPos, mouseY - this.topPos, 0, this.Time, partialTick);
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        GhostSlot ghostSlot;
        if (!((BaseMenu)this.menu).getCarried().isEmpty()) {
            return;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ArrayList<Component> toolTipList = new ArrayList<Component>();
        Optional optional = Optional.empty();
        ItemStack stack = ItemStack.EMPTY;
        if (((BaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            stack = this.hoveredSlot.getItem();
            toolTipList.addAll(this.getTooltipFromContainerItem(stack));
            optional = stack.getTooltipImage();
        }
        this.rootCanvas.appendToolTips(mouseX - this.leftPos, mouseY - this.topPos, toolTipList);
        Slot slot = this.hoveredSlot;
        if (slot instanceof GhostSlot && (ghostSlot = (GhostSlot)slot).isStrict()) {
            toolTipList.add((Component)Component.translatable((String)"gui.xycraft.slot.strict").withStyle(style -> style.withColor(-867893334)));
        }
        graphics.renderTooltip(this.font, toolTipList, optional, stack, mouseX, mouseY);
    }

    public boolean mouseClicked(double x, double y, int button) {
        GhostSlot ghostSlot;
        Slot slot;
        if (this.hoveredSlot != null && (slot = this.hoveredSlot) instanceof GhostSlot && !(ghostSlot = (GhostSlot)slot).isLocked()) {
            ItemStack carried = ((BaseMenu)this.menu).getCarried();
            ItemStack placed = carried.copy().split(this.hoveredSlot.getMaxStackSize(carried));
            if (button == 2) {
                return super.mouseClicked(x, y, button);
            }
            if (placed.isEmpty()) {
                if (ModifierKey.of(Utils.getClientPlayer())) {
                    if (!this.hoveredSlot.hasItem()) {
                        return false;
                    }
                    XyCore.Network.send(new SBGhostSlotClickPacket(this.hoveredSlot.index, false, !ghostSlot.isStrict()));
                    this.hoveredSlot.setChanged();
                } else {
                    this.hoveredSlot.set(placed);
                    XyCore.Network.send(new SBGhostSlotClickPacket(this.hoveredSlot.index, true, false));
                }
            } else {
                boolean restrict = ModifierKey.of(Utils.getClientPlayer());
                this.hoveredSlot.set(placed);
                XyCore.Network.send(new SBGhostSlotClickPacket(this.hoveredSlot.index, true, restrict));
            }
            return true;
        }
        if (this.rootCanvas.mouseDown(x - (double)this.leftPos, y - (double)this.topPos, button)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.rootCanvas.drag(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.rootCanvas.mouseUp(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double x, double y, double deltaX, double deltaY) {
        GhostSlot slot;
        Slot slot2;
        if (this.hoveredSlot != null && (slot2 = this.hoveredSlot) instanceof GhostSlot && !(slot = (GhostSlot)slot2).isLocked()) {
            ItemStack stack = slot.getItem();
            if (!stack.isEmpty()) {
                int delta = Mth.sign((double)deltaY) * (BaseMenuUI.hasShiftDown() ? 8 : 1);
                stack.setCount(Math.max(1, Math.min(stack.getCount() + delta, slot.getMaxStackSize())));
                XyCore.Network.send(new SBGhostSlotScrollPacket(this.hoveredSlot.index, delta));
            }
            return true;
        }
        return this.rootCanvas.mouseScrolled(x - (double)this.leftPos, y - (double)this.topPos, deltaX, deltaY) || super.mouseScrolled(x, y, deltaX, deltaY);
    }

    public static void backgroundFillWithPlayerColor(DrawableWidget<DrawableBackground> bgrnd) {
        bgrnd.fillParent().color(FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer()));
    }

    public void defaultPlayerPanel(DrawableFrame playerPanel) {
        playerPanel.dimensions(0.0f, 94.0f, playerPanel.Parent.Dimensions.width, 104.0f).addChild(DrawableBackground::create, BaseMenuUI::backgroundFillWithPlayerColor);
    }

    public static void processVelocity(DrawableCanvas widget, GuiGraphics graphics, double x, double y, double mouseX, double mouseY, int depth, float time, float partialTick) {
        if (widget.isDragging()) {
            return;
        }
        widget.move(widget.Velocity.x, widget.Velocity.y);
        widget.clamp(widget.Parent == null ? -2.1474836E9f : 14.0f - widget.Dimensions.width, widget.Parent == null ? 2.1474836E9f : widget.Parent.Dimensions.width - 14.0f, widget.Parent == null ? -2.1474836E9f : 14.0f - widget.Dimensions.height, widget.Parent == null ? 2.1474836E9f : widget.Parent.Dimensions.height - 14.0f);
        widget.Velocity.add((Vector2fc)widget.Acceleration);
        widget.Acceleration.mul(0.0f);
        widget.Velocity.mul(0.98f);
    }

    public static boolean debugDimensions(DrawableImage widget, double x, double y, int button, IClickCallback.Action action) {
        if (button == 0 && action == IClickCallback.Action.Down) {
            XyCore.Logger.debug(widget.getClass().getSimpleName() + " : " + String.valueOf(widget.Dimensions));
        }
        return true;
    }

    public static boolean unboundedDrag(IDragCallback.DragContext ctx) {
        if (!ctx.startedInWidget()) {
            return false;
        }
        if (ctx.button() == 0) {
            return false;
        }
        ctx.widget().Velocity.set((float)ctx.deltaX(), (float)ctx.deltaY());
        float minXBound = ctx.widget().Parent == null ? -2.1474836E9f : 14.0f - ctx.widget().Dimensions.width;
        float minYBound = ctx.widget().Parent == null ? -2.1474836E9f : 14.0f - ctx.widget().Dimensions.height;
        float maxWidth = ctx.widget().Parent == null ? 2.1474836E9f : ctx.widget().Parent.Dimensions.width - 14.0f;
        float maxHeight = ctx.widget().Parent == null ? 2.1474836E9f : ctx.widget().Parent.Dimensions.height - 14.0f;
        ctx.widget().dimensions(Mth.clamp((float)(ctx.widget().Dimensions.x + (float)ctx.deltaX()), (float)minXBound, (float)maxWidth), Mth.clamp((float)(ctx.widget().Dimensions.y + (float)ctx.deltaY()), (float)minYBound, (float)maxHeight), ctx.widget().Dimensions.width, ctx.widget().Dimensions.height);
        return true;
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public static class LerpContext {
        public int CurrentColor;
        public int TargetColor;
        public float Time;
    }
}

