/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.datagen;

import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ItemContent;

public abstract class ItemModelDataGen
extends ItemModelProvider {
    public ItemModelDataGen(PackOutput output, String modId, ExistingFileHelper existingFileHelper) {
        super(output, modId, existingFileHelper);
    }

    protected void customModel(ItemContent content) {
        ResourceLocation resource = this.modLoc(content.modelPath());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(content.id().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)resource.getNamespace(), (String)("item/" + resource.getPath())));
    }

    protected void customModel(EnumMap<XyCraftColors, BlockContent> itemMap) {
        itemMap.values().forEach(wrapper -> this.customModel(wrapper.item(), this.modLoc("block/" + wrapper.modelPath())));
    }

    protected void customModel(BlockContent wrapper) {
        switch (wrapper.getModelType()) {
            case Simple: 
            case Special: 
            case Cloud: {
                this.customModel(wrapper.item(), this.modLoc("block/" + wrapper.id().getPath()));
                break;
            }
            case Connected: {
                this.customModel(wrapper.item(), this.modLoc("block/" + wrapper.modelPath()));
                break;
            }
        }
    }

    protected void customModel(Iterable<BlockContent> itemMap) {
        itemMap.forEach(wrapper -> this.customModel(wrapper.item(), this.modLoc("block/" + wrapper.modelPath())));
    }

    protected void customModel(Item item) {
        this.customModel(item, this.modLoc("block/" + Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)item).getBlock())).getPath()));
    }

    protected void customModel(Item item, ResourceLocation loc) {
        this.withExistingParent(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath(), loc);
    }
}

