/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.datagen;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.data.LanguageProvider;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.Tag;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;
import tv.soaryn.xycraft.core.content.registries.CoreContent;

public class CoreLanguageDataGen
extends LanguageProvider
implements IConditionBuilder {
    private final String locale;

    public CoreLanguageDataGen(PackOutput output, String modId, String locale) {
        super(output, modId, locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        CoreContent.Map.MappedContent.forEach((Consumer<IContent<?>>)((Consumer<IContent>)this::handleLang));
        int r = 167;
        this.add("xycraft.core.system.finished_reloading", "Reload has finished!");
        this.add("unit.xycraft.xynergy", "%s Xynergy");
        this.add("xycraft.warning.experimental", "Experimental: Feature Flag Enabled");
        this.add("gui.xycraft.slot.strict", "Strict Mode");
        this.add("gui.xycraft.slot.strict.set", "Use %1$s to toggle Strict Mode");
        this.add("xycraft.commands.system.frequency", "%s frequency is now set to %s tick(s)");
        this.add("xycraft.commands.system.enabled", "%s world tick system is now %s");
        this.add("description.xycraft.xynergy.consume", "Energy per action: %s");
        this.add("key.category.xycraft_core.key_binds", "XyCraft");
        this.add("key.xycraft_core.modifier_key", "Modifier Key");
        this.add("jei.xycraft.recipe.general.requirement.locked", "Unresearched Recipe");
        this.add("client.xycraft_machines.xynergy.error.distanceSquared", "Nodes are too far apart.");
        for (Tag tag : Tag.TagList) {
            String tagName = tag.getName(this.locale);
            if (tagName == null) continue;
            this.add(tag.tag(), tagName);
        }
        ModConfigSpec clientSpec = XyCore.ClientConfig.getSpec();
        this.add("config.client.xycraft_core.visuals", "Visuals");
        this.add(clientSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ClientConfig.FluidUnit, "Fluid Unit");
        this.add(clientSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ClientConfig.UIInterpolationSpeed, "UI Interpolation Rate");
        this.add("config.client.xycraft_core.debug", "Debug Settings");
        this.add(clientSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ClientConfig.ShowHiddenRecipes, "Show Hidden Recipes");
        this.add(clientSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ClientConfig.ShowItemTags, "Show Item Tags");
        this.add(clientSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ClientConfig.ShowReloadMessage, "Show Reload Message");
        ModConfigSpec serverSpec = XyCore.ServerConfig.getSpec();
        this.add(serverSpec, (ModConfigSpec.ConfigValue<?>)XyCore.ServerConfig.Paradigm, "Energy Paradigm");
    }

    private void handleLang(IContent<?> content) {
        String name = content.getLocalizedName(this.locale);
        if (name == null) {
            return;
        }
        IContent<?> iContent = content;
        Objects.requireNonNull(iContent);
        IContent<?> iContent2 = iContent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockContent.class, ItemContent.class, FluidContent.class}, iContent2, n)) {
            case 0: {
                BlockContent wrapper = (BlockContent)iContent2;
                this.add(wrapper.block(), name);
                break;
            }
            case 1: {
                ItemContent wrapper = (ItemContent)iContent2;
                this.add(wrapper.item(), name);
                break;
            }
            case 2: {
                FluidContent wrapper = (FluidContent)iContent2;
                this.add(((XyFluidType)((Object)wrapper.Type.get())).getDescriptionId(), name);
                break;
            }
        }
    }

    private void add(ModConfigSpec spec, ModConfigSpec.ConfigValue<?> config, String name) {
        Object object = spec.getSpec().get(config.getPath());
        if (!(object instanceof ModConfigSpec.ValueSpec)) {
            return;
        }
        ModConfigSpec.ValueSpec value = (ModConfigSpec.ValueSpec)object;
        this.add(value.getTranslationKey(), name);
    }

    private void handleLang(BlockContent wrapper) {
        this.add(wrapper.block(), wrapper.getLocalizedName(this.locale));
    }

    private void handleLang(ItemContent wrapper) {
        this.add(wrapper.item(), wrapper.getLocalizedName(this.locale));
    }
}

