/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.datagen;

import com.google.gson.JsonObject;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCore;

public class ConnectedModelProvider<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    String connectionHandle = "same_block";
    int tintIndex = -1;
    int baseTintIndex = -1;
    int emissivity = 0;
    int baseEmissivity = 0;

    public ConnectedModelProvider(T parent, ExistingFileHelper existingFileHelper) {
        super(XyCore.resource("connected_textures"), parent, existingFileHelper, false);
    }

    public ConnectedModelProvider<T> setEmissivity(int value) {
        this.emissivity = value;
        return this;
    }

    public ConnectedModelProvider<T> setBaseEmissivity(int value) {
        this.baseEmissivity = value;
        return this;
    }

    @Deprecated
    public ConnectedModelProvider<T> setEmissivity(int base, int connectedTexture) {
        this.baseEmissivity = base;
        this.emissivity = connectedTexture;
        return this;
    }

    public ConnectedModelProvider<T> setBaseTintIndex(int value) {
        this.baseTintIndex = value;
        return this;
    }

    public ConnectedModelProvider<T> setTintIndex(int value) {
        this.tintIndex = value;
        return this;
    }

    @Deprecated
    public ConnectedModelProvider<T> setTintIndex(int base, int connectedTexture) {
        this.baseTintIndex = base;
        this.tintIndex = connectedTexture;
        return this;
    }

    public ConnectedModelProvider<T> connectionHandler(String name) {
        this.connectionHandle = name;
        return this;
    }

    @NotNull
    public JsonObject toJson(@NotNull JsonObject json) {
        JsonObject jObj = super.toJson(json);
        jObj.addProperty("connection_handler", this.connectionHandle);
        jObj.addProperty("base_tint_index", (Number)this.baseTintIndex);
        jObj.addProperty("tint_index", (Number)this.tintIndex);
        jObj.addProperty("base_emissivity", (Number)this.baseEmissivity);
        jObj.addProperty("emissivity", (Number)this.emissivity);
        return jObj;
    }
}

