/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.registries;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.CommonBuilders;
import tv.soaryn.xycraft.core.content.attachments.PaletteAttachment;
import tv.soaryn.xycraft.core.content.attachments.PlayerStageAttachment;
import tv.soaryn.xycraft.core.content.attachments.ProcessingDataAttachment;
import tv.soaryn.xycraft.core.content.attachments.TickDataAttachment;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilitySidedCacheAttachment;
import tv.soaryn.xycraft.core.content.attachments.memory.FastVolumeMemoryLevelAttachment;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.volumes.HydrationVolume;

public interface CoreAttachments {
    public static final IRegister Instance = new IRegister(){

        @Override
        public void register(IEventBus bus) {
            Map.register(bus);
        }
    };
    public static final DeferredRegister<AttachmentType<?>> Map = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"xycraft_core");
    public static final Supplier<AttachmentType<TickDataAttachment>> Tick = Map.register("tick_data", () -> TickDataAttachment.Builder.build());
    public static final Supplier<AttachmentType<Boolean>> ModifierKey = Map.register("modifier_key_data", () -> CommonBuilders.BooleanAttachment.build());
    public static final Supplier<AttachmentType<Integer>> Color = Map.register("favored_color_data", () -> ((AttachmentType.Builder)AttachmentType.builder(XyCraftColors.Blue::getColor).serialize((Codec)Codec.INT).copyOnDeath()).build());
    public static final Supplier<AttachmentType<PaletteAttachment>> Palette = Map.register("palette_data", () -> PaletteAttachment.Builder.build());
    public static final Supplier<AttachmentType<PlayerStageAttachment>> PlayerStageData = Map.register("player_stages_data", () -> PlayerStageAttachment.Builder.build());
    public static final Supplier<AttachmentType<PlayerPowerItemLookupAttachment>> PlayerPowerSourceLookup = Map.register("player_power_source_lookup", () -> PlayerPowerItemLookupAttachment.Builder.build());
    public static final Supplier<AttachmentType<Long>> ProcessTime = Map.register("process_time_data", () -> CommonBuilders.LongZero.build());
    public static final Supplier<AttachmentType<ProcessingDataAttachment>> ProcessingData = Map.register("process_data_data", () -> ProcessingDataAttachment.Builder.build());
    public static final Supplier<AttachmentType<Boolean>> Void = Map.register("void_data", () -> CommonBuilders.BooleanAttachment.build());
    public static final Supplier<AttachmentType<CapabilitySidedCacheAttachment<IItemHandler>>> AdjacentItemCapabilityCache = Map.register("item_capability_cache", () -> CapabilitySidedCacheAttachment.ItemBuilder.build());
    public static final Supplier<AttachmentType<CapabilitySidedCacheAttachment<IFluidHandler>>> AdjacentFluidCapabilityCache = Map.register("fluid_capability_cache", () -> CapabilitySidedCacheAttachment.FluidBuilder.build());
    public static final Supplier<AttachmentType<CapabilitySidedCacheAttachment<IEnergyStorage>>> AdjacentEnergyCapabilityCache = Map.register("energy_capability_cache", () -> CapabilitySidedCacheAttachment.EnergyBuilder.build());
    public static final Supplier<AttachmentType<FastVolumeMemoryLevelAttachment>> FastVolumeLookUp = Map.register("fast_volume_lookup", () -> FastVolumeMemoryLevelAttachment.Builder.build());
    public static final Supplier<AttachmentType<VolumeLevelAttachment<HydrationVolume>>> HydrationVolumeData = Map.register("hydration_volume_data", () -> HydrationVolume.Builder.build());
    public static final Supplier<AttachmentType<BlockTickSystemLevelAttachment>> OreGenTestData = Map.register("ore_gen_system_data", () -> BlockTickSystemLevelAttachment.builder(100L, false).build());
    public static final Supplier<AttachmentType<BlockTickSystemLevelAttachment>> CapCleanupData = Map.register("cap_cleanup_system_data", () -> BlockTickSystemLevelAttachment.builder(1L, true).build());
    public static final Supplier<AttachmentType<BlockTickSystemLevelAttachment>> JanitorData = Map.register("janitor_system", () -> BlockTickSystemLevelAttachment.builder(1L, true).build());
}

