/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities;

import net.minecraft.core.BlockPos;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.network.packets.CBPlayerColorSyncPacket;
import tv.soaryn.xycraft.core.utils.ColorUtils;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
public interface ColorableCapability {
    public static IColorable of(Level level, BlockPos pos) {
        return (IColorable)level.getCapability(CoreCapabilities.Colorable.BLOCK, pos, null);
    }

    public static IColorable of(ItemStack stack) {
        return (IColorable)stack.getCapability(CoreCapabilities.Colorable.ITEM);
    }

    public static IColorable of(Entity entity) {
        return (IColorable)entity.getCapability(CoreCapabilities.Colorable.ENTITY);
    }

    @SubscribeEvent
    public static void tryToColorBlock(UseItemOnBlockEvent event) {
        if (event.getUsePhase() != UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK) {
            return;
        }
        UseOnContext context = event.getUseOnContext();
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor == null) {
            return;
        }
        IColorable cap = (IColorable)level.getCapability(CoreCapabilities.Colorable.BLOCK, pos, null);
        if (cap == null) {
            return;
        }
        int newColor = ColorUtils.getColorFromDyeNoCorrection(dyeColor);
        if (cap.setColor(0, newColor) == IColorable.Result.DENIED) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(ItemInteractionResult.sidedSuccess((boolean)event.getSide().isClient()));
    }

    @NotNull
    public static IColorable registerPlayer(final Player player, Void ignored) {
        return new IColorable(){

            @Override
            public int getColor(int index) {
                return FavoredColor.of((IAttachmentHolder)player);
            }

            @Override
            @NotNull
            public IColorable.Result setColor(int index, int value) {
                int current = (Integer)player.getData(CoreAttachments.Color);
                if (current == value) {
                    return IColorable.Result.DENIED;
                }
                player.setData(CoreAttachments.Color, (Object)value);
                XyCore.Network.broadcast(new CBPlayerColorSyncPacket(player.getId(), value));
                return IColorable.Result.SUCCESS;
            }
        };
    }

    public static IColorable registerBlock(final Level level, final BlockPos pos, BlockState state, final @Nullable BlockEntity blockEntity, Void context) {
        if (blockEntity != null) {
            return new IColorable(){

                @Override
                public int getColor(int index) {
                    return (Integer)blockEntity.getData(CoreAttachments.Color);
                }

                @Override
                @NotNull
                public IColorable.Result setColor(int index, int value) {
                    BlockState state = level.getBlockState(pos);
                    int current = (Integer)blockEntity.getData(CoreAttachments.Color);
                    if (current == value) {
                        return IColorable.Result.DENIED;
                    }
                    blockEntity.setData(CoreAttachments.Color, (Object)value);
                    blockEntity.setChanged();
                    level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 512);
                    return IColorable.Result.SUCCESS;
                }
            };
        }
        return null;
    }
}

