/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.MCLocale;

public abstract class RegistrationContentBuilder<TBuilder extends RegistrationContentBuilder<TBuilder, TContent>, TContent> {
    protected final ContentMap _map;
    public final String Id;
    protected final Reference2ObjectMap<MCLocale, String> _localizations = new Reference2ObjectOpenHashMap();
    @NotNull
    protected BooleanSupplier _requirement = () -> true;

    public RegistrationContentBuilder(ContentMap map, String contentId) {
        this._map = map;
        this.Id = contentId;
    }

    @NotNull
    private TBuilder self() {
        return (TBuilder)this;
    }

    public TBuilder withName(String englishName) {
        return this.withName(englishName, MCLocale.ENGLISH);
    }

    public TBuilder withName(String name, MCLocale ... locale) {
        for (MCLocale mcLocale : locale) {
            this._localizations.put((Object)mcLocale, (Object)name);
        }
        return this.self();
    }

    public TBuilder requires(@NotNull BooleanSupplier predicate) {
        this._requirement = predicate;
        return this.self();
    }

    abstract TContent build();
}

