/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.utils.DyeColors;

public class DyeableBlock
extends ColoredBlock {
    private final EnumMap<DyeColors, BlockContent> _map;

    public DyeableBlock(DyeColors color, BlockBehaviour.Properties properties, EnumMap<DyeColors, BlockContent> map) {
        super(color, properties);
        this._map = map;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        tooltips.add((Component)Component.literal((String)"Dyeable in world.").withStyle(ChatFormatting.GRAY));
    }

    public EnumMap<DyeColors, BlockContent> getMap() {
        return this._map;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, Player player) {
        if (player.isCreative()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        return new ItemStack((ItemLike)this._map.get(DyeColors.White).block(), 1);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return super.getStateForPlacement(context);
        }
        BlockState state = this.defaultBlockState();
        ItemStack offhandStack = context.getHand() == InteractionHand.OFF_HAND ? player.getMainHandItem() : player.getOffhandItem();
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            state = this._map.get(DyeColors.from(color)).block().defaultBlockState();
        }
        return (BlockState)state.setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }
}

