/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.ContributionType;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.core.content.attachments.level.XynergyGraph;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;

public class XynergyNode {
    public static final Codec<XynergyNode> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("node_value").forGetter(data -> data.Value), (App)Codec.LONG.fieldOf("networked_value").forGetter(data -> data.NetworkedValue), (App)ContributionType.Codec.fieldOf("power_type").forGetter(data -> data.Type)).apply((Applicative)builder, XynergyNode::new));
    public long Value;
    public long NetworkedValue;
    public ContributionType Type;
    private transient BlockCapabilityCache<IXynergyNode, @Nullable Void> CacheCapability;

    public XynergyNode(long value, long networked, ContributionType contributionType) {
        this.Value = value;
        this.NetworkedValue = networked;
        this.Type = contributionType;
    }

    public IXynergyNode getCachedCapability(ServerLevel level, BlockPos pos, XynergyGraph graph) {
        if (this.CacheCapability == null) {
            long posId = pos.asLong();
            this.CacheCapability = BlockCapabilityCache.create(CoreCapabilities.XynergyNode.BLOCK, (ServerLevel)level, (BlockPos)pos, null, () -> graph.Graph.containsVertex((Object)posId), () -> {
                graph.State = XynergyGraph.GraphState.Invalid;
            });
        }
        return (IXynergyNode)this.CacheCapability.getCapability();
    }
}

