/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleGraph;
import tv.soaryn.xycraft.core.content.attachments.level.XynergyEdge;
import tv.soaryn.xycraft.core.content.attachments.level.XynergyNode;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class XynergyGraph {
    public Codec<XynergyGraph> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).fieldOf("nodes").forGetter(data -> data.Graph.vertexSet()), (App)NeoForgeExtraCodecs.setOf(XynergyEdge.CODEC).fieldOf("edges").forGetter(data -> data.Graph.edgeSet()), (App)CodecUtils.tupleOf(Codec.LONG, XynergyNode.CODEC, Long2ObjectOpenHashMap::new).fieldOf("nodes").forGetter(data -> data.NodeCache)).apply((Applicative)builder, XynergyGraph::new));
    public final ListenableGraph<Long, XynergyEdge> Graph = new DefaultListenableGraph((Graph)new SimpleGraph(XynergyEdge.class));
    public final transient Long2ObjectOpenHashMap<XynergyNode> NodeCache = new Long2ObjectOpenHashMap();
    public final transient Long2ObjectMap<long[]> WorkingCache = new Long2ObjectOpenHashMap();
    public final transient ConnectivityInspector<Long, XynergyEdge> Inspector;
    public transient GraphState State = GraphState.Invalid;
    private ObjectIterator<Long2ObjectMap.Entry<XynergyNode>> workIterator;
    private long workCount;

    public XynergyGraph() {
        this(Set.of(), Set.of(), (Long2ObjectOpenHashMap<XynergyNode>)new Long2ObjectOpenHashMap());
    }

    public XynergyGraph(Set<Long> nodes, Set<XynergyEdge> edges, Long2ObjectOpenHashMap<XynergyNode> nodeCaches) {
        this.Inspector = new ConnectivityInspector(this.Graph);
        this.Graph.addGraphListener(this.Inspector);
        this.Inspector.connectedSets();
        nodes.forEach(arg_0 -> this.Graph.addVertex(arg_0));
        edges.forEach(edgeData -> this.Graph.addEdge((Object)edgeData.src(), (Object)edgeData.dst(), edgeData));
        this.NodeCache.putAll(nodeCaches);
    }

    public boolean isConnected() {
        return this.Inspector.isConnected();
    }

    public long calculateSum() {
        long sum = 0L;
        for (XynergyNode node : this.NodeCache.values()) {
            sum = MathUtils.longSum(sum, node.Value);
        }
        return Math.clamp(sum, -1000000000000000000L, 1000000000000000000L);
    }

    public void setupWork(long frequency) {
        this.workIterator = this.NodeCache.long2ObjectEntrySet().iterator();
        this.workCount = (long)this.NodeCache.size() / frequency + (long)this.NodeCache.size() % frequency;
    }

    public void invalidateValues() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (long i = 0L; i < this.workCount && this.workIterator.hasNext(); ++i) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)this.workIterator.next();
            long posId = entry.getLongKey();
            XynergyNode nodeCache = (XynergyNode)entry.getValue();
            pos.set(posId);
        }
    }

    public static enum GraphState {
        Ready,
        Building,
        Invalid;

    }
}

