/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.resource;

import java.util.Objects;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandlerModifiable;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;

public record ResourceStackContainerToHandlerAdapter<TResource extends IResource>(IResourceContainer<TResource> container, HandlerIOBehavior behavior) implements IResourceHandlerModifiable<TResource>
{
    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public boolean allowsInsertion() {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!this.allowsInsertion(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsExtraction() {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!this.allowsExtraction(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsInsertion(int index) {
        return this.behavior.canInsert(index);
    }

    @Override
    public boolean allowsExtraction(int index) {
        return this.behavior.canExtract(index);
    }

    @Override
    public TResource getResource(int index) {
        return this.container.get(index).resource();
    }

    @Override
    public int getAmount(int index) {
        return this.container.get(index).amount();
    }

    @Override
    public int getCapacity(int index, TResource resource) {
        return this.container.getCapacity(index, resource);
    }

    @Override
    public int getCapacity(int index) {
        return this.container.getCapacity(index);
    }

    @Override
    public boolean isValid(int index, TResource resource) {
        return this.container.isValid(index, resource) && this.behavior.canInsert(index);
    }

    @Override
    public int insert(TResource resource, int amount, TransferAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int handled = 0;
        for (int index = 0; index < this.size(); ++index) {
            Objects.checkIndex(index, this.size());
            if (handled == amount) break;
            handled += this.indexInsert(index, resource, amount - handled, action);
        }
        return handled;
    }

    @Override
    public int insert(int index, TResource resource, int amount, TransferAction action) {
        Objects.checkIndex(index, this.size());
        return resource.isEmpty() ? 0 : this.indexInsert(index, resource, amount, action);
    }

    private int indexInsert(int index, TResource resource, int amount, TransferAction action) {
        int newStackSize;
        int inserted;
        if (!this.behavior.canInsert(index) || !this.container.isValid(index, resource)) {
            return 0;
        }
        MutableResourceStack<TResource> resourceStackInSlot = this.container.get(index);
        int capacity = this.container.getCapacity(index, resource);
        if (resourceStackInSlot.isEmpty()) {
            newStackSize = inserted = Math.min(capacity, amount);
        } else {
            if (!resourceStackInSlot.isSameResource(resource)) {
                return 0;
            }
            inserted = Math.min(capacity - resourceStackInSlot.amount(), amount);
            newStackSize = resourceStackInSlot.amount() + inserted;
        }
        if (newStackSize > 0 && action.isExecuting()) {
            this.set(index, resource, newStackSize);
        }
        return inserted;
    }

    @Override
    public int extract(int index, TResource resource, int amount, TransferAction action) {
        Objects.checkIndex(index, this.size());
        return !resource.isEmpty() && amount > 0 ? this.indexedExtract(index, resource, amount, action) : 0;
    }

    private int indexedExtract(int index, TResource resource, int amount, TransferAction action) {
        if (!this.behavior.canExtract(index)) {
            return 0;
        }
        MutableResourceStack<TResource> currentStack = this.container.get(index);
        if (!resource.equals(currentStack.resource())) {
            return 0;
        }
        int currentAmount = currentStack.amount();
        int handledAmount = Math.min(amount, currentAmount);
        if (action.isExecuting()) {
            this.set(index, resource, currentAmount - handledAmount);
        }
        return handledAmount;
    }

    @Override
    public int extract(TResource resource, int amount, TransferAction action) {
        if (resource.isEmpty() || amount <= 0) {
            return 0;
        }
        int handled = 0;
        for (int index = 0; index < this.container.size(); ++index) {
            Objects.checkIndex(index, this.size());
            if (handled == amount) break;
            handled += this.indexedExtract(index, resource, amount - handled, action);
        }
        return handled;
    }

    @Override
    public void set(int index, TResource resource, int amount) {
        Objects.checkIndex(index, this.size());
        MutableResourceStack<TResource> current = this.container.get(index);
        if (resource.isEmpty()) {
            amount = 0;
        }
        if (current.isSameResource(resource)) {
            this.container.set(index, current.withAmount(amount));
        } else {
            this.container.set(index, MutableResourceStack.of(resource, amount));
        }
    }
}

