/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterSpriteSourceTypesEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import tv.soaryn.xycraft.api.client.render.model.ConnectedTextureModel;
import tv.soaryn.xycraft.api.content.NotableColors;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.client.render.texture.FXAtlasSpriteSource;
import tv.soaryn.xycraft.core.content.attachments.TickDataAttachment;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.imc.IMCRegistries;
import tv.soaryn.xycraft.core.utils.Utils;

public class XyCoreClient {
    public static SpriteSourceType FxType;

    @EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    static interface ForgeBus {
        @SubscribeEvent
        public static void onTagsUpdated(TagsUpdatedEvent event) {
            LocalPlayer player;
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD && (player = Minecraft.getInstance().player) != null && ((Boolean)XyCore.ClientConfig.ShowReloadMessage.get()).booleanValue()) {
                player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.2f, 1.0f);
                player.sendSystemMessage((Component)Component.translatable((String)"xycraft.core.system.finished_reloading"));
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onClientLevelTick(LevelTickEvent.Pre event) {
            Level level = event.getLevel();
            if (!level.isClientSide()) {
                return;
            }
            TickDataAttachment data = (TickDataAttachment)level.getData(CoreAttachments.Tick);
            ++data.Tick;
            level.setData(CoreAttachments.Tick, (Object)data);
        }

        @SubscribeEvent
        public static void onClientPartial(RenderFrameEvent.Pre event) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            TickDataAttachment data = (TickDataAttachment)level.getData(CoreAttachments.Tick);
            data.CurrentPartial = event.getPartialTick().getRealtimeDeltaTicks();
            data.PartialSum += data.CurrentPartial;
            level.setData(CoreAttachments.Tick, (Object)data);
        }

        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            if (((Boolean)XyCore.ClientConfig.ShowItemTags.get()).booleanValue() && event.getFlags().isAdvanced()) {
                Object[] array = event.getItemStack().getTags().toArray();
                if (array.length == 0) {
                    return;
                }
                event.getToolTip().add(Component.literal((String)"  ").append((Component)Component.literal((String)"Item Tags").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE})));
                for (Object o : array) {
                    if (!(o instanceof TagKey)) continue;
                    TagKey itemTag = (TagKey)o;
                    event.getToolTip().add(Component.literal((String)("   " + String.valueOf(itemTag.location()))).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    @EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static interface ModBus {
        public static final Gson GsonInstance = new Gson();

        @SubscribeEvent
        public static void setup(FMLClientSetupEvent event) {
            IMCRegistries.Send.registerFramedBlockConnectivity();
            Utils.CLIENT_LEVEL_SUPPLIER = () -> Minecraft.getInstance().level;
            Utils.CLIENT_PLAYER_SUPPLIER = () -> Minecraft.getInstance().player;
            Utils.SHIFT_KEY_DOWN = Screen::hasShiftDown;
            Utils.DEBUG_SCREEN = () -> Minecraft.getInstance().getDebugOverlay().showDebugScreen();
            ModLoadingContext.get().getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, modListScreen) -> new ConfigurationScreen(container, modListScreen)));
        }

        @SubscribeEvent
        public static void onRegisterSpriteLoader(RegisterSpriteSourceTypesEvent event) {
            FxType = event.register(XyCore.resource("fxsprite"), FXAtlasSpriteSource.CODEC);
        }

        @SubscribeEvent
        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(XyCore.resource("connected_textures"), (IGeometryLoader)new ConnectedTextureModel.Loader());
        }

        @SubscribeEvent
        public static void onRegisterColorHandler(RegisterColorHandlersEvent.Block event) {
            event.register((state, level, pos, index) -> ((IColoredBlock)state.getBlock()).getColorOfBlock(state, level, pos, index), ContentMap.getColorableBlocks());
        }

        @SubscribeEvent
        public static void onRegisterColorHandler(RegisterColorHandlersEvent.Item event) {
            event.register((stack, index) -> ((IColoredBlock)((BlockItem)stack.getItem()).getBlock()).getColorOfItem(stack, index), (ItemLike[])ContentMap.getColorableItemBlocks());
            event.register((stack, index) -> ((IColoredBlock)stack.getItem()).getColorOfItem(stack, index), (ItemLike[])ContentMap.getColorableItems());
        }

        @SubscribeEvent
        public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((barrier, resourceManager, prepareProfiler, applyProfiler, prepareExecutor, applyExecutor) -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                Optional optional = resourceManager.getResource(XyCore.resource("settings/colors.json"));
                return optional.map(resource -> {
                    ColorSettings colorSettings;
                    InputStreamReader reader = new InputStreamReader(resource.open());
                    try {
                        colorSettings = (ColorSettings)GsonInstance.fromJson((Reader)reader, ColorSettings.class);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            XyCore.Logger.error(e.toString());
                            XyCore.Logger.error("Aaaaah color settings is wrong!");
                            return new ColorSettings();
                        }
                    }
                    reader.close();
                    return colorSettings;
                }).orElseGet(ColorSettings::new);
            }, prepareExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(colorSettings -> {
                XyCraftColors.Blue.setColor((int)(Integer.decode(colorSettings.blue) | 0xFF000000));
                XyCraftColors.Green.setColor((int)(Integer.decode(colorSettings.green) | 0xFF000000));
                XyCraftColors.Red.setColor((int)(Integer.decode(colorSettings.red) | 0xFF000000));
                XyCraftColors.Dark.setColor((int)(Integer.decode(colorSettings.dark) | 0xFF000000));
                XyCraftColors.Light.setColor((int)(Integer.decode(colorSettings.light) | 0xFF000000));
                NotableColors.Creative.setColor((int)(Integer.decode(colorSettings.creative) | 0xFF000000));
            }, applyExecutor));
        }

        public static class ColorSettings {
            public String blue = "0x1164FF";
            public String green = "0x00FF00";
            public String red = "0xFF0000";
            public String dark = "0x1E1E1E";
            public String light = "0xFFFFFF";
            public String creative = "0xE78122";

            ColorSettings() {
            }
        }
    }
}

