/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes.examples;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.DepthFirstIterator;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeGraphState;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.utils.MathUtils;

public abstract class BufferedPipeGraph<TCapability, TGraph extends BufferedPipeGraph<TCapability, TGraph>>
extends PipeGraph<TCapability, TGraph> {
    protected final transient Reference2ObjectOpenHashMap<Graph<Long, EdgeData>, PipeGroup<TCapability>> BufferMap = new Reference2ObjectOpenHashMap();
    private final transient Object2ObjectOpenHashMap<TCapability, ObjectArraySet<PipeGroup<?>>> _receiverGroup = new Object2ObjectOpenHashMap();
    protected transient Graph<Graph<Long, EdgeData>, DefaultEdge> CondensedGraph;
    protected transient Long2ObjectOpenHashMap<Graph<Long, EdgeData>> PosToPipeGroup = new Long2ObjectOpenHashMap();
    private transient boolean _initializedAcceptanceBuffers = false;
    private transient ObjectArraySet<PipeGroup<TCapability>> _serializedBuffers = new ObjectArraySet();
    HashSet<TCapability> uniqueValues = new HashSet();

    @NotNull
    public static <TCapability, TGraph extends BufferedPipeGraph<TCapability, TGraph>> RecordCodecBuilder<TGraph, Set<PipeGroup<TCapability>>> bufferCodecRecord() {
        return NeoForgeExtraCodecs.setOf(PipeGroup.codec()).fieldOf("buffers").forGetter(BufferedPipeGraph::getAllBuffers);
    }

    public BufferedPipeGraph(UUID uuid, PipeRoute<TCapability> pipeRoute) {
        super(uuid, pipeRoute);
        this.CondensedGraph = this.getRouteContainer().getPipeGroups();
    }

    public BufferedPipeGraph(UUID uuid, PipeRoute<TCapability> pipeRoute, Set<PipeGroup<TCapability>> serializedBuffers) {
        this(uuid, pipeRoute);
        this._serializedBuffers = new ObjectArraySet(serializedBuffers);
        this.CondensedGraph = this.getRouteContainer().getPipeGroups();
    }

    public abstract long getDemand(TCapability var1);

    @Override
    public void rebuild(ServerLevel level) {
        this.loadBuffers(this.getAllBuffers());
        this.loadCaches(level);
        this.setValid(PipeGraphState.READY);
        this.IsLoaded = true;
    }

    public void loadBuffers(Set<PipeGroup<TCapability>> serializedBuffers) {
        this.CondensedGraph = this.getRouteContainer().getPipeGroups();
        this.PosToPipeGroup.clear();
        this.BufferMap.clear();
        for (Graph graph : this.CondensedGraph.vertexSet()) {
            Iterator iterator = graph.vertexSet().iterator();
            while (iterator.hasNext()) {
                long posId = (Long)iterator.next();
                this.PosToPipeGroup.put(posId, (Object)graph);
            }
        }
        for (PipeGroup pipeGroup : serializedBuffers) {
            Graph group = (Graph)this.PosToPipeGroup.get(pipeGroup.getAnchor());
            if (group == null) continue;
            PipeGroup newBuffer = pipeGroup.copy();
            newBuffer.PathableBuffers.clear();
            newBuffer.Group = group;
            PipeGroup currentBuffer = (PipeGroup)this.BufferMap.get((Object)group);
            if (currentBuffer == null) {
                this.BufferMap.put((Object)group, newBuffer);
                newBuffer.PathableBuffers.add(newBuffer);
                continue;
            }
            currentBuffer.Stored = MathUtils.longSumUp(currentBuffer.Stored, newBuffer.Stored);
            newBuffer.PathableBuffers.add((Object)currentBuffer);
        }
        for (Graph graph : this.CondensedGraph.vertexSet()) {
            long anchor = (Long)graph.vertexSet().iterator().next();
            PipeGroup group = (PipeGroup)this.BufferMap.computeIfAbsent((Object)graph, o -> new PipeGroup(0L, 0L, anchor));
            group.Group = (Graph)this.PosToPipeGroup.get(anchor);
        }
        for (Graph graph : this.CondensedGraph.vertexSet()) {
            PipeGroup targetBuffer = (PipeGroup)this.BufferMap.get((Object)graph);
            DepthFirstIterator it = new DepthFirstIterator(this.CondensedGraph, (Object)graph);
            it.forEachRemaining(g -> targetBuffer.PathableBuffers.add((Object)((PipeGroup)this.BufferMap.get(g))));
        }
    }

    @Override
    public void loadCaches(ServerLevel level) {
        PipeRoute route = this.getRouteContainer();
        for (Reference2ObjectMap.Entry pipeGroupEntry : this.BufferMap.reference2ObjectEntrySet()) {
            Graph graphGroup = (Graph)pipeGroupEntry.getKey();
            PipeGroup pipeGroup = (PipeGroup)pipeGroupEntry.getValue();
            pipeGroup.CacheFrame.clear();
            Iterator iterator = graphGroup.vertexSet().iterator();
            while (iterator.hasNext()) {
                IPipeConnection pipeCap;
                long posId = (Long)iterator.next();
                ObjectArraySet validConnections = (ObjectArraySet)route.PosToValidExternalConnectionMap.get(posId);
                if (validConnections == null || validConnections.isEmpty()) continue;
                ObjectArraySet externalConnections = (ObjectArraySet)route.PosToExternalCaches.get(posId);
                if (externalConnections == null) {
                    XyCore.Logger.error("Caches are empty, this shouldn't be called. Yet it was so, may need a bug report");
                    continue;
                }
                BlockCapabilityCache pipeCache = (BlockCapabilityCache)route.PosToPipeConnectionCache.get(posId);
                if (pipeCache == null || (pipeCap = (IPipeConnection)pipeCache.getCapability()) == null) continue;
                for (BlockCapabilityCache externalConnection : externalConnections) {
                    externalConnection.getCapability();
                    Direction opposite = ((Direction)externalConnection.context()).getOpposite();
                    PipeConnectionType logic = pipeCap.getLogic(opposite);
                    boolean closed = pipeCap.isClosed(opposite);
                    if (!validConnections.contains((Object)opposite) || closed || !logic.isIn()) continue;
                    pipeGroup.CacheFrame.add((Object)externalConnection);
                }
            }
        }
    }

    public Set<PipeGroup<TCapability>> getAllBuffers() {
        HashSet<PipeGroup<TCapability>> set = new HashSet<PipeGroup<TCapability>>(this.BufferMap.values());
        set.addAll((Collection<PipeGroup<TCapability>>)this._serializedBuffers);
        this._serializedBuffers.clear();
        return set;
    }

    @Override
    public void preTick(ServerLevel level) {
        this._initializedAcceptanceBuffers = false;
    }

    @Override
    public void postTick(ServerLevel level) {
        if (this.state() != PipeGraphState.READY) {
            return;
        }
        for (PipeGroup buffer : this.BufferMap.values()) {
            if (buffer.Stored <= 0L) continue;
            for (PipeGroup path : buffer.PathableBuffers) {
                for (BlockCapabilityCache cache : path.CacheFrame) {
                    Object c;
                    if (cache == null || !level.shouldTickBlocksAt(cache.pos()) || (c = cache.getCapability()) == null) continue;
                    ((ObjectArraySet)this._receiverGroup.computeIfAbsent(c, o -> new ObjectArraySet())).add((Object)buffer);
                }
            }
        }
        this.distribute(this._receiverGroup);
        this._receiverGroup.clear();
    }

    public abstract void distribute(Object2ObjectOpenHashMap<TCapability, ObjectArraySet<PipeGroup<?>>> var1);

    public ObjectArraySet<PipeGroup<TCapability>> initBufferAllowances(ServerLevel level, long posId) {
        if (this.state() != PipeGraphState.READY) {
            return ObjectArraySet.of();
        }
        PipeGroup target = (PipeGroup)this.BufferMap.get(this.PosToPipeGroup.get(posId));
        if (this._initializedAcceptanceBuffers) {
            return target.PathableBuffers;
        }
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("xycraft:buffered_pipe." + this.getClass().getSimpleName().toLowerCase());
        for (PipeGroup b : target.PathableBuffers) {
            long sum = this.getMinimumBuffer();
            for (BlockCapabilityCache cache : b.CacheFrame) {
                Object capability;
                if (!level.shouldTickBlocksAt(cache.pos()) || (capability = cache.getCapability()) == null || !this.uniqueValues.add(capability)) continue;
                profiler.push(capability.getClass()::getName);
                long demand = this.getDemand(capability);
                if (demand > 0L) {
                    sum = MathUtils.longSumUp(sum, demand);
                }
                profiler.pop();
            }
            b.AcceptanceBuffer = Math.max(0L, sum - b.Stored);
            this.uniqueValues.clear();
        }
        profiler.pop();
        this._initializedAcceptanceBuffers = true;
        return target.PathableBuffers;
    }

    protected abstract long getMinimumBuffer();

    @Override
    public void copyDataFrom(TGraph otherGraph) {
        super.copyDataFrom(otherGraph);
        this._serializedBuffers.addAll(((BufferedPipeGraph)otherGraph).getAllBuffers());
    }
}

