/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jgrapht.Graph;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;

public final class PipeGroup<TCap> {
    public long AcceptanceBuffer;
    public long Stored;
    public long Anchor;
    public Graph<Long, EdgeData> Group;
    public ObjectArraySet<PipeGroup<TCap>> PathableBuffers = new ObjectArraySet();
    public ObjectArraySet<BlockCapabilityCache<TCap, Direction>> CacheFrame = new ObjectArraySet();

    public static <T> Codec<PipeGroup<T>> codec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("buffer").forGetter(PipeGroup::getAcceptanceBuffer), (App)Codec.LONG.fieldOf("stored").forGetter(PipeGroup::getStored), (App)Codec.LONG.fieldOf("anchor").forGetter(PipeGroup::getAnchor)).apply((Applicative)builder, PipeGroup::new));
    }

    public PipeGroup(long acceptanceBuffer, long stored, long anchor) {
        this.AcceptanceBuffer = acceptanceBuffer;
        this.Stored = stored;
        this.setAnchor(anchor);
    }

    public PipeGroup<TCap> copy() {
        return new PipeGroup<TCap>(this.AcceptanceBuffer, this.Stored, this.getAnchor());
    }

    public long getAnchor() {
        return this.Anchor;
    }

    public long getStored() {
        return this.Stored;
    }

    public long getAcceptanceBuffer() {
        return this.AcceptanceBuffer;
    }

    public void setAnchor(long anchor) {
        this.Anchor = anchor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeGroup that = (PipeGroup)o;
        return this.Anchor == that.Anchor;
    }

    public int hashCode() {
        return Long.hashCode(this.Anchor);
    }

    public String toString() {
        return "AcceptanceBuffer=%d, Stored=%d, Anchor=[%s]".formatted(this.AcceptanceBuffer, this.Stored, BlockPos.of((long)this.Anchor).toShortString());
    }
}

