/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.block.GemGlassBlock;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.GemOreBlock;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.block.PottedGlowroseBlock;
import net.silentchaos512.gems.item.GemBlockItem;
import net.silentchaos512.gems.item.GemItem;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.world.OreConfigDefaults;
import net.silentchaos512.lib.util.Color;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public enum Gems {
    RUBY(15080733, Rarity.COMMON, (Tier)Tiers.IRON, OreConfigDefaults.defaults(4, 8, 2, -64, 32, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    CARNELIAN(14699805, Rarity.UNCOMMON, (Tier)Tiers.IRON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    TOPAZ(15102237, Rarity.COMMON, (Tier)Tiers.IRON, OreConfigDefaults.defaults(4, 8, 2, -56, 40, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    CITRINE(13077251, Rarity.UNCOMMON, (Tier)Tiers.IRON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    HELIODOR(15123741, Rarity.COMMON, (Tier)Tiers.DIAMOND, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    MOLDAVITE(10934563, Rarity.UNCOMMON, (Tier)Tiers.IRON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    PERIDOT(2743064, Rarity.COMMON, (Tier)Tiers.IRON, OreConfigDefaults.defaults(4, 8, 2, -56, 40, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    TURQUOISE(4060349, Rarity.RARE, (Tier)Tiers.DIAMOND, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    KYANITE(4310259, Rarity.RARE, (Tier)Tiers.NETHERITE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    SAPPHIRE(1925349, Rarity.COMMON, (Tier)Tiers.IRON, OreConfigDefaults.defaults(4, 8, 2, -80, 32, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    IOLITE(7685109, Rarity.UNCOMMON, (Tier)Tiers.IRON, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.defaults(2, 8, 1, 20, 80), OreConfigDefaults.empty()),
    ALEXANDRITE(11220965, Rarity.UNCOMMON, (Tier)Tiers.DIAMOND, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.defaults(2, 8, 1, 20, 80), OreConfigDefaults.empty()),
    AMMOLITE(14363647, Rarity.RARE, (Tier)Tiers.DIAMOND, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    ROSE_QUARTZ(16731819, Rarity.RARE, (Tier)Tiers.NETHERITE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    BLACK_DIAMOND(6246988, Rarity.EPIC, (Tier)Tiers.NETHERITE, OreConfigDefaults.empty(), OreConfigDefaults.defaults(3, 8, 3, -10, 60), OreConfigDefaults.empty()),
    WHITE_DIAMOND(14008786, Rarity.EPIC, (Tier)Tiers.NETHERITE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(3, 8, 3, -10, 60));

    private final Color color;
    private final Rarity rarity;
    private final Map<ResourceKey<Level>, OreConfigDefaults> oreConfigDefaults;
    DeferredBlock<GemOreBlock> ore;
    DeferredBlock<GemOreBlock> deepslateOre;
    DeferredBlock<GemOreBlock> netherOre;
    DeferredBlock<GemOreBlock> endOre;
    DeferredBlock<GemBlock> block;
    DeferredBlock<GemBlock> bricks;
    DeferredBlock<GemBlock> tiles;
    DeferredBlock<GemBlock> smallBricks;
    DeferredBlock<GemBlock> polishedStone;
    DeferredBlock<GemBlock> smoothStone;
    DeferredBlock<GemBlock> chiseledStone;
    DeferredBlock<GemGlassBlock> glass;
    DeferredBlock<GlowroseBlock> glowrose;
    DeferredBlock<FlowerPotBlock> pottedGlowrose;
    Map<GemLampBlock.State, DeferredBlock<GemLampBlock>> lamps;
    DeferredItem<GemItem> item;
    DeferredItem<GemItem> shard;
    final TagKey<Block> incorrectForToolTag;
    final TagKey<Block> equivalentIncorrectForToolTag;
    final String harvestTierLevelHint;
    final TagKey<Block> blockTag;
    final TagKey<Block> glowroseTag;
    final TagKey<Block> oreTag;
    final TagKey<Block> modOresTag;
    final TagKey<Item> blockItemTag;
    final TagKey<Item> glowroseItemTag;
    final TagKey<Item> oreItemTag;
    final TagKey<Item> modOresItemTag;
    final TagKey<Item> itemTag;

    /*
     * Exception decompiling
     */
    private Gems(int colorIn, Rarity rarity, Tier equivalentHarvestTier, OreConfigDefaults overworldOres, OreConfigDefaults netherOres, OreConfigDefaults endOres) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=44,863
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TagKey<Block> makeBlockTag(ResourceLocation name) {
        return BlockTags.create((ResourceLocation)name);
    }

    private static TagKey<Item> makeItemTag(ResourceLocation name) {
        return ItemTags.create((ResourceLocation)name);
    }

    private static ResourceLocation commonId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getColor() {
        return this.color.getColor();
    }

    public float[] getColorArray() {
        return new float[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Component getDisplayName() {
        return Component.translatable((String)("gem.silentgems." + this.getName()));
    }

    public TagKey<Block> getIncorrectForToolTag() {
        return this.incorrectForToolTag;
    }

    public void generateIncorrectForToolTag(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagProvider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> intrinsicTagAppender = tagProvider.apply(this.incorrectForToolTag);
        intrinsicTagAppender.addTag(this.equivalentIncorrectForToolTag);
    }

    public String getHarvestTierLevelHint() {
        return this.harvestTierLevelHint;
    }

    public OreConfigDefaults getOreConfigDefaults(ResourceKey<Level> level) {
        return this.oreConfigDefaults.getOrDefault(level, this.oreConfigDefaults.get(Level.OVERWORLD));
    }

    public GemOreBlock getOre() {
        return (GemOreBlock)this.ore.get();
    }

    public GemOreBlock getDeepslateOre() {
        return (GemOreBlock)this.deepslateOre.get();
    }

    public GemOreBlock getNetherOre() {
        return (GemOreBlock)this.netherOre.get();
    }

    public GemOreBlock getEndOre() {
        return (GemOreBlock)this.endOre.get();
    }

    public GemBlock getBlock() {
        return (GemBlock)this.block.get();
    }

    public GemBlock getBricks() {
        return (GemBlock)this.bricks.get();
    }

    public GemBlock getTiles() {
        return (GemBlock)this.tiles.get();
    }

    public GemBlock getSmallBricks() {
        return (GemBlock)this.smallBricks.get();
    }

    public GemBlock getPolishedStone() {
        return (GemBlock)this.polishedStone.get();
    }

    public GemBlock getSmoothStone() {
        return (GemBlock)this.smoothStone.get();
    }

    public GemBlock getChiseledStone() {
        return (GemBlock)this.chiseledStone.get();
    }

    public GemGlassBlock getGlass() {
        return (GemGlassBlock)this.glass.get();
    }

    public GemLampBlock getLamp(GemLampBlock.State state) {
        return (GemLampBlock)this.lamps.get((Object)state).get();
    }

    public GlowroseBlock getGlowrose() {
        return (GlowroseBlock)this.glowrose.get();
    }

    public FlowerPotBlock getPottedGlowrose() {
        return (FlowerPotBlock)this.pottedGlowrose.get();
    }

    public GemItem getItem() {
        return (GemItem)this.item.get();
    }

    @Deprecated
    public GemItem getShard() {
        return (GemItem)this.shard.get();
    }

    public TagKey<Block> getOreTag() {
        return this.oreTag;
    }

    public TagKey<Block> getModOresTag() {
        return this.modOresTag;
    }

    public TagKey<Block> getBlockTag() {
        return this.blockTag;
    }

    public TagKey<Block> getGlowroseTag() {
        return this.glowroseTag;
    }

    public TagKey<Item> getOreItemTag() {
        return this.oreItemTag;
    }

    public TagKey<Item> getModOresItemTag() {
        return this.modOresItemTag;
    }

    public TagKey<Item> getBlockItemTag() {
        return this.blockItemTag;
    }

    public TagKey<Item> getGlowroseItemTag() {
        return this.glowroseItemTag;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public static void registerBlocks() {
        for (Gems gem : Gems.values()) {
            gem.ore = Gems.registerBlock(gem.getName() + "_ore", () -> new GemOreBlock(gem, 2, "gem_ore", BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
        }
        for (Gems gem : Gems.values()) {
            gem.deepslateOre = Gems.registerBlock("deepslate_" + gem.getName() + "_ore", () -> new GemOreBlock(gem, 2, "deepslate_gem_ore", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)gem.ore.get())).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)));
        }
        for (Gems gem : Gems.values()) {
            gem.netherOre = Gems.registerBlock("nether_" + gem.getName() + "_ore", () -> new GemOreBlock(gem, 3, "gem_nether_ore", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)gem.ore.get())).strength(4.0f).sound(SoundType.NETHER_ORE)));
        }
        for (Gems gem : Gems.values()) {
            gem.endOre = Gems.registerBlock("end_" + gem.getName() + "_ore", () -> new GemOreBlock(gem, 4, "gem_end_ore", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)gem.ore.get())).strength(6.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.block = Gems.registerBlock(gem.getName() + "_block", () -> new GemBlock(gem, "gem_block", BlockBehaviour.Properties.of().strength(4.0f, 30.0f).sound(SoundType.METAL)));
        }
        for (Gems gem : Gems.values()) {
            gem.bricks = Gems.registerBlock(gem.getName() + "_bricks", () -> new GemBlock(gem, "gem_bricks", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.tiles = Gems.registerBlock(gem.getName() + "_tiles", () -> new GemBlock(gem, "gem_tiles", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.smallBricks = Gems.registerBlock(gem.getName() + "_small_bricks", () -> new GemBlock(gem, "gem_small_bricks", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.polishedStone = Gems.registerBlock("polished_" + gem.getName(), () -> new GemBlock(gem, "polished_gem_stone", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.smoothStone = Gems.registerBlock("smooth_" + gem.getName(), () -> new GemBlock(gem, "smooth_gem_stone", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.chiseledStone = Gems.registerBlock("chiseled_" + gem.getName(), () -> new GemBlock(gem, "chiseled_gem_stone", BlockBehaviour.Properties.of().strength(2.0f, 8.0f)));
        }
        BlockBehaviour.StatePredicate isNotSolid = (state, world, pos) -> false;
        for (Gems gem : Gems.values()) {
            gem.glass = Gems.registerBlock(gem.getName() + "_glass", () -> new GemGlassBlock(gem, BlockBehaviour.Properties.of().strength(1.0f, 5.0f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((state, world, pos, entityType) -> false).isRedstoneConductor(isNotSolid).isSuffocating(isNotSolid).isViewBlocking(isNotSolid)));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.OFF, Gems.registerLamp(gem, GemLampBlock.State.OFF));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.ON, Gems.registerLamp(gem, GemLampBlock.State.ON));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.INVERTED_ON, Gems.registerLamp(gem, GemLampBlock.State.INVERTED_ON));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.INVERTED_OFF, Gems.registerLamp(gem, GemLampBlock.State.INVERTED_OFF));
        }
        for (Gems gem : Gems.values()) {
            gem.glowrose = Gems.registerBlock(gem.getName() + "_glowrose", () -> new GlowroseBlock(gem, BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.0f).noCollission()));
        }
        for (Gems gem : Gems.values()) {
            gem.pottedGlowrose = Gems.registerBlockNoItem("potted_" + gem.getName() + "_glowrose", () -> new PottedGlowroseBlock(gem, () -> (GlowroseBlock)gem.glowrose.get(), BlockBehaviour.Properties.of().strength(0.0f)));
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SilentGems.getId(gem.getName() + "_glowrose"), gem.pottedGlowrose);
        }
    }

    public static void registerItems() {
        for (Gems gem : Gems.values()) {
            gem.item = Gems.registerItem(gem.getName(), () -> new GemItem(gem, "gem", new Item.Properties()));
        }
    }

    private static <T extends Block> DeferredBlock<T> registerBlockNoItem(String name, Supplier<T> block) {
        return GemsBlocks.BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        return Gems.registerBlock(name, block, Gems::defaultBlockItem);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, Function<DeferredBlock<T>, Supplier<BlockItem>> item) {
        DeferredBlock<T> ret = Gems.registerBlockNoItem(name, block);
        if (item != null) {
            GemsItems.ITEMS.register(name, item.apply(ret));
        }
        return ret;
    }

    private static DeferredBlock<GemLampBlock> registerLamp(Gems gem, GemLampBlock.State state) {
        String name = gem.getName() + "_lamp" + (state.inverted() ? "_inverted" : "") + (state.lit() ? "_on" : "");
        return Gems.registerBlock(name, () -> new GemLampBlock(gem, state, BlockBehaviour.Properties.of().strength(0.3f, 15.0f).lightLevel(s -> state.lit() ? 15 : 0)), state.hasItem() ? Gems::defaultBlockItem : null);
    }

    private static <T extends Item> DeferredItem<T> registerItem(String name, Supplier<T> item) {
        return GemsItems.ITEMS.register(name, item);
    }

    private static Supplier<BlockItem> defaultBlockItem(DeferredBlock<?> block) {
        return () -> new GemBlockItem((Block)block.get(), new Item.Properties());
    }
}

