/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.api.event.ExecuteModuleEvent;
import me.desht.modularrouters.api.event.RouterCompiledEvent;
import me.desht.modularrouters.block.CamouflageableBlock;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.RouterMenu;
import me.desht.modularrouters.container.handler.BufferHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.event.TickEventHandler;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.SecurityUpgrade;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.settings.ModuleTermination;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import me.desht.modularrouters.logic.settings.TransferDirection;
import me.desht.modularrouters.network.messages.ItemBeamMessage;
import me.desht.modularrouters.network.messages.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModularRouterBlockEntity
extends BlockEntity
implements ICamouflageable,
MenuProvider {
    public static final GameProfile DEFAULT_FAKEPLAYER_PROFILE = new GameProfile(UUID.nameUUIDFromBytes("modularrouters".getBytes()), "[Modular Routers]");
    private static final int N_MODULE_SLOTS = 9;
    private static final int N_UPGRADE_SLOTS = 5;
    private static final int N_BUFFER_SLOTS = 1;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_ACTIVE_TIMER = "ActiveTimer";
    private static final String NBT_ECO_MODE = "EcoMode";
    private static final String NBT_BUFFER = "Buffer";
    public static final String NBT_MODULES = "Modules";
    public static final String NBT_UPGRADES = "Upgrades";
    private static final String NBT_EXTRA = "Extra";
    public static final String NBT_REDSTONE_MODE = "Redstone";
    private static final String NBT_ENERGY = "EnergyBuffer";
    private static final String NBT_ENERGY_DIR = "EnergyDirection";
    private static final String NBT_ENERGY_UPGRADES = "EnergyUpgrades";
    private static final String NBT_OWNER_PROFILE = "OwnerProfile";
    private int counter = 0;
    private int pulseCounter = 0;
    private RedstoneBehaviour redstoneBehaviour = RedstoneBehaviour.ALWAYS;
    private final BufferHandler bufferHandler = new BufferHandler(this);
    private final ModuleHandler modulesHandler = new ModuleHandler(this);
    private final UpgradeHandler upgradesHandler = new UpgradeHandler(this);
    private final RouterEnergyBuffer energyStorage = new RouterEnergyBuffer(0);
    public final TrackedEnergy trackedEnergy = new TrackedEnergy();
    private EnergyDirection energyDirection = EnergyDirection.FROM_ROUTER;
    private final List<CompiledIndexedModule> compiledModules = new ArrayList<CompiledIndexedModule>();
    private final EnumSet<RecompileFlag> recompileNeeded = EnumSet.allOf(RecompileFlag.class);
    private int tickRate;
    private int itemsPerTick;
    private final Map<UpgradeItem, Integer> upgradeCount;
    private int fluidTransferRate;
    private int fluidTransferRemainingIn;
    private int fluidTransferRemainingOut;
    private final int SIDES;
    private final int[] redstoneLevels;
    private final int[] newRedstoneLevels;
    private final DetectorModule.SignalType[] signalType;
    private final DetectorModule.SignalType[] newSignalType;
    private boolean canEmit;
    private boolean prevCanEmit;
    private int redstonePower;
    private int lastPower;
    private boolean active;
    private int activeTimer;
    private final Set<UUID> permitted;
    private boolean ecoMode;
    private int ecoCounter;
    private boolean hasPulsedModules;
    private CompoundTag extData;
    private BlockState camouflage;
    private int tunedSyncValue;
    private boolean executing;
    private boolean careAboutItemAttributes;
    private boolean blockUpdateNeeded;
    public final List<BeamData> beams;
    public final List<BeamData> pendingBeams;
    private AABB cachedRenderAABB;
    private GameProfile ownerID;
    private RouterFakePlayer fakePlayer;

    public ModularRouterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.MODULAR_ROUTER.get(), pos, state);
        this.tickRate = (Integer)ConfigHolder.common.router.baseTickRate.get();
        this.itemsPerTick = 1;
        this.upgradeCount = new HashMap<UpgradeItem, Integer>();
        this.fluidTransferRemainingIn = 0;
        this.fluidTransferRemainingOut = 0;
        this.SIDES = MiscUtil.DIRECTIONS.length;
        this.redstoneLevels = new int[this.SIDES];
        this.newRedstoneLevels = new int[this.SIDES];
        this.signalType = new DetectorModule.SignalType[this.SIDES];
        this.newSignalType = new DetectorModule.SignalType[this.SIDES];
        this.redstonePower = -1;
        this.activeTimer = 0;
        this.permitted = Sets.newHashSet();
        this.ecoMode = false;
        this.ecoCounter = (Integer)ConfigHolder.common.router.ecoTimeout.get();
        this.hasPulsedModules = false;
        this.camouflage = null;
        this.tunedSyncValue = -1;
        this.beams = new ArrayList<BeamData>();
        this.pendingBeams = new ArrayList<BeamData>();
    }

    public IItemHandler getBuffer() {
        return this.bufferHandler;
    }

    public IItemHandlerModifiable getModules() {
        return this.modulesHandler;
    }

    public IItemHandler getUpgrades() {
        return this.upgradesHandler;
    }

    @Nonnull
    public Level nonNullLevel() {
        return Objects.requireNonNull(this.level);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> {
            int nEnergy;
            if (this.camouflage != null) {
                tag.put("BlockStateName", (Tag)NbtUtils.writeBlockState((BlockState)this.camouflage));
            }
            if ((nEnergy = this.getUpgradeCount((UpgradeItem)ModItems.ENERGY_UPGRADE.get())) > 0) {
                tag.putInt(NBT_ENERGY_UPGRADES, nEnergy);
            }
            this.getAllUpgrades().keySet().forEach(item -> {
                CompoundTag updateTag = item.createUpdateTag(this);
                if (updateTag != null) {
                    tag.put(BuiltInRegistries.ITEM.getKey(item).toString(), (Tag)updateTag);
                }
            });
        });
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.processClientSync(tag, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        this.processClientSync(pkt.getTag(), provider);
    }

    public void setOwner(Player player) {
        this.ownerID = player.getGameProfile();
        this.setChanged();
    }

    private void processClientSync(CompoundTag compound, HolderLookup.Provider provider) {
        HolderGetter holderGetter = (HolderGetter)provider.lookup(Registries.BLOCK).orElse(BuiltInRegistries.BLOCK.asLookup());
        if (compound.contains("BlockStateName")) {
            this.setCamouflage(NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)compound.getCompound("BlockStateName")));
        } else {
            this.setCamouflage(null);
        }
        this.energyStorage.updateForEnergyUpgrades(compound.getInt(NBT_ENERGY_UPGRADES));
        this.getAllUpgrades().keySet().forEach(item -> {
            Tag updateTag = compound.get(BuiltInRegistries.ITEM.getKey(item).toString());
            item.processClientSync(this, (CompoundTag)updateTag);
        });
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.bufferHandler.deserializeNBT(provider, nbt.getCompound(NBT_BUFFER));
        this.modulesHandler.deserializeNBT(provider, nbt.getCompound(NBT_MODULES));
        this.upgradesHandler.deserializeNBT(provider, nbt.getCompound(NBT_UPGRADES));
        this.energyStorage.deserializeNBT(provider, (Tag)nbt.getCompound(NBT_ENERGY));
        this.energyDirection = EnergyDirection.forValue(nbt.getString(NBT_ENERGY_DIR));
        this.redstoneBehaviour = RedstoneBehaviour.forValue(nbt.getString(NBT_REDSTONE_MODE));
        this.active = nbt.getBoolean(NBT_ACTIVE);
        this.activeTimer = nbt.getInt(NBT_ACTIVE_TIMER);
        this.ecoMode = nbt.getBoolean(NBT_ECO_MODE);
        this.ownerID = ExtraCodecs.GAME_PROFILE.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(NBT_OWNER_PROFILE)).result().orElse(DEFAULT_FAKEPLAYER_PROFILE);
        CompoundTag ext = nbt.getCompound(NBT_EXTRA);
        CompoundTag ext1 = this.getExtensionData();
        for (String key : ext.getAllKeys()) {
            ext1.put(key, ext.get(key));
        }
        this.counter = -1;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.put(NBT_BUFFER, (Tag)this.bufferHandler.serializeNBT(provider));
        if (this.hasItems((IItemHandler)this.modulesHandler)) {
            nbt.put(NBT_MODULES, (Tag)this.modulesHandler.serializeNBT(provider));
        }
        if (this.hasItems((IItemHandler)this.upgradesHandler)) {
            nbt.put(NBT_UPGRADES, (Tag)this.upgradesHandler.serializeNBT(provider));
        }
        if (this.redstoneBehaviour != RedstoneBehaviour.ALWAYS) {
            nbt.putString(NBT_REDSTONE_MODE, this.redstoneBehaviour.name());
        }
        if (this.energyStorage.getCapacity() > 0) {
            nbt.put(NBT_ENERGY, this.energyStorage.serializeNBT(provider));
        }
        if (this.energyDirection != EnergyDirection.FROM_ROUTER) {
            nbt.putString(NBT_ENERGY_DIR, this.energyDirection.name());
        }
        if (this.active) {
            nbt.putBoolean(NBT_ACTIVE, true);
        }
        if (this.activeTimer != 0) {
            nbt.putInt(NBT_ACTIVE_TIMER, this.activeTimer);
        }
        if (this.ecoMode) {
            nbt.putBoolean(NBT_ECO_MODE, true);
        }
        if (this.ownerID != null) {
            ExtraCodecs.GAME_PROFILE.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.ownerID).result().ifPresent(tag -> nbt.put(NBT_OWNER_PROFILE, tag));
        }
        if (!this.getExtensionData().isEmpty()) {
            nbt.put(NBT_EXTRA, (Tag)this.getExtensionData());
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.redstoneBehaviour = (RedstoneBehaviour)input.getOrDefault(ModDataComponents.REDSTONE_BEHAVIOUR, (Object)RedstoneBehaviour.ALWAYS);
        this.modulesHandler.fillFrom((ItemContainerContents)input.getOrDefault(ModDataComponents.SAVED_MODULES, (Object)ItemContainerContents.EMPTY));
        this.upgradesHandler.fillFrom((ItemContainerContents)input.getOrDefault(ModDataComponents.SAVED_UPGRADES, (Object)ItemContainerContents.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ModDataComponents.REDSTONE_BEHAVIOUR, (Object)this.redstoneBehaviour);
        builder.set(ModDataComponents.SAVED_MODULES, (Object)this.modulesHandler.asContainerContents());
        builder.set(ModDataComponents.SAVED_UPGRADES, (Object)this.upgradesHandler.asContainerContents());
    }

    private boolean hasItems(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void clientTick() {
        Iterator<BeamData> iterator = this.beams.iterator();
        while (iterator.hasNext()) {
            BeamData beam = iterator.next();
            beam.tick();
            if (!beam.isExpired()) continue;
            iterator.remove();
            this.cachedRenderAABB = null;
        }
    }

    public void serverTick() {
        if (!this.recompileNeeded.isEmpty()) {
            this.compile();
        }
        ++this.counter;
        ++this.pulseCounter;
        if (this.fakePlayer != null) {
            this.fakePlayer.tick();
            this.fakePlayer.getCooldowns().tick();
        }
        if (this.getRedstoneBehaviour() == RedstoneBehaviour.PULSE) {
            if (this.activeTimer > 0 && --this.activeTimer == 0) {
                this.setActive(false);
            }
        } else if (this.counter >= this.getTickRate()) {
            this.allocateFluidTransfer(this.counter);
            this.executeModules(false);
            this.counter = 0;
        }
        if (this.ecoMode) {
            if (this.active) {
                this.ecoCounter = (Integer)ConfigHolder.common.router.ecoTimeout.get();
            } else if (this.ecoCounter > 0) {
                --this.ecoCounter;
            }
        }
        this.maybeDoEnergyTransfer();
    }

    private void maybeDoEnergyTransfer() {
        IEnergyStorage energyHandler;
        if (this.getEnergyCapacity() > 0 && !this.getBufferItemStack().isEmpty() && this.redstoneBehaviour.shouldRun(this.getRedstonePower() > 0, false) && (energyHandler = this.bufferHandler.getEnergyStorage()) != null) {
            switch (this.energyDirection.ordinal()) {
                case 0: {
                    int toExtract = this.getEnergyStorage().extractEnergy(this.getEnergyXferRate(), true);
                    int received = energyHandler.receiveEnergy(toExtract, false);
                    this.getEnergyStorage().extractEnergy(received, false);
                    break;
                }
                case 1: {
                    int toExtract = energyHandler.extractEnergy(this.getEnergyXferRate(), true);
                    int received = this.energyStorage.receiveEnergy(toExtract, false);
                    energyHandler.extractEnergy(received, false);
                }
            }
        }
    }

    public RouterFakePlayer getFakePlayer() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.fakePlayer == null) {
                this.fakePlayer = new RouterFakePlayer(this, serverLevel, this.getOwnerProfile());
                this.fakePlayer.getInventory().selected = 0;
                this.fakePlayer.setPosRaw(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
            }
            return this.fakePlayer;
        }
        return null;
    }

    private GameProfile getOwnerProfile() {
        if (this.ownerID != null) {
            return this.ownerID;
        }
        for (int i = 0; i < this.getUpgrades().getSlots(); ++i) {
            SecurityUpgrade securityUpgrade;
            Optional opt;
            ItemStack stack = this.getUpgrades().getStackInSlot(i);
            Item item = stack.getItem();
            if (!(item instanceof SecurityUpgrade) || !(opt = (securityUpgrade = (SecurityUpgrade)item).getOwnerProfile(stack)).isPresent()) continue;
            return (GameProfile)opt.get();
        }
        return DEFAULT_FAKEPLAYER_PROFILE;
    }

    private void executeModules(boolean pulsed) {
        boolean powered;
        this.executing = true;
        boolean newActive = false;
        boolean bl = powered = pulsed || this.getRedstonePower() > 0;
        if (this.redstoneBehaviour.shouldRun(powered, pulsed)) {
            Level level;
            if (this.prevCanEmit || this.canEmit) {
                Arrays.fill(this.newRedstoneLevels, 0);
                Arrays.fill((Object[])this.newSignalType, (Object)DetectorModule.SignalType.NONE);
            }
            newActive = this.runAllModules(powered, pulsed);
            if (!this.pendingBeams.isEmpty() && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)ItemBeamMessage.create(this.getBlockPos(), this.pendingBeams), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pendingBeams.clear();
            }
            if (this.prevCanEmit || this.canEmit) {
                this.handleRedstoneEmission();
            }
        }
        this.setActive(newActive);
        this.prevCanEmit = this.canEmit;
        this.executing = false;
    }

    private boolean runAllModules(boolean powered, boolean pulsed) {
        boolean newActive = false;
        for (CompiledIndexedModule cim : this.compiledModules) {
            CompiledModule cm = cim.compiledModule;
            if (cm == null || !cm.shouldExecute() || cm.getEnergyCost() > this.getEnergyStorage().getEnergyStored() || !cm.checkRedstone(powered, pulsed)) continue;
            ExecuteModuleEvent event = cm.getEvent();
            if (event != null) {
                event.setExecuted(false);
                event.setCanceled(false);
                NeoForge.EVENT_BUS.post((Event)event);
                if (event.isExecuted()) {
                    newActive = true;
                }
                if (event.isCanceled()) {
                    if ((!newActive || cm.termination() != ModuleTermination.RAN) && cm.termination() != ModuleTermination.NOT_RAN) continue;
                    break;
                }
            }
            if (cm.execute(this)) {
                cm.getFilter().cycleRoundRobin().ifPresent(counter -> {
                    ItemStack moduleStack = this.modulesHandler.getStackInSlot(cim.index);
                    ModuleItem.setRoundRobinCounter(moduleStack, counter);
                });
                this.getEnergyStorage().extractEnergy(cm.getEnergyCost(), false);
                newActive = true;
                if (cm.termination() != ModuleTermination.RAN) continue;
                break;
            }
            if (cm.termination() != ModuleTermination.NOT_RAN) continue;
            break;
        }
        return newActive;
    }

    public int getTickRate() {
        return this.ecoMode && this.ecoCounter == 0 ? (Integer)ConfigHolder.common.router.lowPowerTickRate.get() : this.tickRate;
    }

    public RedstoneBehaviour getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }

    public void setRedstoneBehaviour(RedstoneBehaviour redstoneBehaviour) {
        this.redstoneBehaviour = redstoneBehaviour;
        if (redstoneBehaviour == RedstoneBehaviour.PULSE) {
            this.lastPower = this.getRedstonePower();
        }
        this.setChanged();
        this.handleSync(false);
    }

    private void setActive(boolean newActive) {
        if (this.active != newActive) {
            this.active = newActive;
            this.nonNullLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(newActive && this.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 3)), 2);
            this.setChanged();
        }
    }

    public void setEcoMode(boolean newEco) {
        if (newEco != this.ecoMode) {
            this.ecoMode = newEco;
            this.ecoCounter = (Integer)ConfigHolder.common.router.ecoTimeout.get();
            this.setChanged();
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    public void setCamouflage(BlockState newCamouflage) {
        if (newCamouflage != this.camouflage) {
            this.camouflage = newCamouflage;
            this.handleSync(true);
        }
    }

    private void handleSync(boolean renderUpdate) {
        Level level = this.nonNullLevel();
        if (!level.isClientSide) {
            if (this.anyPlayerHasThisOpen()) {
                this.blockUpdateNeeded = true;
            } else {
                level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        } else if (renderUpdate) {
            this.requestModelDataUpdate();
            level.setBlocksDirty(this.worldPosition, Blocks.AIR.defaultBlockState(), this.getBlockState());
        }
    }

    private boolean anyPlayerHasThisOpen() {
        return this.nonNullLevel().players().stream().anyMatch(p -> {
            RouterMenu menu;
            AbstractContainerMenu patt0$temp = p.containerMenu;
            return patt0$temp instanceof RouterMenu && (menu = (RouterMenu)patt0$temp).getRouter() == this;
        });
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(CamouflageableBlock.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    public boolean caresAboutItemAttributes() {
        return this.careAboutItemAttributes;
    }

    private void compile() {
        this.compileUpgrades();
        this.compileModules();
        if (this.tunedSyncValue >= 0) {
            this.counter = this.calculateSyncCounter();
        } else if (this.counter < 0) {
            this.counter = this.nonNullLevel().random.nextInt(this.tickRate);
        }
        BlockState state = this.getBlockState();
        this.nonNullLevel().updateNeighborsAt(this.worldPosition, state.getBlock());
        this.setChanged();
        this.recompileNeeded.clear();
    }

    private void compileModules() {
        if (this.recompileNeeded.contains((Object)RecompileFlag.MODULES)) {
            this.setHasPulsedModules(false);
            for (CompiledIndexedModule cim : this.compiledModules) {
                cim.compiledModule.cleanup(this);
            }
            this.compiledModules.clear();
            this.careAboutItemAttributes = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.modulesHandler.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof ModuleItem)) continue;
                ModuleItem moduleItem = (ModuleItem)item;
                CompiledModule cms = moduleItem.compile(this, stack);
                this.compiledModules.add(new CompiledIndexedModule(cms, i));
                cms.onCompiled(this);
                if (!cms.careAboutItemAttributes()) continue;
                this.careAboutItemAttributes = true;
            }
            NeoForge.EVENT_BUS.post((Event)new RouterCompiledEvent.Modules(this));
        }
    }

    private void compileUpgrades() {
        Level level = this.nonNullLevel();
        if (level.isClientSide || this.recompileNeeded.contains((Object)RecompileFlag.UPGRADES)) {
            int prevMufflers = this.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get());
            this.upgradeCount.clear();
            this.permitted.clear();
            this.setCamouflage(null);
            this.tunedSyncValue = -1;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = this.upgradesHandler.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof UpgradeItem)) continue;
                UpgradeItem upgradeItem = (UpgradeItem)item;
                this.upgradeCount.put(upgradeItem, this.getUpgradeCount(upgradeItem) + stack.getCount());
                upgradeItem.onCompiled(stack, this);
            }
            this.itemsPerTick = 1 << Math.min(6, this.getUpgradeCount((UpgradeItem)ModItems.STACK_UPGRADE.get()));
            this.tickRate = Math.max((Integer)ConfigHolder.common.router.hardMinTickRate.get(), (Integer)ConfigHolder.common.router.baseTickRate.get() - (Integer)ConfigHolder.common.router.ticksPerUpgrade.get() * this.getUpgradeCount((UpgradeItem)ModItems.SPEED_UPGRADE.get()));
            this.fluidTransferRate = Math.min((Integer)ConfigHolder.common.router.fluidMaxTransferRate.get(), (Integer)ConfigHolder.common.router.fluidBaseTransferRate.get() + this.getUpgradeCount((UpgradeItem)ModItems.FLUID_UPGRADE.get()) * (Integer)ConfigHolder.common.router.mBperFluidUpgrade.get());
            this.energyStorage.updateForEnergyUpgrades(this.getUpgradeCount((UpgradeItem)ModItems.ENERGY_UPGRADE.get()));
            if (!level.isClientSide) {
                int mufflers = this.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get());
                if (prevMufflers != mufflers) {
                    level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active && mufflers < 3)), 2);
                }
                this.notifyWatchingPlayers();
            }
            NeoForge.EVENT_BUS.post((Event)new RouterCompiledEvent.Upgrades(this));
        }
    }

    private void notifyWatchingPlayers() {
        for (Player player : this.nonNullLevel().players()) {
            RouterMenu c;
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof RouterMenu) || (c = (RouterMenu)abstractContainerMenu).getRouter() != this) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)RouterUpgradesSyncMessage.forRouter(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setTunedSyncValue(int newValue) {
        this.tunedSyncValue = newValue;
    }

    private int calculateSyncCounter() {
        int tuning = this.tunedSyncValue % this.tickRate;
        int compileTime = (int)TickEventHandler.TickCounter % this.tickRate;
        int delta = tuning - compileTime;
        if (delta <= 0) {
            delta += this.tickRate;
        }
        return this.tickRate - delta;
    }

    public void setAllowRedstoneEmission(boolean allow) {
        this.canEmit = allow;
        this.nonNullLevel().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ModularRouterBlock.CAN_EMIT, (Comparable)Boolean.valueOf(this.canEmit)));
    }

    public int getUpgradeCount(UpgradeItem type) {
        return this.upgradeCount.getOrDefault(type, 0);
    }

    public Map<UpgradeItem, Integer> getAllUpgrades() {
        return Collections.unmodifiableMap(this.upgradeCount);
    }

    public void recompileNeeded(RecompileFlag what) {
        this.recompileNeeded.add(what);
    }

    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    private void allocateFluidTransfer(int ticks) {
        int maxTransfer = (Integer)ConfigHolder.common.router.baseTickRate.get() * this.fluidTransferRate;
        this.fluidTransferRemainingIn = Math.min(this.fluidTransferRemainingIn + ticks * this.fluidTransferRate, maxTransfer);
        this.fluidTransferRemainingOut = Math.min(this.fluidTransferRemainingOut + ticks * this.fluidTransferRate, maxTransfer);
    }

    public int getFluidTransferRate() {
        return this.fluidTransferRate;
    }

    public int getCurrentFluidTransferAllowance(TransferDirection dir) {
        return dir == TransferDirection.TO_ROUTER ? this.fluidTransferRemainingIn : this.fluidTransferRemainingOut;
    }

    public void transferredFluid(int amount, TransferDirection dir) {
        switch (dir) {
            case TO_ROUTER: {
                if (this.fluidTransferRemainingIn < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer to router: {} < {}", (Object)this.fluidTransferRemainingIn, (Object)amount);
                }
                this.fluidTransferRemainingIn = Math.max(0, this.fluidTransferRemainingIn - amount);
                break;
            }
            case FROM_ROUTER: {
                if (this.fluidTransferRemainingOut < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer from router: {} < {}", (Object)this.fluidTransferRemainingOut, (Object)amount);
                }
                this.fluidTransferRemainingOut = Math.max(0, this.fluidTransferRemainingOut - amount);
                break;
            }
        }
    }

    public Direction getAbsoluteFacing(RelativeDirection direction) {
        return direction.toAbsolute((Direction)this.getBlockState().getValue((Property)ModularRouterBlock.FACING));
    }

    public ItemStack getBufferItemStack() {
        return this.bufferHandler.getStackInSlot(0);
    }

    public void checkForRedstonePulse() {
        this.redstonePower = this.calculateIncomingRedstonePower(this.worldPosition);
        if (!this.executing && (this.redstoneBehaviour == RedstoneBehaviour.PULSE || this.hasPulsedModules && this.redstoneBehaviour == RedstoneBehaviour.ALWAYS)) {
            if (this.redstonePower > this.lastPower && this.pulseCounter >= this.tickRate) {
                this.allocateFluidTransfer(Math.min(this.pulseCounter, (Integer)ConfigHolder.common.router.baseTickRate.get()));
                this.executeModules(true);
                this.pulseCounter = 0;
                if (this.active) {
                    this.activeTimer = this.tickRate;
                }
            }
            this.lastPower = this.redstonePower;
        }
    }

    public void emitRedstone(RelativeDirection direction, int power, DetectorModule.SignalType signalType) {
        if (direction == RelativeDirection.NONE) {
            Arrays.fill(this.newRedstoneLevels, power);
            Arrays.fill((Object[])this.newSignalType, (Object)signalType);
        } else {
            Direction facing = this.getAbsoluteFacing(direction).getOpposite();
            this.newRedstoneLevels[facing.get3DDataValue()] = power;
            this.newSignalType[facing.get3DDataValue()] = signalType;
        }
    }

    public int getRedstoneLevel(Direction facing, boolean strong) {
        if (!this.canEmit) {
            return -1;
        }
        int i = facing.get3DDataValue();
        if (strong) {
            return this.signalType[i] == DetectorModule.SignalType.STRONG ? this.redstoneLevels[i] : 0;
        }
        return this.signalType[i] != DetectorModule.SignalType.NONE ? this.redstoneLevels[i] : 0;
    }

    private void handleRedstoneEmission() {
        boolean notifyOwnNeighbours = false;
        EnumSet<Direction> toNotify = EnumSet.noneOf(Direction.class);
        if (!this.canEmit) {
            notifyOwnNeighbours = true;
            for (Direction dir : MiscUtil.DIRECTIONS) {
                if (this.signalType[dir.get3DDataValue()] != DetectorModule.SignalType.STRONG) continue;
                toNotify.add(dir.getOpposite());
            }
            Arrays.fill(this.redstoneLevels, 0);
            Arrays.fill((Object[])this.signalType, (Object)DetectorModule.SignalType.NONE);
        } else {
            for (Direction dir : MiscUtil.DIRECTIONS) {
                int i = dir.get3DDataValue();
                if (this.newSignalType[i] != this.signalType[i]) {
                    toNotify.add(dir.getOpposite());
                    this.signalType[i] = this.newSignalType[i];
                }
                if (this.newRedstoneLevels[i] == this.redstoneLevels[i]) continue;
                notifyOwnNeighbours = true;
                if (this.newSignalType[i] == DetectorModule.SignalType.STRONG) {
                    toNotify.add(dir.getOpposite());
                }
                this.redstoneLevels[i] = this.newRedstoneLevels[i];
            }
        }
        Level level = this.nonNullLevel();
        for (Direction f : toNotify) {
            BlockPos pos2 = this.worldPosition.relative(f);
            level.updateNeighborsAt(pos2, level.getBlockState(pos2).getBlock());
        }
        if (notifyOwnNeighbours) {
            level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    public void addPermittedIds(Set<UUID> permittedIds) {
        this.permitted.addAll(permittedIds);
    }

    public boolean isPermitted(Player player) {
        if (this.permitted.isEmpty() || this.permitted.contains(player.getUUID())) {
            return true;
        }
        return Arrays.stream(InteractionHand.values()).anyMatch(hand -> player.getItemInHand(hand).getItem() == ModItems.OVERRIDE_CARD.get());
    }

    public boolean isBufferFull() {
        ItemStack stack = this.bufferHandler.getStackInSlot(0);
        return !stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize();
    }

    public boolean isBufferEmpty() {
        return this.bufferHandler.getStackInSlot(0).isEmpty();
    }

    public ItemStack peekBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, true);
    }

    public ItemStack extractBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, false);
    }

    public ItemStack insertBuffer(ItemStack stack) {
        return this.bufferHandler.insertItem(0, stack, false);
    }

    public void setBufferItemStack(ItemStack stack) {
        this.bufferHandler.setStackInSlot(0, stack);
    }

    public boolean getEcoMode() {
        return this.ecoMode;
    }

    public void setHasPulsedModules(boolean hasPulsedModules) {
        this.hasPulsedModules = hasPulsedModules;
    }

    public int getRedstonePower() {
        if (this.redstonePower < 0) {
            this.redstonePower = this.calculateIncomingRedstonePower(this.worldPosition);
        }
        return this.redstonePower;
    }

    private int calculateIncomingRedstonePower(BlockPos pos) {
        int power = 0;
        for (Direction facing : MiscUtil.DIRECTIONS) {
            if (this.getExtensionData().getInt("ExtruderDist" + String.valueOf(facing)) > 0) continue;
            int p = this.nonNullLevel().getSignal(pos.relative(facing), facing);
            if (p >= 15) {
                return p;
            }
            if (p <= power) continue;
            power = p;
        }
        return power;
    }

    public CompoundTag getExtensionData() {
        if (this.extData == null) {
            this.extData = new CompoundTag();
        }
        return this.extData;
    }

    public void playSound(Player player, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (this.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) == 0) {
            this.nonNullLevel().playSound(player, pos, sound, category, volume, pitch);
        }
    }

    public void notifyModules() {
        this.compiledModules.forEach(cim -> cim.compiledModule.onNeighbourChange(this));
    }

    public int getModuleSlotCount() {
        return 9;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public int getBufferSlotCount() {
        return 1;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.modularrouters.modular_router");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new RouterMenu(windowId, playerInventory, this.getBlockPos());
    }

    public GlobalPos getGlobalPos() {
        return MiscUtil.makeGlobalPos(this.nonNullLevel(), this.worldPosition);
    }

    public void setUpgradesFrom(IItemHandler upgradeCount) {
        if (upgradeCount.getSlots() == this.upgradesHandler.getSlots()) {
            for (int i = 0; i < upgradeCount.getSlots(); ++i) {
                this.upgradesHandler.setStackInSlot(i, upgradeCount.getStackInSlot(i).copy());
            }
        }
        this.compileUpgrades();
    }

    public AABB getRenderBoundingBox() {
        if (this.cachedRenderAABB == null) {
            this.cachedRenderAABB = new AABB(this.getBlockPos());
            this.beams.forEach(beam -> {
                this.cachedRenderAABB = this.cachedRenderAABB.minmax(beam.getAABB(this.getBlockPos()));
            });
        }
        return this.cachedRenderAABB;
    }

    public void addItemBeam(BeamData beamData) {
        if (this.nonNullLevel().isClientSide) {
            this.beams.add(beamData);
            this.cachedRenderAABB = null;
        } else {
            this.pendingBeams.add(beamData);
        }
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyXferRate() {
        return this.energyStorage.getTransferRate();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyDirection(EnergyDirection energyDirection) {
        this.energyDirection = energyDirection;
        this.setChanged();
    }

    public EnergyDirection getEnergyDirection() {
        return this.energyDirection;
    }

    public int getModuleCount() {
        return this.compiledModules.size();
    }

    public IFluidHandlerItem getFluidHandler() {
        return this.bufferHandler.getFluidHandler();
    }

    @Nullable
    public <T> T getBufferCapability(ItemCapability<T, Void> cap) {
        return this.bufferHandler.getCapability(cap);
    }

    public void sendBlockUpdateIfNeeded() {
        if (!this.nonNullLevel().isClientSide && this.blockUpdateNeeded && !this.anyPlayerHasThisOpen()) {
            this.nonNullLevel().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.blockUpdateNeeded = false;
        }
    }

    class ModuleHandler
    extends RouterItemHandler {
        ModuleHandler(ModularRouterBlockEntity this$0) {
            super(RecompileFlag.MODULES, this$0.getModuleSlotCount(), s -> s.getItem() instanceof ModuleItem);
        }
    }

    class UpgradeHandler
    extends RouterItemHandler {
        UpgradeHandler(ModularRouterBlockEntity this$0) {
            super(RecompileFlag.UPGRADES, this$0.getUpgradeSlotCount(), s -> s.getItem() instanceof UpgradeItem);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!super.isItemValid(slot, stack)) {
                return false;
            }
            UpgradeItem item = (UpgradeItem)stack.getItem();
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack inSlot = this.getStackInSlot(i);
                if (inSlot.isEmpty() || slot == i || stack.getItem() != inSlot.getItem() && ((UpgradeItem)inSlot.getItem()).isCompatibleWith(item) && item.isCompatibleWith((UpgradeItem)inSlot.getItem())) continue;
                return false;
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            int n;
            Item item = stack.getItem();
            if (item instanceof UpgradeItem) {
                UpgradeItem u = (UpgradeItem)item;
                n = u.getStackLimit(slot);
            } else {
                n = 0;
            }
            return n;
        }
    }

    class RouterEnergyBuffer
    extends EnergyStorage {
        private int excess;

        public RouterEnergyBuffer(int capacity) {
            super(capacity);
            this.excess = 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!ModularRouterBlockEntity.this.getRedstoneBehaviour().shouldRun(ModularRouterBlockEntity.this.getRedstonePower() > 0, false)) {
                return 0;
            }
            int n = super.receiveEnergy(maxReceive, simulate);
            if (n != 0 && !simulate) {
                ModularRouterBlockEntity.this.setChanged();
            }
            return n;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!ModularRouterBlockEntity.this.getRedstoneBehaviour().shouldRun(ModularRouterBlockEntity.this.getRedstonePower() > 0, false)) {
                return 0;
            }
            int n = super.extractEnergy(maxExtract, simulate);
            if (n != 0 && !simulate) {
                ModularRouterBlockEntity.this.setChanged();
            }
            return n;
        }

        void updateForEnergyUpgrades(int nEnergyUpgrades) {
            int oldCapacity = this.capacity;
            this.capacity = (Integer)ConfigHolder.common.router.fePerEnergyUpgrade.get() * nEnergyUpgrades;
            if (this.energy > this.capacity) {
                this.excess += this.energy - this.capacity;
                this.energy = this.capacity;
            } else {
                int available = this.capacity - this.energy;
                int toMove = Math.min(available, this.excess);
                this.excess -= toMove;
                this.energy += toMove;
            }
            this.maxExtract = this.maxReceive = (Integer)ConfigHolder.common.router.feXferPerEnergyUpgrade.get() * nEnergyUpgrades;
            if (oldCapacity == 0 && this.capacity != 0 || oldCapacity != 0 && this.capacity == 0) {
                ModularRouterBlockEntity.this.nonNullLevel().updateNeighborsAt(ModularRouterBlockEntity.this.getBlockPos(), (Block)ModBlocks.MODULAR_ROUTER.get());
            }
        }

        public int getTransferRate() {
            return this.maxExtract;
        }

        public Tag serializeNBT(HolderLookup.Provider provider) {
            return (Tag)Util.make((Object)new CompoundTag(), tag -> {
                if (this.energy > 0) {
                    tag.putInt("Energy", this.energy);
                }
                if (this.capacity > 0) {
                    tag.putInt("Capacity", this.capacity);
                }
                if (this.excess > 0) {
                    tag.putInt("Excess", this.excess);
                }
            });
        }

        public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
            if (!(nbt instanceof CompoundTag)) {
                throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
            }
            CompoundTag compound = (CompoundTag)nbt;
            this.energy = compound.getInt("Energy");
            this.capacity = compound.getInt("Capacity");
            this.excess = compound.getInt("Excess");
        }

        public int getCapacity() {
            return this.capacity;
        }

        void setEnergyStored(int energyStored) {
            this.energy = Math.min(energyStored, this.capacity);
        }
    }

    public class TrackedEnergy
    implements ContainerData {
        public int get(int idx) {
            int res = 0;
            if (idx == 0) {
                res = ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF;
            } else if (idx == 1) {
                res = (ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF0000) >> 16;
            }
            return res;
        }

        public void set(int idx, int val) {
            if (val < 0) {
                val += 65536;
            }
            if (idx == 0) {
                ModularRouterBlockEntity.this.energyStorage.setEnergyStored(ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF0000 | val);
            } else if (idx == 1) {
                ModularRouterBlockEntity.this.energyStorage.setEnergyStored(ModularRouterBlockEntity.this.energyStorage.getEnergyStored() & 0xFFFF | val << 16);
            }
        }

        public int getCount() {
            return 2;
        }
    }

    public static enum EnergyDirection implements TranslatableEnum
    {
        FROM_ROUTER("from_router"),
        TO_ROUTER("to_router"),
        NONE("none");

        private final String text;

        private EnergyDirection(String text) {
            this.text = text;
        }

        public static EnergyDirection forValue(String string) {
            try {
                return EnergyDirection.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                return FROM_ROUTER;
            }
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.tooltip.energy." + this.text;
        }
    }

    public static enum RecompileFlag {
        MODULES,
        UPGRADES;

    }

    private record CompiledIndexedModule(CompiledModule compiledModule, int index) {
    }

    abstract class RouterItemHandler
    extends ItemStackHandler {
        private final Predicate<ItemStack> validator;
        private final RecompileFlag flag;

        private RouterItemHandler(RecompileFlag flag, int size, Predicate<ItemStack> validator) {
            super(size);
            this.validator = validator;
            this.flag = flag;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return super.isItemValid(slot, stack) && this.validator.test(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ModularRouterBlockEntity.this.setChanged();
            ModularRouterBlockEntity.this.recompileNeeded(this.flag);
        }

        public ItemContainerContents asContainerContents() {
            return ItemContainerContents.fromItems((List)this.stacks);
        }

        public void fillFrom(ItemContainerContents contents) {
            contents.copyInto(this.stacks);
        }
    }
}

