/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeFluidStack
extends ValueObjectTypeBase<ValueFluidStack>
implements IValueTypeNamed<ValueFluidStack>,
IValueTypeUniquelyNamed<ValueFluidStack>,
IValueTypeNullable<ValueFluidStack> {
    public ValueObjectTypeFluidStack() {
        super("fluidstack", ValueFluidStack.class);
    }

    @Override
    public ValueFluidStack getDefault() {
        return ValueFluidStack.of(FluidStack.EMPTY);
    }

    @Override
    public MutableComponent toCompactString(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? fluidStack.getHoverName().copy().append(String.format(" (%s mB)", fluidStack.getAmount())) : Component.literal((String)"");
    }

    @Override
    public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, ValueFluidStack value) {
        return (Tag)FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)valueDeseralizationContext.holderLookupProvider().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)value.getRawValue()).getOrThrow();
    }

    @Override
    public ValueFluidStack deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value instanceof CompoundTag) {
            FluidStack fluidStack = (FluidStack)((Pair)FluidStack.OPTIONAL_CODEC.decode((DynamicOps)valueDeseralizationContext.holderLookupProvider().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)value).getOrThrow()).getFirst();
            return ValueFluidStack.of(fluidStack);
        }
        return null;
    }

    @Override
    public String getName(ValueFluidStack a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueFluidStack a) {
        return a.getRawValue().isEmpty();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueFluidStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueFluidStack>(this){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                return itemStack.isEmpty() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent() ? null : Component.translatable((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
            }

            @Override
            public ValueFluidStack getValue(ItemStack itemStack) {
                return ValueFluidStack.of(Helpers.getFluidStack(itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? String.format("%s %s", BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()), fluidStack.getAmount()) : "";
    }

    public static class ValueFluidStack
    extends ValueBase {
        private final FluidStack fluidStack;

        private ValueFluidStack(FluidStack itemStack) {
            super(ValueTypes.OBJECT_FLUIDSTACK);
            this.fluidStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueFluidStack for a null FluidStack.");
        }

        public static ValueFluidStack of(FluidStack itemStack) {
            return new ValueFluidStack(itemStack);
        }

        public FluidStack getRawValue() {
            return this.fluidStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueFluidStack && FluidStack.matches((FluidStack)this.getRawValue(), (FluidStack)((ValueFluidStack)o).getRawValue());
        }

        public int hashCode() {
            return this.fluidStack.hashCode();
        }

        @Override
        public String toString() {
            return "ValueObjectTypeFluidStack.ValueFluidStack(fluidStack=" + String.valueOf(this.fluidStack) + ")";
        }
    }
}

