/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block", ValueBlock.class);
    }

    public static MutableComponent getBlockkDisplayNameSafe(BlockState blockState) {
        return Component.translatable((String)blockState.getBlock().getDescriptionId());
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.AIR.defaultBlockState());
    }

    @Override
    public MutableComponent toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
            if (!itemStack.isEmpty()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return Component.literal((String)"");
    }

    @Override
    public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundTag();
        }
        return BlockHelpers.serializeBlockState((BlockState)((BlockState)value.getRawValue().get()));
    }

    @Override
    public ValueBlock deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value.getId() == 0 || value.getId() == 10 && ((CompoundTag)value).isEmpty()) {
            return ValueBlock.of(Blocks.AIR.defaultBlockState());
        }
        return ValueBlock.of(BlockHelpers.deserializeBlockState((HolderGetter)valueDeseralizationContext.holderLookupProvider().lookupOrThrow(Registries.BLOCK), (CompoundTag)((CompoundTag)value)));
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(this){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                if (!itemStack.isEmpty() && !(itemStack.getItem() instanceof BlockItem)) {
                    return Component.translatable((String)"valuetype.integrateddynamics.error.block.no_block");
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.isEmpty() ? Blocks.AIR.defaultBlockState() : BlockHelpers.getBlockStateFromItemStack((ItemStack)itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            return BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString();
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<BlockState> {
        private ValueBlock(BlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(BlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(BlockState a, BlockState b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

