/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.mixin.AetherMixinHooks;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setLastHurtMob(Lnet/minecraft/world/entity/Entity;)V", shift=At.Shift.AFTER)}, method={"attack(Lnet/minecraft/world/entity/Entity;)V"})
    private void attack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        if (target instanceof LivingEntity) {
            AbilityHooks.AccessoryHooks.damageGloves(player);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"rideTick()V"})
    private void rideTick(CallbackInfo ci) {
        Entity entity;
        Player player = (Player)this;
        if (!player.level().isClientSide() && player.isPassenger() && (entity = player.getVehicle()) instanceof MountableAnimal) {
            MountableAnimal mountableAnimal = (MountableAnimal)entity;
            mountableAnimal.setPlayerTriedToCrouch(player.isShiftKeyDown());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isModelPartShown(Lnet/minecraft/world/entity/player/PlayerModelPart;)Z"}, cancellable=true)
    private void isModelPartShown(PlayerModelPart part, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        ItemStack stack = AetherMixinHooks.isCapeVisible((LivingEntity)player);
        if (!stack.isEmpty()) {
            cir.setReturnValue((Object)true);
        }
    }
}

