/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.DroppedItemAttachment;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aether.network.packet.clientbound.SetVehiclePacket;
import com.aetherteam.aether.world.LevelUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void travel(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!((Boolean)AetherConfig.SERVER.disable_falling_to_overworld.get()).booleanValue() && serverLevel.dimension() == LevelUtil.destinationDimension() && entity.getY() <= (double)serverLevel.getMinBuildHeight() && !entity.isPassenger()) {
                ItemEntity itemEntity;
                Projectile projectile;
                if (entity instanceof Player || entity.isVehicle() || entity instanceof Saddleable && ((Saddleable)entity).isSaddled()) {
                    EntityMixin.entityFell(entity);
                } else if (entity instanceof Projectile && (projectile = (Projectile)entity).getOwner() instanceof Player) {
                    EntityMixin.entityFell((Entity)projectile);
                } else if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).hasData(AetherDataAttachments.DROPPED_ITEM) && (itemEntity.getOwner() instanceof Player || ((DroppedItemAttachment)itemEntity.getData(AetherDataAttachments.DROPPED_ITEM)).getOwner(level) instanceof Player)) {
                    EntityMixin.entityFell(entity);
                }
            }
        }
    }

    @Unique
    @Nullable
    private static Entity entityFell(Entity entity) {
        ServerLevel destination;
        Level serverLevel = entity.level();
        MinecraftServer minecraftserver = serverLevel.getServer();
        if (minecraftserver != null && (destination = minecraftserver.getLevel(LevelUtil.returnDimension())) != null && LevelUtil.returnDimension() != LevelUtil.destinationDimension()) {
            List passengers = entity.getPassengers();
            serverLevel.getProfiler().push("aether_fall");
            entity.setPortalCooldown();
            double vehicleOffset = 0.0;
            if (entity.getVehicle() != null) {
                vehicleOffset = entity.getVehicle().getBbHeight();
            }
            DimensionTransition transition = new DimensionTransition(destination, new Vec3(entity.getX(), (double)((float)destination.getMaxBuildHeight() - entity.getBbHeight()) - vehicleOffset, entity.getZ()), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), false, DimensionTransition.DO_NOTHING);
            Entity target = entity.changeDimension(transition);
            serverLevel.getProfiler().pop();
            if (target != null) {
                for (Entity passenger : passengers) {
                    passenger.stopRiding();
                    Entity nextPassenger = EntityMixin.entityFell(passenger);
                    if (nextPassenger == null) continue;
                    nextPassenger.startRiding(target);
                    if (!(target instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetVehiclePacket(nextPassenger.getId(), target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (target instanceof ServerPlayer) {
                    DimensionHooks.teleportationTimer = 500;
                }
            }
            return target;
        }
        return null;
    }
}

