/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.PhoenixArrowAttachment;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class AbstractArrowMixin {
    @Shadow
    protected boolean inGround;
    @Shadow
    protected int inGroundTime;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;tick()V", shift=At.Shift.AFTER)}, method={"tick()V"})
    private void tick(CallbackInfo ci) {
        PhoenixArrowAttachment attachment;
        AbstractArrow arrow = (AbstractArrow)this;
        if (arrow.hasData(AetherDataAttachments.PHOENIX_ARROW) && (attachment = (PhoenixArrowAttachment)arrow.getData(AetherDataAttachments.PHOENIX_ARROW)).isPhoenixArrow() && !arrow.level().isClientSide()) {
            attachment.setSynched(arrow.getId(), INBTSynchable.Direction.CLIENT, "setPhoenixArrow", true);
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.spawnParticles(arrow);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.spawnParticles(arrow);
                }
            }
        }
    }

    @Unique
    private void spawnParticles(AbstractArrow arrow) {
        Level level = arrow.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, arrow.getX() + serverLevel.getRandom().nextGaussian() / 5.0, arrow.getY() + serverLevel.getRandom().nextGaussian() / 3.0, arrow.getZ() + serverLevel.getRandom().nextGaussian() / 5.0, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

