/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.abilities.armor;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface ValkyrieArmor {
    public static void handleFlight(LivingEntity entity) {
        if (EquipmentUtil.hasFullValkyrieSet(entity) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().flying) {
                AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                Vec3 deltaMovement = player.getDeltaMovement();
                if (data.isJumping() && !ValkyrieArmor.onGround(player)) {
                    if (data.getFlightModifier() >= data.getFlightModifierMax()) {
                        data.setFlightModifier(data.getFlightModifierMax());
                    }
                    if (data.getFlightTimer() > 2) {
                        if (data.getFlightTimer() < data.getFlightTimerMax()) {
                            data.setFlightModifier(data.getFlightModifier() + 0.25f);
                            data.setFlightTimer(data.getFlightTimer() + 1);
                        }
                    } else {
                        data.setFlightTimer(data.getFlightTimer() + 1);
                    }
                } else if (!data.isJumping()) {
                    data.setFlightModifier(1.0f);
                }
                if (ValkyrieArmor.onGround(player)) {
                    data.setFlightTimer(0);
                    data.setFlightModifier(1.0f);
                }
                if (data.isJumping() && !ValkyrieArmor.onGround(player) && data.getFlightTimer() > 2 && data.getFlightTimer() < data.getFlightTimerMax() && data.getFlightModifier() > 1.0f) {
                    player.setDeltaMovement(deltaMovement.x(), (double)(0.025f * data.getFlightModifier()), deltaMovement.z());
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.connection;
                    serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                }
            }
        }
    }

    private static boolean onGround(Player player) {
        return player.onGround() || player.isInFluidType();
    }
}

