/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.projectile.dart.AbstractDart;
import com.aetherteam.aether.item.combat.DartItem;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class DartShooterItem
extends ProjectileWeaponItem {
    private final Supplier<? extends Item> dartType;

    public DartShooterItem(Supplier<? extends Item> dartType, Item.Properties properties) {
        super(properties);
        this.dartType = dartType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack;
        boolean hasAmmo = !player.getProjectile(heldStack = player.getItemInHand(hand)).isEmpty();
        InteractionResultHolder result = EventHooks.onArrowNock((ItemStack)heldStack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (result == null) {
            if (player.getAbilities().instabuild || hasAmmo) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return result;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        Player player;
        ItemStack itemStack;
        if (user instanceof Player && !(itemStack = (player = (Player)user).getProjectile(stack)).isEmpty()) {
            EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)0, (!itemStack.isEmpty() ? 1 : 0) != 0);
            List list = DartShooterItem.draw((ItemStack)stack, (ItemStack)itemStack, (LivingEntity)player);
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (!list.isEmpty()) {
                    this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, 3.1f, 1.2f, false, null);
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)AetherSoundEvents.ITEM_DART_SHOOTER_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return stack;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity, inaccuracy);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Object dart;
        Item item = ammo.getItem();
        DartItem dartItem = item instanceof DartItem ? (dart = (DartItem)item) : (DartItem)this.getDartType().get();
        dart = dartItem.createDart(level, ammo, shooter, weapon);
        if (dart != null) {
            dart.setNoGravity(true);
            return this.customDart((AbstractDart)((Object)dart), ammo, weapon);
        }
        return super.createProjectile(level, shooter, weapon, ammo, isCrit);
    }

    public AbstractDart customDart(AbstractDart dart, ItemStack projectileStack, ItemStack weaponStack) {
        return dart;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 10;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.is(this.getDartType().get());
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return ImmutableSet.of((Object)Enchantments.POWER, (Object)Enchantments.PUNCH).contains((Object)enchantment.getKey());
    }

    public Supplier<? extends Item> getDartType() {
        return this.dartType;
    }
}

