/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class MountableAnimal
extends AetherAnimal
implements MountableMob,
Saddleable,
NotGrounded {
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.defineId(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_JUMPED_ID = SynchedEntityData.defineId(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_MOUNT_JUMPING_ID = SynchedEntityData.defineId(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_CROUCHED_ID = SynchedEntityData.defineId(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ENTITY_ON_GROUND_ID = SynchedEntityData.defineId(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected MountableAnimal(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SADDLE_ID, (Object)false);
        builder.define(DATA_PLAYER_JUMPED_ID, (Object)false);
        builder.define(DATA_MOUNT_JUMPING_ID, (Object)false);
        builder.define(DATA_PLAYER_CROUCHED_ID, (Object)false);
        builder.define(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public void tick() {
        this.tick((Mob)this);
        this.riderTick();
        super.tick();
        if (this.onGround()) {
            this.setEntityOnGround(true);
        }
        if (this.getPlayerJumped()) {
            this.setEntityOnGround(false);
        }
    }

    public void riderTick() {
        this.riderTick((Mob)this);
    }

    public void travel(Vec3 vector3d) {
        this.travel((Mob)this, vector3d);
    }

    @Override
    public void travelWithInput(Vec3 travelVec) {
        super.travel(travelVec);
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        this.setEntityOnGround(false);
    }

    public InteractionResult mobInteract(Player playerEntity, InteractionHand hand) {
        boolean flag = this.isFood(playerEntity.getItemInHand(hand));
        if (!flag && this.isSaddled() && !this.isVehicle() && !playerEntity.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                playerEntity.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        InteractionResult interactionResult = super.mobInteract(playerEntity, hand);
        if (!interactionResult.consumesAction()) {
            ItemStack itemstack = playerEntity.getItemInHand(hand);
            return itemstack.is(Items.SADDLE) ? itemstack.interactLivingEntity(playerEntity, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return interactionResult;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() != Direction.Axis.Y) {
            int[][] offsets = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos blockPos = this.blockPosition();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (Pose pose : livingEntity.getDismountPoses()) {
                AABB bounds = livingEntity.getLocalBoundsForPose(pose);
                for (int[] offset : offsets) {
                    mutableBlockPos.set(blockPos.getX() + offset[0], blockPos.getY(), blockPos.getZ() + offset[1]);
                    double d0 = this.level().getBlockFloorHeight((BlockPos)mutableBlockPos);
                    if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                    Vec3 vector3d = Vec3.upFromBottomCenterOf((Vec3i)mutableBlockPos, (double)d0);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)livingEntity, (AABB)bounds.move(vector3d))) continue;
                    livingEntity.setPose(pose);
                    return vector3d;
                }
            }
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isSaddled()) {
                return livingEntity;
            }
        }
        return null;
    }

    protected boolean canRide(Entity entityIn) {
        return true;
    }

    public void equipSaddle(ItemStack stack, @Nullable SoundSource soundCategory) {
        this.setSaddled(true);
        if (soundCategory != null && this.getSaddledSound() != null) {
            this.level().playSound(null, (Entity)this, this.getSaddledSound(), soundCategory, 0.5f, 1.0f);
        }
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    public boolean isSaddled() {
        return (Boolean)this.getEntityData().get(DATA_SADDLE_ID);
    }

    public void setSaddled(boolean isSaddled) {
        this.getEntityData().set(DATA_SADDLE_ID, (Object)isSaddled);
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.getEntityData().get(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.getEntityData().set(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.getEntityData().get(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.getEntityData().set(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    public boolean playerTriedToCrouch() {
        return (Boolean)this.getEntityData().get(DATA_PLAYER_CROUCHED_ID);
    }

    public void setPlayerTriedToCrouch(boolean playerTriedToCrouch) {
        this.getEntityData().set(DATA_PLAYER_CROUCHED_ID, (Object)playerTriedToCrouch);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.getEntityData().get(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.getEntityData().set(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    @Override
    public boolean canJump() {
        return this.isSaddled() && this.onGround();
    }

    @Override
    public double getMountJumpStrength() {
        return 1.8;
    }

    @Override
    public float getSteeringSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.625f;
    }

    public float getFlyingSpeed() {
        return this.getControllingPassenger() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    @Override
    public double jumpFactor() {
        return this.getBlockJumpFactor();
    }

    @Nullable
    protected SoundEvent getSaddledSound() {
        return null;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Saddled", this.isSaddled());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Saddled")) {
            this.setSaddled(tag.getBoolean("Saddled"));
        }
    }
}

