/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.builders;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.data.resources.registries.AetherBiomes;
import com.aetherteam.aether.data.resources.registries.AetherPlacedFeatures;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.sounds.Musics;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AetherBiomeBuilders {
    public static Biome skyrootMeadowBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_MEADOW_TREES_PLACEMENT));
    }

    public static Biome skyrootGroveBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_GROVE_TREES_PLACEMENT));
    }

    public static Biome skyrootWoodlandBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_WOODLAND_TREES_PLACEMENT));
    }

    public static Biome skyrootForestBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_FOREST_TREES_PLACEMENT));
    }

    public static Biome makeDefaultBiome(BiomeGenerationSettings.Builder builder) {
        return AetherBiomeBuilders.fullDefinition(false, 0.8f, 0.0f, new BiomeSpecialEffects.Builder().fogColor(9671612).skyColor(0xC0C0FF).waterColor(4159204).waterFogColor(329011).grassColorOverride(11665355).foliageColorOverride(11665355).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(Musics.createGameMusic(AetherSoundEvents.MUSIC_AETHER)).build(), new MobSpawnSettings.Builder().addMobCharge((EntityType)AetherEntityTypes.COCKATRICE.get(), 0.5, 0.15).addMobCharge((EntityType)AetherEntityTypes.ZEPHYR.get(), 0.6, 0.16).addMobCharge((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 0.4, 0.11).addMobCharge((EntityType)AetherEntityTypes.BLUE_SWET.get(), 0.5, 0.1).addMobCharge((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 0.5, 0.1).addMobCharge((EntityType)AetherEntityTypes.WHIRLWIND.get(), 0.4, 0.1).addMobCharge((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 0.4, 0.1).addMobCharge((EntityType)AetherEntityTypes.AERWHALE.get(), 0.5, 0.11).addSpawn(AetherMobCategory.AETHER_DARKNESS_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.COCKATRICE.get(), 8, 1, 1)).addSpawn(AetherMobCategory.AETHER_SKY_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.ZEPHYR.get(), 20, 1, 1)).addSpawn(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 7, 1, 1)).addSpawn(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.BLUE_SWET.get(), 6, 1, 1)).addSpawn(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 6, 1, 1)).addSpawn(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.WHIRLWIND.get(), 3, 1, 1)).addSpawn(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 1, 1, 1)).addSpawn(AetherMobCategory.AETHER_AERWHALE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERWHALE.get(), 10, 1, 1)).creatureGenerationProbability(0.25f).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.PHYG.get(), 10, 3, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.SHEEPUFF.get(), 12, 3, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.FLYING_COW.get(), 12, 2, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERBUNNY.get(), 11, 3, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.MOA.get(), 8, 1, 3)).build(), builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, AetherPlacedFeatures.QUICKSOIL_SHELF_PLACEMENT).addFeature(GenerationStep.Decoration.LAKES, AetherPlacedFeatures.WATER_LAKE_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_AETHER_DIRT_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_ICESTONE_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_AMBROSIUM_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_ZANITE_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_GRAVITITE_BURIED_PLACEMENT).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_GRAVITITE_PLACEMENT).addFeature(GenerationStep.Decoration.FLUID_SPRINGS, AetherPlacedFeatures.WATER_SPRING_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.HOLIDAY_TREE_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.GRASS_PATCH_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.TALL_GRASS_PATCH_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.WHITE_FLOWER_PATCH_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.PURPLE_FLOWER_PATCH_PLACEMENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.BERRY_BUSH_PATCH_PLACEMENT).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.CRYSTAL_ISLAND_PLACEMENT).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.COLD_AERCLOUD_PLACEMENT).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.BLUE_AERCLOUD_PLACEMENT).addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.GOLDEN_AERCLOUD_PLACEMENT).build(), Biome.TemperatureModifier.NONE);
    }

    public static Biome fullDefinition(boolean precipitation, float temperature, float downfall, BiomeSpecialEffects effects, MobSpawnSettings spawnSettings, BiomeGenerationSettings generationSettings, Biome.TemperatureModifier temperatureModifier) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(effects).mobSpawnSettings(spawnSettings).generationSettings(generationSettings).temperatureAdjustment(temperatureModifier).build();
    }

    public static BiomeSource buildAetherBiomeSource(HolderGetter<Biome> biomes) {
        Climate.Parameter fullRange = Climate.Parameter.span((float)-1.0f, (float)1.0f);
        Climate.Parameter temps1 = Climate.Parameter.span((float)-1.0f, (float)-0.8f);
        Climate.Parameter temps2 = Climate.Parameter.span((float)-0.8f, (float)0.0f);
        Climate.Parameter temps3 = Climate.Parameter.span((float)0.0f, (float)0.4f);
        Climate.Parameter temps4 = Climate.Parameter.span((float)0.4f, (float)0.93f);
        Climate.Parameter temps5 = Climate.Parameter.span((float)0.93f, (float)0.94f);
        Climate.Parameter temps6 = Climate.Parameter.span((float)0.94f, (float)1.0f);
        return MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)new Climate.ParameterPoint(temps1, fullRange, fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps2, Climate.Parameter.span((float)-1.0f, (float)0.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps2, Climate.Parameter.span((float)0.0f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.span((float)-1.0f, (float)0.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.span((float)0.0f, (float)0.8f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.span((float)0.8f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps4, Climate.Parameter.span((float)-1.0f, (float)-0.1f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps4, Climate.Parameter.span((float)-0.1f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.span((float)-1.0f, (float)-0.6f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.span((float)-0.6f, (float)-0.3f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.span((float)-0.3f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps6, Climate.Parameter.span((float)-1.0f, (float)-0.1f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps6, Climate.Parameter.span((float)-0.1f, (float)0.8f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_WOODLAND)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.span((float)0.8f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.getOrThrow(AetherBiomes.SKYROOT_FOREST)))));
    }
}

