/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.generators;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.providers.AetherRecipeProvider;
import com.aetherteam.aether.data.resources.registries.AetherMoaTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.item.AetherItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;

public class AetherRecipeData
extends AetherRecipeProvider {
    public AetherRecipeData(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, "aether");
    }

    protected void buildRecipes(RecipeOutput consumer, HolderLookup.Provider holderLookup) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get())).group("mossy_holystone").requires((ItemLike)AetherBlocks.HOLYSTONE.get()).requires((ItemLike)Blocks.VINE).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer, this.name("mossy_holystone_with_vine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get())).group("mossy_holystone").requires((ItemLike)AetherBlocks.HOLYSTONE.get()).requires((ItemLike)Blocks.MOSS_BLOCK).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer, this.name("mossy_holystone_with_moss"));
        AetherRecipeData.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_WOOD.get()), (ItemLike)((ItemLike)AetherBlocks.SKYROOT_LOG.get()));
        AetherRecipeData.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)AetherBlocks.GOLDEN_OAK_WOOD.get()), (ItemLike)((ItemLike)AetherBlocks.GOLDEN_OAK_LOG.get()));
        AetherRecipeData.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)AetherBlocks.STRIPPED_SKYROOT_WOOD.get()), (ItemLike)((ItemLike)AetherBlocks.STRIPPED_SKYROOT_LOG.get()));
        AetherRecipeData.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()), AetherTags.Items.CRAFTS_SKYROOT_PLANKS, (int)4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get()), (int)4).define(Character.valueOf('#'), (ItemLike)AetherBlocks.HOLYSTONE.get()).pattern("##").pattern("##").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        this.oreBlockStorageRecipesRecipesWithCustomUnpacking(consumer, RecipeCategory.MISC, (ItemLike)AetherItems.AMBROSIUM_SHARD.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.AMBROSIUM_BLOCK.get(), "ambrosium_shard_from_ambrosium_block", "ambrosium_shard");
        this.oreBlockStorageRecipesRecipesWithCustomUnpacking(consumer, RecipeCategory.MISC, (ItemLike)AetherItems.ZANITE_GEMSTONE.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ZANITE_BLOCK.get(), "zanite_gemstone_from_zanite_block", "zanite_gemstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.QUICKSOIL_GLASS_PANE.get()), (int)16).define(Character.valueOf('#'), (ItemLike)AetherBlocks.QUICKSOIL_GLASS.get()).pattern("###").pattern("###").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.QUICKSOIL_GLASS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.QUICKSOIL_GLASS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.ALTAR.get()), (int)1).define(Character.valueOf('H'), (ItemLike)AetherBlocks.HOLYSTONE.get()).define(Character.valueOf('Z'), AetherTags.Items.GEMS_ZANITE).pattern("HHH").pattern("HZH").pattern("HHH").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.FREEZER.get()), (int)1).define(Character.valueOf('H'), (ItemLike)AetherBlocks.HOLYSTONE.get()).define(Character.valueOf('I'), (ItemLike)AetherBlocks.ICESTONE.get()).define(Character.valueOf('P'), (ItemLike)AetherBlocks.SKYROOT_PLANKS.get()).pattern("HHH").pattern("HIH").pattern("PPP").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get()), (int)1).define(Character.valueOf('H'), (ItemLike)AetherBlocks.HOLYSTONE.get()).define(Character.valueOf('T'), (ItemLike)AetherBlocks.AMBROSIUM_TORCH.get()).pattern("HHH").pattern("HTH").pattern("HHH").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.AMBROSIUM_TORCH.get()), (int)4).define(Character.valueOf('A'), (ItemLike)AetherItems.AMBROSIUM_SHARD.get()).define(Character.valueOf('/'), AetherTags.Items.SKYROOT_STICKS).pattern("A").pattern("/").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.HOLYSTONE_PICKAXE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.HOLYSTONE_PICKAXE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_SIGN.get()), (int)3).group("wooden_sign").define(Character.valueOf('P'), (ItemLike)((Block)AetherBlocks.SKYROOT_PLANKS.get()).asItem()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("PPP").pattern("PPP").pattern(" / ").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_HANGING_SIGN.get()), (int)6).group("hanging_sign").define(Character.valueOf('#'), (ItemLike)AetherBlocks.STRIPPED_SKYROOT_LOG.get()).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.STRIPPED_SKYROOT_LOG.get()))).save(consumer);
        this.fence((Supplier<? extends Block>)AetherBlocks.SKYROOT_FENCE, (Supplier<? extends Block>)AetherBlocks.SKYROOT_PLANKS).save(consumer);
        this.fenceGate((Supplier<? extends Block>)AetherBlocks.SKYROOT_FENCE_GATE, (Supplier<? extends Block>)AetherBlocks.SKYROOT_PLANKS).save(consumer);
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.CARVED_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.CARVED_STONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.ANGELIC_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.ANGELIC_STONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.HELLFIRE_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.HELLFIRE_STONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.ICESTONE_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.ICESTONE.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get()));
        AetherRecipeData.wall((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.AEROGEL_WALL.get()), (ItemLike)((ItemLike)AetherBlocks.AEROGEL.get()));
        this.stairs((Supplier)AetherBlocks.SKYROOT_STAIRS, (Supplier)AetherBlocks.SKYROOT_PLANKS).group("wooden_stairs").save(consumer);
        this.stairs((Supplier)AetherBlocks.CARVED_STAIRS, (Supplier)AetherBlocks.CARVED_STONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.ANGELIC_STAIRS, (Supplier)AetherBlocks.ANGELIC_STONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.HELLFIRE_STAIRS, (Supplier)AetherBlocks.HELLFIRE_STONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.HOLYSTONE_STAIRS, (Supplier)AetherBlocks.HOLYSTONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.MOSSY_HOLYSTONE_STAIRS, (Supplier)AetherBlocks.MOSSY_HOLYSTONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.ICESTONE_STAIRS, (Supplier)AetherBlocks.ICESTONE).save(consumer);
        this.stairs((Supplier)AetherBlocks.HOLYSTONE_BRICK_STAIRS, (Supplier)AetherBlocks.HOLYSTONE_BRICKS).save(consumer);
        this.stairs((Supplier)AetherBlocks.AEROGEL_STAIRS, (Supplier)AetherBlocks.AEROGEL).save(consumer);
        AetherRecipeData.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.SKYROOT_PLANKS.get()})).group("wooden_slab").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).save(consumer);
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.CARVED_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.CARVED_STONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.ANGELIC_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.ANGELIC_STONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.HELLFIRE_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.HELLFIRE_STONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.ICESTONE_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.ICESTONE.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get()));
        AetherRecipeData.slab((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.AEROGEL_SLAB.get()), (ItemLike)((ItemLike)AetherBlocks.AEROGEL.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_BOOKSHELF.get()), (int)1).define(Character.valueOf('P'), (ItemLike)AetherBlocks.SKYROOT_PLANKS.get()).define(Character.valueOf('B'), (ItemLike)Items.BOOK).pattern("PPP").pattern("BBB").pattern("PPP").unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.BOOK), AetherRecipeData.has((ItemLike)Items.BOOK)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_BED.get()), (int)1).define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("WWW").pattern("PPP").unlockedBy("has_wool", AetherRecipeData.has((TagKey)ItemTags.WOOL)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PURPLE_DYE).group("purple_dye").requires((ItemLike)AetherBlocks.PURPLE_FLOWER.get()).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.PURPLE_FLOWER.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.PURPLE_FLOWER.get()))).save(consumer, this.name("flower_to_purple_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHITE_DYE).group("white_dye").requires((ItemLike)AetherBlocks.WHITE_FLOWER.get()).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.WHITE_FLOWER.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.WHITE_FLOWER.get()))).save(consumer, this.name("flower_to_white_dye"));
        this.makePickaxeWithTag((Supplier<? extends Item>)AetherItems.SKYROOT_PICKAXE, AetherTags.Items.SKYROOT_TOOL_CRAFTING, "has_planks").save(consumer);
        this.makeAxeWithTag((Supplier<? extends Item>)AetherItems.SKYROOT_AXE, AetherTags.Items.SKYROOT_TOOL_CRAFTING, "has_planks").save(consumer);
        this.makeShovelWithTag((Supplier<? extends Item>)AetherItems.SKYROOT_SHOVEL, AetherTags.Items.SKYROOT_TOOL_CRAFTING, "has_planks").save(consumer);
        this.makeHoeWithTag((Supplier<? extends Item>)AetherItems.SKYROOT_HOE, AetherTags.Items.SKYROOT_TOOL_CRAFTING, "has_planks").save(consumer);
        this.makePickaxeWithBlock((Supplier<? extends Item>)AetherItems.HOLYSTONE_PICKAXE, (Supplier<? extends Block>)AetherBlocks.HOLYSTONE).save(consumer);
        this.makeAxeWithBlock((Supplier<? extends Item>)AetherItems.HOLYSTONE_AXE, (Supplier<? extends Block>)AetherBlocks.HOLYSTONE).save(consumer);
        this.makeShovelWithBlock((Supplier<? extends Item>)AetherItems.HOLYSTONE_SHOVEL, (Supplier<? extends Block>)AetherBlocks.HOLYSTONE).save(consumer);
        this.makeHoeWithBlock((Supplier<? extends Item>)AetherItems.HOLYSTONE_HOE, (Supplier<? extends Block>)AetherBlocks.HOLYSTONE).save(consumer);
        this.makePickaxeWithTag((Supplier<? extends Item>)AetherItems.ZANITE_PICKAXE, AetherTags.Items.GEMS_ZANITE, "has_zanite").save(consumer);
        this.makeAxeWithTag((Supplier<? extends Item>)AetherItems.ZANITE_AXE, AetherTags.Items.GEMS_ZANITE, "has_zanite").save(consumer);
        this.makeShovelWithTag((Supplier<? extends Item>)AetherItems.ZANITE_SHOVEL, AetherTags.Items.GEMS_ZANITE, "has_zanite").save(consumer);
        this.makeHoeWithTag((Supplier<? extends Item>)AetherItems.ZANITE_HOE, AetherTags.Items.GEMS_ZANITE, "has_zanite").save(consumer);
        this.makePickaxeWithTag((Supplier<? extends Item>)AetherItems.GRAVITITE_PICKAXE, AetherTags.Items.PROCESSED_GRAVITITE, "has_gravitite").save(consumer);
        this.makeAxeWithTag((Supplier<? extends Item>)AetherItems.GRAVITITE_AXE, AetherTags.Items.PROCESSED_GRAVITITE, "has_gravitite").save(consumer);
        this.makeShovelWithTag((Supplier<? extends Item>)AetherItems.GRAVITITE_SHOVEL, AetherTags.Items.PROCESSED_GRAVITITE, "has_gravitite").save(consumer);
        this.makeHoeWithTag((Supplier<? extends Item>)AetherItems.GRAVITITE_HOE, AetherTags.Items.PROCESSED_GRAVITITE, "has_gravitite").save(consumer);
        this.makeSwordWithTag((Supplier<? extends Item>)AetherItems.SKYROOT_SWORD, AetherTags.Items.SKYROOT_TOOL_CRAFTING, "has_planks").save(consumer);
        this.makeSwordWithBlock((Supplier<? extends Item>)AetherItems.HOLYSTONE_SWORD, (Supplier<? extends Block>)AetherBlocks.HOLYSTONE).save(consumer);
        this.makeSwordWithTag((Supplier<? extends Item>)AetherItems.ZANITE_SWORD, AetherTags.Items.GEMS_ZANITE, "has_zanite").save(consumer);
        this.makeSwordWithTag((Supplier<? extends Item>)AetherItems.GRAVITITE_SWORD, AetherTags.Items.PROCESSED_GRAVITITE, "has_gravitite").save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AetherItems.GOLDEN_DART.get()), (int)4).define(Character.valueOf('F'), Tags.Items.FEATHERS).define(Character.valueOf('/'), AetherTags.Items.SKYROOT_STICKS).define(Character.valueOf('G'), (ItemLike)AetherItems.GOLDEN_AMBER.get()).pattern("F").pattern("/").pattern("G").unlockedBy("has_feather", AetherRecipeData.has((TagKey)Tags.Items.FEATHERS)).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.GOLDEN_AMBER.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_AMBER.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get()), (int)1).define(Character.valueOf('P'), (ItemLike)AetherBlocks.SKYROOT_PLANKS.get()).define(Character.valueOf('G'), (ItemLike)AetherItems.GOLDEN_AMBER.get()).pattern("P").pattern("P").pattern("G").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AetherItems.POISON_DART.get()), (int)8).define(Character.valueOf('D'), (ItemLike)AetherItems.GOLDEN_DART.get()).define(Character.valueOf('B'), (ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get()).pattern("DDD").pattern("DBD").pattern("DDD").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.GOLDEN_DART.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_DART.get()))).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AetherItems.POISON_DART_SHOOTER.get()), (int)1).requires((ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get()).requires((ItemLike)AetherItems.AECHOR_PETAL.get()).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get()))).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherItems.AECHOR_PETAL.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.AECHOR_PETAL.get()))).save(consumer);
        this.makeHelmetWithTag((Supplier)AetherItems.ZANITE_HELMET, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeChestplateWithTag((Supplier)AetherItems.ZANITE_CHESTPLATE, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeLeggingsWithTag((Supplier)AetherItems.ZANITE_LEGGINGS, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeBootsWithTag((Supplier)AetherItems.ZANITE_BOOTS, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeHelmetWithTag((Supplier)AetherItems.GRAVITITE_HELMET, (TagKey)AetherTags.Items.PROCESSED_GRAVITITE, "gravitite").save(consumer);
        this.makeChestplateWithTag((Supplier)AetherItems.GRAVITITE_CHESTPLATE, (TagKey)AetherTags.Items.PROCESSED_GRAVITITE, "gravitite").save(consumer);
        this.makeLeggingsWithTag((Supplier)AetherItems.GRAVITITE_LEGGINGS, (TagKey)AetherTags.Items.PROCESSED_GRAVITITE, "gravitite").save(consumer);
        this.makeBootsWithTag((Supplier)AetherItems.GRAVITITE_BOOTS, (TagKey)AetherTags.Items.PROCESSED_GRAVITITE, "gravitite").save(consumer);
        this.makeRing((Supplier)AetherItems.IRON_RING, Items.IRON_INGOT).save(consumer);
        this.makeRing((Supplier)AetherItems.GOLDEN_RING, Items.GOLD_INGOT).save(consumer);
        this.makeRingWithTag((Supplier)AetherItems.ZANITE_RING, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makePendant((Supplier<? extends Item>)AetherItems.IRON_PENDANT, Items.IRON_INGOT).save(consumer);
        this.makePendant((Supplier<? extends Item>)AetherItems.GOLDEN_PENDANT, Items.GOLD_INGOT).save(consumer);
        this.makePendantWithTag((Supplier<? extends Item>)AetherItems.ZANITE_PENDANT, AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeCape((Supplier<? extends Item>)AetherItems.RED_CAPE, Blocks.RED_WOOL.asItem()).save(consumer);
        this.makeCape((Supplier<? extends Item>)AetherItems.BLUE_CAPE, Blocks.BLUE_WOOL.asItem()).group("blue_cape").save(consumer, this.name("blue_cape_blue_wool"));
        this.makeCape((Supplier<? extends Item>)AetherItems.BLUE_CAPE, Blocks.LIGHT_BLUE_WOOL.asItem()).group("blue_cape").save(consumer, this.name("blue_cape_light_blue_wool"));
        this.makeCape((Supplier<? extends Item>)AetherItems.BLUE_CAPE, Blocks.CYAN_WOOL.asItem()).group("blue_cape").save(consumer, this.name("blue_cape_cyan_wool"));
        this.makeCape((Supplier<? extends Item>)AetherItems.YELLOW_CAPE, Blocks.YELLOW_WOOL.asItem()).save(consumer);
        this.makeCape((Supplier<? extends Item>)AetherItems.WHITE_CAPE, Blocks.WHITE_WOOL.asItem()).save(consumer);
        this.makeGlovesWithTag((Supplier)AetherItems.LEATHER_GLOVES, Tags.Items.LEATHERS, "leather").save(consumer);
        this.makeGlovesWithTag((Supplier)AetherItems.IRON_GLOVES, Tags.Items.INGOTS_IRON, "iron").save(consumer);
        this.makeGlovesWithTag((Supplier)AetherItems.GOLDEN_GLOVES, Tags.Items.INGOTS_GOLD, "gold").save(consumer);
        this.makeGlovesWithTag((Supplier)AetherItems.DIAMOND_GLOVES, Tags.Items.GEMS_DIAMOND, "diamond").save(consumer);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.DIAMOND_GLOVES.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)AetherItems.NETHERITE_GLOVES.get())).unlocks("has_netherite_ingot", AetherRecipeData.has((ItemLike)Items.NETHERITE_INGOT)).save(consumer, this.name(AetherRecipeData.getItemName((ItemLike)((ItemLike)AetherItems.NETHERITE_GLOVES.get())) + "_smithing"));
        this.makeGlovesWithTag((Supplier)AetherItems.ZANITE_GLOVES, (TagKey)AetherTags.Items.GEMS_ZANITE, "zanite").save(consumer);
        this.makeGlovesWithTag((Supplier)AetherItems.GRAVITITE_GLOVES, (TagKey)AetherTags.Items.PROCESSED_GRAVITITE, "gravitite").save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AetherItems.SKYROOT_STICK.get()), (int)4).group("sticks").define(Character.valueOf('#'), AetherTags.Items.SKYROOT_STICK_CRAFTING).pattern("#").pattern("#").unlockedBy("has_planks", AetherRecipeData.has(AetherTags.Items.SKYROOT_STICK_CRAFTING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AetherItems.SKYROOT_BUCKET.get()), (int)1).define(Character.valueOf('#'), AetherTags.Items.SKYROOT_TOOL_CRAFTING).pattern("# #").pattern(" # ").unlockedBy("has_planks", AetherRecipeData.has(AetherTags.Items.SKYROOT_TOOL_CRAFTING)).save(consumer);
        AetherRecipeData.twoByTwoPacker((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AetherItems.COLD_PARACHUTE.get()), (ItemLike)((ItemLike)AetherBlocks.COLD_AERCLOUD.get()));
        AetherRecipeData.twoByTwoPacker((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AetherItems.GOLDEN_PARACHUTE.get()), (ItemLike)((ItemLike)AetherBlocks.GOLDEN_AERCLOUD.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AetherItems.NATURE_STAFF.get()), (int)1).define(Character.valueOf('Z'), AetherTags.Items.GEMS_ZANITE).define(Character.valueOf('/'), AetherTags.Items.SKYROOT_STICKS).pattern("Z").pattern("/").unlockedBy("has_zanite", AetherRecipeData.has(AetherTags.Items.GEMS_ZANITE)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AetherItems.BOOK_OF_LORE.get())).group("book_of_lore").requires((ItemLike)Items.BOOK).requires(AetherTags.Items.BOOK_OF_LORE_MATERIALS).unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.BOOK), AetherRecipeData.has((ItemLike)Items.BOOK)).save(consumer);
        AetherRecipeData.woodenBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)AetherItems.SKYROOT_BOAT.get()), (ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)AetherItems.SKYROOT_CHEST_BOAT.get())).group("chest_boat").requires(Tags.Items.CHESTS_WOODEN).requires((ItemLike)AetherItems.SKYROOT_BOAT.get()).unlockedBy("has_boat", AetherRecipeData.has((TagKey)ItemTags.BOATS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.SADDLE, (int)1).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), (ItemLike)Items.STRING).pattern("LLL").pattern("LSL").unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.LEATHER), AetherRecipeData.has((ItemLike)Items.LEATHER)).save(consumer, this.name("aether_saddle"));
        AetherRecipeData.doorBuilder((ItemLike)((ItemLike)AetherBlocks.SKYROOT_DOOR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.SKYROOT_PLANKS.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).group("wooden_door").save(consumer);
        AetherRecipeData.trapdoorBuilder((ItemLike)((ItemLike)AetherBlocks.SKYROOT_TRAPDOOR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.SKYROOT_PLANKS.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).group("wooden_trapdoor").save(consumer);
        AetherRecipeData.buttonBuilder((ItemLike)((ItemLike)AetherBlocks.SKYROOT_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.SKYROOT_PLANKS.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).group("wooden_button").save(consumer);
        AetherRecipeData.buttonBuilder((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.HOLYSTONE.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        AetherRecipeData.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)AetherBlocks.SKYROOT_PRESSURE_PLATE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.SKYROOT_PLANKS.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.SKYROOT_PLANKS.get()))).group("wooden_pressure_plate").save(consumer);
        AetherRecipeData.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_PRESSURE_PLATE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.HOLYSTONE.get()})).unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.LEAD, (int)2).group("minecraft:lead").define(Character.valueOf('B'), AetherTags.Items.SWET_BALLS).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("SS ").pattern("SB ").pattern("  S").unlockedBy("has_swet_balls", AetherRecipeData.has(AetherTags.Items.SWET_BALLS)).save(consumer, this.name("swet_lead"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.STICKY_PISTON, (int)1).group("minecraft:sticky_piston").define(Character.valueOf('B'), AetherTags.Items.SWET_BALLS).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).pattern("B").pattern("P").unlockedBy("has_swet_balls", AetherRecipeData.has(AetherTags.Items.SWET_BALLS)).save(consumer, this.name("swet_sticky_piston"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.SLIME_BLOCK, (int)1).group("minecraft:slime_block").define(Character.valueOf('B'), AetherTags.Items.SWET_BALLS).pattern("BBB").pattern("BBB").pattern("BBB").unlockedBy("has_swet_balls", AetherRecipeData.has(AetherTags.Items.SWET_BALLS)).save(consumer, this.name("swet_slime_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.BARREL, (int)1).group("minecraft:barrel").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('H'), ItemTags.WOODEN_SLABS).pattern("PHP").pattern("P P").pattern("PHP").unlockedBy("has_planks", AetherRecipeData.has(AetherTags.Items.PLANKS_CRAFTING)).unlockedBy("has_slabs", AetherRecipeData.has((TagKey)ItemTags.WOODEN_SLABS)).save(consumer, this.name("skyroot_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.BEEHIVE, (int)1).group("minecraft:beehive").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('C'), (ItemLike)Items.HONEYCOMB).pattern("PPP").pattern("CCC").pattern("PPP").unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.HONEYCOMB), AetherRecipeData.has((ItemLike)Items.HONEYCOMB)).save(consumer, this.name("skyroot_beehive"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.CARTOGRAPHY_TABLE, (int)1).group("minecraft:cartography_table").define(Character.valueOf('#'), (ItemLike)Items.PAPER).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("##").pattern("PP").pattern("PP").unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.PAPER), AetherRecipeData.has((ItemLike)Items.PAPER)).save(consumer, this.name("skyroot_cartography_table"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.CHEST, (int)1).group("minecraft:chest").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("PPP").pattern("P P").pattern("PPP").unlockedBy("has_lots_of_items", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.atLeast((int)10), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of()))).save(consumer, this.name("skyroot_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.CRAFTING_TABLE, (int)1).group("minecraft:crafting_table").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("PP").pattern("PP").unlockedBy("has_planks", AetherRecipeData.has(AetherTags.Items.PLANKS_CRAFTING)).save(consumer, this.name("skyroot_crafting_table"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.FLETCHING_TABLE, (int)1).group("minecraft:fletching_table").define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("FF").pattern("PP").pattern("PP").unlockedBy(AetherRecipeData.getHasName((ItemLike)Items.FLINT), AetherRecipeData.has((ItemLike)Items.FLINT)).save(consumer, this.name("skyroot_fletching_table"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.GRINDSTONE, (int)1).group("minecraft:grindstone").define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('H'), (ItemLike)Blocks.STONE_SLAB).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("/H/").pattern("P P").unlockedBy(AetherRecipeData.getHasName((ItemLike)Blocks.STONE_SLAB), AetherRecipeData.has((ItemLike)Blocks.STONE_SLAB)).save(consumer, this.name("skyroot_grindstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.GRINDSTONE, (int)1).group("minecraft:grindstone").define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('H'), (ItemLike)AetherBlocks.HOLYSTONE_SLAB.get()).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("/H/").pattern("P P").unlockedBy(AetherRecipeData.getHasName((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_SLAB.get())), AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE_SLAB.get()))).save(consumer, this.name("skyroot_grindstone_holystone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.JUKEBOX, (int)1).group("minecraft:jukebox").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).pattern("PPP").pattern("PDP").pattern("PPP").unlockedBy("has_diamond", AetherRecipeData.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer, this.name("skyroot_jukebox"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.JUKEBOX, (int)1).group("minecraft:jukebox").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('G'), AetherTags.Items.PROCESSED_GRAVITITE).pattern("PPP").pattern("PGP").pattern("PPP").unlockedBy("has_gravitite", AetherRecipeData.has(AetherTags.Items.PROCESSED_GRAVITITE)).save(consumer, this.name("gravitite_jukebox"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.JUKEBOX, (int)1).group("minecraft:jukebox").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('G'), AetherTags.Items.PROCESSED_GRAVITITE).pattern("PPP").pattern("PGP").pattern("PPP").unlockedBy("has_gravitite", AetherRecipeData.has(AetherTags.Items.PROCESSED_GRAVITITE)).save(consumer, this.name("skyroot_gravitite_jukebox"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.LOOM, (int)1).group("minecraft:loom").define(Character.valueOf('T'), Tags.Items.STRINGS).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("TT").pattern("PP").unlockedBy("has_string", AetherRecipeData.has((TagKey)Tags.Items.STRINGS)).save(consumer, this.name("skyroot_loom"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.NOTE_BLOCK, (int)1).group("minecraft:note_block").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).pattern("PPP").pattern("PRP").pattern("PPP").unlockedBy("has_redstone", AetherRecipeData.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(consumer, this.name("skyroot_note_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.PISTON, (int)1).group("minecraft:piston").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).pattern("PPP").pattern("CIC").pattern("CRC").unlockedBy("has_redstone", AetherRecipeData.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(consumer, this.name("skyroot_piston"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.SHIELD, (int)1).group("minecraft:shield").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("PIP").pattern("PPP").pattern(" P ").unlockedBy("has_iron_ingot", AetherRecipeData.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer, this.name("skyroot_iron_vanilla_shield"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.SHIELD, (int)1).group("minecraft:shield").define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).define(Character.valueOf('Z'), AetherTags.Items.GEMS_ZANITE).pattern("PZP").pattern("PPP").pattern(" P ").unlockedBy("has_zanite_gemstone", AetherRecipeData.has(AetherTags.Items.GEMS_ZANITE)).save(consumer, this.name("skyroot_zanite_vanilla_shield"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.SHIELD, (int)1).group("minecraft:shield").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('Z'), AetherTags.Items.GEMS_ZANITE).pattern("PZP").pattern("PPP").pattern(" P ").unlockedBy("has_zanite_gemstone", AetherRecipeData.has(AetherTags.Items.GEMS_ZANITE)).save(consumer, this.name("wood_zanite_vanilla_shield"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.SMITHING_TABLE, (int)1).group("minecraft:smithing_table").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("II").pattern("PP").pattern("PP").unlockedBy("has_iron_ingot", AetherRecipeData.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer, this.name("skyroot_smithing_table"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TRIPWIRE_HOOK, (int)2).group("minecraft:tripwire_hook").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('P'), AetherTags.Items.PLANKS_CRAFTING).pattern("I").pattern("/").pattern("P").unlockedBy("has_string", AetherRecipeData.has((TagKey)Tags.Items.STRINGS)).save(consumer, this.name("skyroot_tripwire_hook"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.STONECUTTER).group("minecraft:stonecutter").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('#'), (ItemLike)AetherBlocks.HOLYSTONE.get()).pattern(" I ").pattern("###").unlockedBy("has_holystone", AetherRecipeData.has((ItemLike)((ItemLike)AetherBlocks.HOLYSTONE.get()))).save(consumer, this.name("holystone_stonecutter"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.LECTERN).group("minecraft:lectern").define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), (ItemLike)AetherBlocks.SKYROOT_BOOKSHELF.get()).pattern("SSS").pattern(" B ").pattern(" S ").unlockedBy("has_book", AetherRecipeData.has((ItemLike)Items.BOOK)).save(consumer, this.name("skyroot_lectern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Blocks.CAKE).group("minecraft:cake").define(Character.valueOf('A'), (ItemLike)AetherItems.SKYROOT_MILK_BUCKET.get()).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.WHEAT).define(Character.valueOf('E'), (ItemLike)Items.EGG).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_egg", AetherRecipeData.has((ItemLike)Items.EGG)).save(consumer, this.name("skyroot_milk_bucket_cake"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Blocks.CAKE).group("minecraft:cake").define(Character.valueOf('A'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.WHEAT).define(Character.valueOf('E'), AetherTags.Items.MOA_EGGS).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_moa_egg", AetherRecipeData.has(AetherTags.Items.MOA_EGGS)).save(consumer, this.name("moa_egg_cake"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Blocks.CAKE).group("minecraft:cake").define(Character.valueOf('A'), (ItemLike)AetherItems.SKYROOT_MILK_BUCKET.get()).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.WHEAT).define(Character.valueOf('E'), AetherTags.Items.MOA_EGGS).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_moa_egg", AetherRecipeData.has(AetherTags.Items.MOA_EGGS)).save(consumer, this.name("skyroot_milk_bucket_moa_egg_cake"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_PIE).group("minecraft:pumpkin_pie").requires((ItemLike)Blocks.PUMPKIN).requires((ItemLike)Items.SUGAR).requires(AetherTags.Items.MOA_EGGS).unlockedBy("has_carved_pumpkin", AetherRecipeData.has((ItemLike)Blocks.CARVED_PUMPKIN)).unlockedBy("has_pumpkin", AetherRecipeData.has((ItemLike)Blocks.PUMPKIN)).save(consumer, this.name("moa_egg_pumpkin_pie"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemStack)AetherItems.createSwetBannerItemStack((HolderGetter<BannerPattern>)holderLookup.lookupOrThrow(Registries.BANNER_PATTERN))).requires(ItemTags.BANNERS).requires((ItemLike)AetherItems.SWET_CAPE.get()).unlockedBy("has_swet_cape", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.SWET_CAPE.get()))).save(consumer, this.name("swet_banner"));
        this.smeltingOreRecipe((ItemLike)AetherItems.AMBROSIUM_SHARD.get(), (ItemLike)AetherBlocks.AMBROSIUM_ORE.get(), 0.1f).save(consumer, this.name("ambrosium_shard_from_smelting"));
        this.blastingOreRecipe((ItemLike)AetherItems.AMBROSIUM_SHARD.get(), (ItemLike)AetherBlocks.AMBROSIUM_ORE.get(), 0.1f).save(consumer, this.name("ambrosium_shard_from_blasting"));
        this.smeltingOreRecipe((ItemLike)AetherItems.ZANITE_GEMSTONE.get(), (ItemLike)AetherBlocks.ZANITE_ORE.get(), 0.7f).save(consumer, this.name("zanite_gemstone_from_smelting"));
        this.blastingOreRecipe((ItemLike)AetherItems.ZANITE_GEMSTONE.get(), (ItemLike)AetherBlocks.ZANITE_ORE.get(), 0.7f).save(consumer, this.name("zanite_gemstone_from_blasting"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GOLDEN_GLOVES.get(), (ItemLike)AetherItems.GOLDEN_PENDANT.get(), (ItemLike)AetherItems.GOLDEN_RING.get(), (ItemLike)AetherItems.VICTORY_MEDAL.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)200).unlockedBy("has_golden_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_GLOVES.get()))).unlockedBy("has_golden_pendant", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_PENDANT.get()))).unlockedBy("has_golden_ring", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_RING.get()))).unlockedBy("has_victory_medal", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.VICTORY_MEDAL.get()))).group(AetherRecipeData.getSmeltingRecipeName((ItemLike)Items.GOLD_NUGGET)).save(consumer, this.name("aether_" + AetherRecipeData.getSmeltingRecipeName((ItemLike)Items.GOLD_NUGGET)));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.IRON_GLOVES.get(), (ItemLike)AetherItems.IRON_PENDANT.get(), (ItemLike)AetherItems.IRON_RING.get(), (ItemLike)AetherItems.CHAINMAIL_GLOVES.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)200).unlockedBy("has_iron_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_GLOVES.get()))).unlockedBy("has_iron_pendant", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_PENDANT.get()))).unlockedBy("has_iron_ring", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_RING.get()))).unlockedBy("has_chainmail_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.CHAINMAIL_GLOVES.get()))).group(AetherRecipeData.getSmeltingRecipeName((ItemLike)Items.IRON_NUGGET)).save(consumer, this.name("aether_" + AetherRecipeData.getSmeltingRecipeName((ItemLike)Items.IRON_NUGGET)));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GOLDEN_GLOVES.get(), (ItemLike)AetherItems.GOLDEN_PENDANT.get(), (ItemLike)AetherItems.GOLDEN_RING.get(), (ItemLike)AetherItems.VICTORY_MEDAL.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)100).unlockedBy("has_golden_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_GLOVES.get()))).unlockedBy("has_golden_pendant", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_PENDANT.get()))).unlockedBy("has_golden_ring", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.GOLDEN_RING.get()))).unlockedBy("has_victory_medal", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.VICTORY_MEDAL.get()))).group(AetherRecipeData.getBlastingRecipeName((ItemLike)Items.GOLD_NUGGET)).save(consumer, this.name("aether_" + AetherRecipeData.getBlastingRecipeName((ItemLike)Items.GOLD_NUGGET)));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.IRON_GLOVES.get(), (ItemLike)AetherItems.IRON_PENDANT.get(), (ItemLike)AetherItems.IRON_RING.get(), (ItemLike)AetherItems.CHAINMAIL_GLOVES.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)100).unlockedBy("has_iron_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_GLOVES.get()))).unlockedBy("has_iron_pendant", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_PENDANT.get()))).unlockedBy("has_iron_ring", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.IRON_RING.get()))).unlockedBy("has_chainmail_gloves", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.CHAINMAIL_GLOVES.get()))).group(AetherRecipeData.getBlastingRecipeName((ItemLike)Items.IRON_NUGGET)).save(consumer, this.name("aether_" + AetherRecipeData.getBlastingRecipeName((ItemLike)Items.IRON_NUGGET)));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MUSIC_DISC_STAL}), (RecipeCategory)RecipeCategory.MISC, AetherItems.MUSIC_DISC_KLEPTO, (float)1.0f, (int)200).unlockedBy("has_disc", AetherRecipeData.has((ItemLike)((ItemLike)AetherItems.MUSIC_DISC_KLEPTO.get()))).save(consumer, this.name("klepto_smelting"));
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.CARVED_WALL.get(), (ItemLike)AetherBlocks.CARVED_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.CARVED_STAIRS.get(), (ItemLike)AetherBlocks.CARVED_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.CARVED_SLAB.get(), (ItemLike)AetherBlocks.CARVED_STONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.SENTRY_STONE.get(), (ItemLike)AetherBlocks.CARVED_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.CARVED_STONE.get(), (ItemLike)AetherBlocks.SENTRY_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.ANGELIC_WALL.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ANGELIC_STAIRS.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ANGELIC_SLAB.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.PILLAR.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.PILLAR_TOP.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ANGELIC_STONE.get(), (ItemLike)AetherBlocks.PILLAR.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ANGELIC_STONE.get(), (ItemLike)AetherBlocks.PILLAR_TOP.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.PILLAR_TOP.get(), (ItemLike)AetherBlocks.PILLAR.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.PILLAR.get(), (ItemLike)AetherBlocks.PILLAR_TOP.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.LIGHT_ANGELIC_STONE.get(), (ItemLike)AetherBlocks.ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ANGELIC_STONE.get(), (ItemLike)AetherBlocks.LIGHT_ANGELIC_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.HELLFIRE_WALL.get(), (ItemLike)AetherBlocks.HELLFIRE_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HELLFIRE_STAIRS.get(), (ItemLike)AetherBlocks.HELLFIRE_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HELLFIRE_SLAB.get(), (ItemLike)AetherBlocks.HELLFIRE_STONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.LIGHT_HELLFIRE_STONE.get(), (ItemLike)AetherBlocks.HELLFIRE_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HELLFIRE_STONE.get(), (ItemLike)AetherBlocks.LIGHT_HELLFIRE_STONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.HOLYSTONE_WALL.get(), (ItemLike)AetherBlocks.HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_STAIRS.get(), (ItemLike)AetherBlocks.HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_SLAB.get(), (ItemLike)AetherBlocks.HOLYSTONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get(), (ItemLike)AetherBlocks.HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_WALL.get(), (ItemLike)AetherBlocks.HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get(), (ItemLike)AetherBlocks.HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_SLAB.get(), (ItemLike)AetherBlocks.HOLYSTONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.MOSSY_HOLYSTONE_WALL.get(), (ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.MOSSY_HOLYSTONE_STAIRS.get(), (ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.MOSSY_HOLYSTONE_SLAB.get(), (ItemLike)AetherBlocks.MOSSY_HOLYSTONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_WALL.get(), (ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get(), (ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.HOLYSTONE_BRICK_SLAB.get(), (ItemLike)AetherBlocks.HOLYSTONE_BRICKS.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.ICESTONE_WALL.get(), (ItemLike)AetherBlocks.ICESTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ICESTONE_STAIRS.get(), (ItemLike)AetherBlocks.ICESTONE.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ICESTONE_SLAB.get(), (ItemLike)AetherBlocks.ICESTONE.get(), 2);
        this.stonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)AetherBlocks.AEROGEL_WALL.get(), (ItemLike)AetherBlocks.AEROGEL.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.AEROGEL_STAIRS.get(), (ItemLike)AetherBlocks.AEROGEL.get());
        this.stonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.AEROGEL_SLAB.get(), (ItemLike)AetherBlocks.AEROGEL.get(), 2);
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.FISHING_ROD, 300).save(consumer, this.name("fishing_rod_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.FLINT_AND_STEEL, 300).save(consumer, this.name("flint_and_steel_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.BOW, 600).save(consumer, this.name("bow_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.CROSSBOW, 600).save(consumer, this.name("crossbow_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.SHIELD, 600).save(consumer, this.name("shield_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.SKYROOT_PICKAXE.get(), 250).group("altar_pickaxe_repair").save(consumer, this.name("skyroot_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.SKYROOT_AXE.get(), 250).group("altar_axe_repair").save(consumer, this.name("skyroot_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.SKYROOT_SHOVEL.get(), 250).group("altar_shovel_repair").save(consumer, this.name("skyroot_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.SKYROOT_HOE.get(), 250).group("altar_hoe_repair").save(consumer, this.name("skyroot_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.HOLYSTONE_PICKAXE.get(), 500).group("altar_pickaxe_repair").save(consumer, this.name("holystone_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.HOLYSTONE_AXE.get(), 500).group("altar_axe_repair").save(consumer, this.name("holystone_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.HOLYSTONE_SHOVEL.get(), 500).group("altar_shovel_repair").save(consumer, this.name("holystone_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.HOLYSTONE_HOE.get(), 500).group("altar_hoe_repair").save(consumer, this.name("holystone_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.ZANITE_PICKAXE.get(), 750).group("altar_pickaxe_repair").save(consumer, this.name("zanite_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.ZANITE_AXE.get(), 750).group("altar_axe_repair").save(consumer, this.name("zanite_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.ZANITE_SHOVEL.get(), 750).group("altar_shovel_repair").save(consumer, this.name("zanite_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.ZANITE_HOE.get(), 750).group("altar_hoe_repair").save(consumer, this.name("zanite_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.GRAVITITE_PICKAXE.get(), 1500).group("altar_pickaxe_repair").save(consumer, this.name("gravitite_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.GRAVITITE_AXE.get(), 1500).group("altar_axe_repair").save(consumer, this.name("gravitite_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.GRAVITITE_SHOVEL.get(), 1500).group("altar_shovel_repair").save(consumer, this.name("gravitite_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)AetherItems.GRAVITITE_HOE.get(), 1500).group("altar_hoe_repair").save(consumer, this.name("gravitite_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.SKYROOT_SWORD.get(), 250).group("altar_sword_repair").save(consumer, this.name("skyroot_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.HOLYSTONE_SWORD.get(), 500).group("altar_sword_repair").save(consumer, this.name("holystone_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_SWORD.get(), 750).group("altar_sword_repair").save(consumer, this.name("zanite_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_SWORD.get(), 1500).group("altar_sword_repair").save(consumer, this.name("gravitite_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_HELMET.get(), 750).group("altar_helmet_repair").save(consumer, this.name("zanite_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_CHESTPLATE.get(), 750).group("altar_chestplate_repair").save(consumer, this.name("zanite_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_LEGGINGS.get(), 750).group("altar_leggings_repair").save(consumer, this.name("zanite_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_BOOTS.get(), 750).group("altar_boots_repair").save(consumer, this.name("zanite_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_GLOVES.get(), 750).group("altar_gloves_repair").save(consumer, this.name("zanite_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_HELMET.get(), 1500).group("altar_helmet_repair").save(consumer, this.name("gravitite_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_CHESTPLATE.get(), 1500).group("altar_chestplate_repair").save(consumer, this.name("gravitite_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_LEGGINGS.get(), 1500).group("altar_leggings_repair").save(consumer, this.name("gravitite_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_BOOTS.get(), 1500).group("altar_boots_repair").save(consumer, this.name("gravitite_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GRAVITITE_GLOVES.get(), 1500).group("altar_gloves_repair").save(consumer, this.name("gravitite_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.WOODEN_PICKAXE, 250).group("altar_pickaxe_repair").save(consumer, this.name("wooden_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.WOODEN_AXE, 250).group("altar_axe_repair").save(consumer, this.name("wooden_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.WOODEN_SHOVEL, 250).group("altar_shovel_repair").save(consumer, this.name("wooden_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.WOODEN_HOE, 250).group("altar_hoe_repair").save(consumer, this.name("wooden_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.STONE_PICKAXE, 500).group("altar_pickaxe_repair").save(consumer, this.name("stone_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.STONE_AXE, 500).group("altar_axe_repair").save(consumer, this.name("stone_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.STONE_SHOVEL, 500).group("altar_shovel_repair").save(consumer, this.name("stone_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.STONE_HOE, 500).group("altar_hoe_repair").save(consumer, this.name("stone_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.IRON_PICKAXE, 750).group("altar_pickaxe_repair").save(consumer, this.name("iron_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.IRON_AXE, 750).group("altar_axe_repair").save(consumer, this.name("iron_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.IRON_SHOVEL, 750).group("altar_shovel_repair").save(consumer, this.name("iron_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.IRON_HOE, 750).group("altar_hoe_repair").save(consumer, this.name("iron_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.GOLDEN_PICKAXE, 300).group("altar_pickaxe_repair").save(consumer, this.name("golden_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.GOLDEN_AXE, 300).group("altar_axe_repair").save(consumer, this.name("golden_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.GOLDEN_SHOVEL, 300).group("altar_shovel_repair").save(consumer, this.name("golden_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.GOLDEN_HOE, 300).group("altar_hoe_repair").save(consumer, this.name("golden_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.DIAMOND_PICKAXE, 1500).group("altar_pickaxe_repair").save(consumer, this.name("diamond_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.DIAMOND_AXE, 1500).group("altar_axe_repair").save(consumer, this.name("diamond_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.DIAMOND_SHOVEL, 1500).group("altar_shovel_repair").save(consumer, this.name("diamond_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.DIAMOND_HOE, 1500).group("altar_hoe_repair").save(consumer, this.name("diamond_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.NETHERITE_PICKAXE, 2000).group("altar_pickaxe_repair").save(consumer, this.name("netherite_pickaxe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.NETHERITE_AXE, 2000).group("altar_axe_repair").save(consumer, this.name("netherite_axe_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.NETHERITE_SHOVEL, 2000).group("altar_shovel_repair").save(consumer, this.name("netherite_shovel_repairing"));
        this.repairingRecipe(RecipeCategory.TOOLS, (ItemLike)Items.NETHERITE_HOE, 2000).group("altar_hoe_repair").save(consumer, this.name("netherite_hoe_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.WOODEN_SWORD, 250).group("altar_sword_repair").save(consumer, this.name("wooden_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.STONE_SWORD, 500).group("altar_sword_repair").save(consumer, this.name("stone_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.IRON_SWORD, 750).group("altar_sword_repair").save(consumer, this.name("iron_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.GOLDEN_SWORD, 300).group("altar_sword_repair").save(consumer, this.name("golden_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.DIAMOND_SWORD, 1500).group("altar_sword_repair").save(consumer, this.name("diamond_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.NETHERITE_SWORD, 2000).group("altar_sword_repair").save(consumer, this.name("netherite_sword_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.LEATHER_HELMET, 250).group("altar_helmet_repair").save(consumer, this.name("leather_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.LEATHER_CHESTPLATE, 250).group("altar_chestplate_repair").save(consumer, this.name("leather_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.LEATHER_LEGGINGS, 250).group("altar_leggings_repair").save(consumer, this.name("leather_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.LEATHER_BOOTS, 250).group("altar_boots_repair").save(consumer, this.name("leather_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.LEATHER_GLOVES.get(), 250).group("altar_gloves_repair").save(consumer, this.name("leather_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.IRON_HELMET, 750).group("altar_helmet_repair").save(consumer, this.name("iron_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.IRON_CHESTPLATE, 750).group("altar_chestplate_repair").save(consumer, this.name("iron_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.IRON_LEGGINGS, 750).group("altar_leggings_repair").save(consumer, this.name("iron_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.IRON_BOOTS, 750).group("altar_boots_repair").save(consumer, this.name("iron_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.IRON_GLOVES.get(), 750).group("altar_gloves_repair").save(consumer, this.name("iron_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.GOLDEN_HELMET, 300).group("altar_helmet_repair").save(consumer, this.name("golden_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.GOLDEN_CHESTPLATE, 300).group("altar_chestplate_repair").save(consumer, this.name("golden_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.GOLDEN_LEGGINGS, 300).group("altar_leggings_repair").save(consumer, this.name("golden_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.GOLDEN_BOOTS, 300).group("altar_boots_repair").save(consumer, this.name("golden_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.GOLDEN_GLOVES.get(), 300).group("altar_gloves_repair").save(consumer, this.name("golden_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_HELMET, 700).group("altar_helmet_repair").save(consumer, this.name("chainmail_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_CHESTPLATE, 700).group("altar_chestplate_repair").save(consumer, this.name("chainmail_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_LEGGINGS, 700).group("altar_leggings_repair").save(consumer, this.name("chainmail_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_BOOTS, 700).group("altar_boots_repair").save(consumer, this.name("chainmail_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.CHAINMAIL_GLOVES.get(), 700).group("altar_gloves_repair").save(consumer, this.name("chainmail_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.DIAMOND_HELMET, 1500).group("altar_helmet_repair").save(consumer, this.name("diamond_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.DIAMOND_CHESTPLATE, 1500).group("altar_chestplate_repair").save(consumer, this.name("diamond_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.DIAMOND_LEGGINGS, 1500).group("altar_leggings_repair").save(consumer, this.name("diamond_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.DIAMOND_BOOTS, 1500).group("altar_boots_repair").save(consumer, this.name("diamond_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.DIAMOND_GLOVES.get(), 1500).group("altar_gloves_repair").save(consumer, this.name("diamond_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.NETHERITE_HELMET, 2000).group("altar_helmet_repair").save(consumer, this.name("netherite_helmet_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.NETHERITE_CHESTPLATE, 2000).group("altar_chestplate_repair").save(consumer, this.name("netherite_chestplate_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.NETHERITE_LEGGINGS, 2000).group("altar_leggings_repair").save(consumer, this.name("netherite_leggings_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)Items.NETHERITE_BOOTS, 2000).group("altar_boots_repair").save(consumer, this.name("netherite_boots_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.NETHERITE_GLOVES.get(), 2000).group("altar_gloves_repair").save(consumer, this.name("netherite_gloves_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_RING.get(), 500).group("altar_ring_repair").save(consumer, this.name("zanite_ring_repairing"));
        this.repairingRecipe(RecipeCategory.COMBAT, (ItemLike)AetherItems.ZANITE_PENDANT.get(), 500).group("altar_pendant_repair").save(consumer, this.name("zanite_pendant_repairing"));
        this.enchantingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.ENCHANTED_DART.get(), (ItemLike)AetherItems.GOLDEN_DART.get(), 0.15f, 50).save(consumer, this.name("enchanted_dart_enchanting"));
        this.enchantingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.ENCHANTED_DART_SHOOTER.get(), (ItemLike)AetherItems.GOLDEN_DART_SHOOTER.get(), 1.0f, 750).save(consumer, this.name("enchanted_dart_shooter_enchanting"));
        this.enchantingRecipe(RecipeCategory.FOOD, (ItemLike)AetherItems.HEALING_STONE.get(), (ItemLike)AetherBlocks.HOLYSTONE.get(), 0.35f, 500).save(consumer, this.name("healing_stone_enchanting"));
        this.enchantingRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.ENCHANTED_GRAVITITE.get(), (ItemLike)AetherBlocks.GRAVITITE_ORE.get(), 1.0f, 750).save(consumer, this.name("enchanted_gravitite_enchanting"));
        this.enchantingRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.QUICKSOIL_GLASS.get(), (ItemLike)AetherBlocks.QUICKSOIL.get(), 0.1f, 250).save(consumer, this.name("quicksoil_glass_enchanting"));
        this.enchantingRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.GOLDEN_AERCLOUD.get(), (ItemLike)AetherBlocks.COLD_AERCLOUD.get(), 0.1f, 1000).save(consumer, this.name("golden_aercloud_enchanting"));
        this.enchantingRecipe(RecipeCategory.FOOD, (ItemLike)AetherItems.ENCHANTED_BERRY.get(), (ItemLike)AetherItems.BLUE_BERRY.get(), 0.35f, 250).save(consumer, this.name("enchanted_berry_enchanting"));
        this.enchantingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.MUSIC_DISC_AETHER_TUNE.get(), AetherTags.Items.ACCEPTED_MUSIC_DISCS, 1.0f, 500, "disc").save(consumer, this.name("aether_tune_enchanting"));
        this.hiddenEnchantingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.MUSIC_DISC_CHINCHILLA.get(), (ItemLike)Items.MUSIC_DISC_STRAD, 1.0f, 500).save(consumer, this.name("chinchilla_enchanting"));
        this.enchantingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.SKYROOT_REMEDY_BUCKET.get(), (ItemLike)AetherItems.SKYROOT_POISON_BUCKET.get(), 0.35f, 500).save(consumer, this.name("remedy_bucket_enchanting"));
        this.freezingRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.BLUE_AERCLOUD.get(), (ItemLike)AetherBlocks.COLD_AERCLOUD.get(), 0.1f, 400).save(consumer, this.name("blue_aercloud_freezing"));
        this.freezingRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)AetherBlocks.CRYSTAL_LEAVES.get(), (ItemLike)AetherBlocks.SKYROOT_LEAVES.get(), 0.1f, 500).save(consumer, this.name("crystal_leaves_freezing"));
        this.hiddenFreezingRecipe(RecipeCategory.MISC, (ItemLike)AetherItems.MUSIC_DISC_HIGH.get(), (ItemLike)AetherItems.MUSIC_DISC_CHINCHILLA.get(), 1.0f, 500).save(consumer, this.name("high_freezing"));
        this.freezingRecipeWithUnlockTag(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BLUE_ICE, (ItemLike)Blocks.PACKED_ICE, (TagKey<Item>)Tags.Items.BUCKETS_WATER, 0.1f, 500, "water_bucket").save(consumer, this.name("blue_ice_freezing"));
        this.freezingRecipeWithUnlockTag(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.PACKED_ICE, (ItemLike)Blocks.ICE, (TagKey<Item>)Tags.Items.BUCKETS_WATER, 0.1f, 300, "water_bucket").save(consumer, this.name("packed_ice_freezing"));
        this.freezingRecipeWithTag(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.ICE, (TagKey<Item>)Tags.Items.BUCKETS_WATER, 0.1f, 200, "water_bucket").save(consumer, this.name("ice_from_bucket_freezing"));
        this.freezingRecipeWithTag(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OBSIDIAN, (TagKey<Item>)Tags.Items.BUCKETS_LAVA, 0.1f, 200, "lava_bucket").save(consumer, this.name("obsidian_from_bucket_freezing"));
        this.freezingRecipeWithTag(RecipeCategory.MISC, (ItemLike)AetherItems.ICE_RING.get(), AetherTags.Items.FREEZABLE_RINGS, 1.0f, 800, "ring").save(consumer, this.name("ice_ring_from_freezing"));
        this.freezingRecipeWithTag(RecipeCategory.MISC, (ItemLike)AetherItems.ICE_PENDANT.get(), AetherTags.Items.FREEZABLE_PENDANTS, 1.0f, 800, "pendant").save(consumer, this.name("ice_pendant_from_freezing"));
        this.moaIncubationRecipe((EntityType)AetherEntityTypes.MOA.get(), AetherMoaTypes.BLUE, (ItemLike)AetherItems.BLUE_MOA_EGG.get()).save(consumer, this.name("blue_moa_incubation"));
        this.moaIncubationRecipe((EntityType)AetherEntityTypes.MOA.get(), AetherMoaTypes.WHITE, (ItemLike)AetherItems.WHITE_MOA_EGG.get()).save(consumer, this.name("white_moa_incubation"));
        this.moaIncubationRecipe((EntityType)AetherEntityTypes.MOA.get(), AetherMoaTypes.BLACK, (ItemLike)AetherItems.BLACK_MOA_EGG.get()).save(consumer, this.name("black_moa_incubation"));
        this.ambrosiumEnchanting((Block)AetherBlocks.ENCHANTED_AETHER_GRASS_BLOCK.get(), (Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).save(consumer, this.name("ambrosium_enchant_aether_grass_to_enchanted_aether_grass"));
        this.swetBallConversion(Blocks.GRASS_BLOCK, Blocks.DIRT).save(consumer, this.name("swet_ball_dirt_to_grass"));
        this.swetBallConversion((Block)AetherBlocks.AETHER_GRASS_BLOCK.get(), (Block)AetherBlocks.AETHER_DIRT.get()).save(consumer, this.name("swet_ball_aether_dirt_to_aether_grass"));
        this.swetBallConversionTag(Blocks.MYCELIUM, Blocks.DIRT, AetherTags.Biomes.MYCELIUM_CONVERSION).save(consumer, this.name("swet_ball_dirt_to_mycelium"));
        this.swetBallConversionTag(Blocks.PODZOL, Blocks.GRASS_BLOCK, AetherTags.Biomes.PODZOL_CONVERSION).save(consumer, this.name("swet_ball_grass_to_podzol"));
        this.swetBallConversionTag(Blocks.CRIMSON_NYLIUM, Blocks.NETHERRACK, AetherTags.Biomes.CRIMSON_NYLIUM_CONVERSION).save(consumer, this.name("swet_ball_netherrack_to_crimson_nylium"));
        this.swetBallConversionTag(Blocks.WARPED_NYLIUM, Blocks.NETHERRACK, AetherTags.Biomes.WARPED_NYLIUM_CONVERSION).save(consumer, this.name("swet_ball_netherrack_to_warped_nylium"));
        this.icestoneFreezable(Blocks.ICE, Blocks.WATER).save(consumer, this.name("icestone_freeze_water"));
        this.icestoneFreezable(Blocks.OBSIDIAN, Blocks.LAVA).save(consumer, this.name("icestone_freeze_lava"));
        this.accessoryFreezable(Blocks.ICE, Blocks.WATER).save(consumer, this.name("accessory_freeze_water"));
        this.accessoryFreezable(Blocks.OBSIDIAN, Blocks.LAVA).save(consumer, this.name("accessory_freeze_lava"));
        this.convertPlacement((Block)AetherBlocks.AEROGEL.get(), Blocks.LAVA, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("aerogel_conversion"));
        this.convertPlacementWithProperties(Blocks.CAMPFIRE, this.map((Property<?>)CampfireBlock.LIT, Boolean.valueOf(false)), Blocks.CAMPFIRE, this.map((Property<?>)CampfireBlock.LIT, Boolean.valueOf(true)), AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("campfire_conversion"));
        List<Block> candles = List.of(Blocks.CANDLE, Blocks.WHITE_CANDLE, Blocks.ORANGE_CANDLE, Blocks.MAGENTA_CANDLE, Blocks.LIGHT_BLUE_CANDLE, Blocks.YELLOW_CANDLE, Blocks.LIME_CANDLE, Blocks.PINK_CANDLE, Blocks.GRAY_CANDLE, Blocks.LIGHT_GRAY_CANDLE, Blocks.CYAN_CANDLE, Blocks.PURPLE_CANDLE, Blocks.BLUE_CANDLE, Blocks.BROWN_CANDLE, Blocks.GREEN_CANDLE, Blocks.RED_CANDLE, Blocks.BLACK_CANDLE);
        for (Block candle : candles) {
            this.convertPlacementWithProperties(candle, this.map((Property<?>)CandleBlock.LIT, Boolean.valueOf(false)), candle, this.map((Property<?>)CandleBlock.LIT, Boolean.valueOf(true)), AetherTags.Biomes.ULTRACOLD).save(consumer, this.name(candle.getDescriptionId().replace(".", "_").replace("block_minecraft_", "") + "_conversion"));
        }
        List<Block> candleCakes = List.of(Blocks.CANDLE_CAKE, Blocks.WHITE_CANDLE_CAKE, Blocks.ORANGE_CANDLE_CAKE, Blocks.MAGENTA_CANDLE_CAKE, Blocks.LIGHT_BLUE_CANDLE_CAKE, Blocks.YELLOW_CANDLE_CAKE, Blocks.LIME_CANDLE_CAKE, Blocks.PINK_CANDLE_CAKE, Blocks.GRAY_CANDLE_CAKE, Blocks.LIGHT_GRAY_CANDLE_CAKE, Blocks.CYAN_CANDLE_CAKE, Blocks.PURPLE_CANDLE_CAKE, Blocks.BLUE_CANDLE_CAKE, Blocks.BROWN_CANDLE_CAKE, Blocks.GREEN_CANDLE_CAKE, Blocks.RED_CANDLE_CAKE, Blocks.BLACK_CANDLE_CAKE);
        for (Block candleCake : candleCakes) {
            this.convertPlacementWithProperties(candleCake, this.map((Property<?>)CandleCakeBlock.LIT, Boolean.valueOf(false)), candleCake, this.map((Property<?>)CandleCakeBlock.LIT, Boolean.valueOf(true)), AetherTags.Biomes.ULTRACOLD).save(consumer, this.name(candleCake.getDescriptionId().replace(".", "_").replace("block_minecraft_", "") + "_conversion"));
        }
        this.convertPlacement(Blocks.CARVED_PUMPKIN, Blocks.JACK_O_LANTERN, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("jack_o_lantern_conversion"));
        this.banItemPlacementWithBypass((ItemLike)Items.FLINT_AND_STEEL, AetherTags.Blocks.ALLOWED_FLAMMABLES, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("flint_and_steel_item_ban"));
        this.banItemPlacementWithBypass((ItemLike)Items.FIRE_CHARGE, AetherTags.Blocks.ALLOWED_FLAMMABLES, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("fire_charge_item_ban"));
        this.banItemPlacement((ItemLike)Items.TORCH, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("torch_item_ban"));
        this.banItemPlacement((ItemLike)Items.LANTERN, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("lantern_item_ban"));
        this.banBlockPlacementWithBypass(Blocks.FIRE, AetherTags.Blocks.ALLOWED_FLAMMABLES, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("fire_block_ban"));
        this.banBlockPlacement(Blocks.TORCH, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("torch_block_ban"));
        this.banBlockPlacement(Blocks.LANTERN, AetherTags.Biomes.ULTRACOLD).save(consumer, this.name("lantern_block_ban"));
    }
}

