/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.layers;

import com.aetherteam.aether.client.renderer.entity.model.ValkyrieModel;
import com.aetherteam.aether.client.renderer.entity.model.ValkyrieWingsModel;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.entity.monster.dungeon.Valkyrie;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ValkyrieWingsLayer<T extends AbstractValkyrie>
extends RenderLayer<T, ValkyrieModel<T>> {
    private final ResourceLocation wingsLocation;
    private final ValkyrieWingsModel<Valkyrie> wings;

    public ValkyrieWingsLayer(RenderLayerParent<T, ValkyrieModel<T>> entityRenderer, ResourceLocation wingsLocation, ValkyrieWingsModel<Valkyrie> wingsModel) {
        super(entityRenderer);
        this.wingsLocation = wingsLocation;
        this.wings = wingsModel;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T valkyrie, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupWingRotation(valkyrie, ageInTicks);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.wingsLocation));
        if (!valkyrie.isInvisible()) {
            this.wings.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(valkyrie, (float)0.0f));
        }
    }

    public void setupWingRotation(T entity, float ticks) {
        float sinage = this.handleWingSinage(entity, ticks);
        float targetYRot = Mth.sin((float)sinage) / 6.0f - 0.2f;
        float targetZRot = Mth.cos((float)sinage) / (((AbstractValkyrie)entity).isEntityOnGround() ? 8.0f : 3.0f) - 0.125f;
        this.wings.leftWing.yRot = targetYRot;
        this.wings.leftWing.zRot = targetZRot;
        this.wings.rightWing.yRot = -targetYRot;
        this.wings.rightWing.zRot = -targetZRot;
    }

    private float handleWingSinage(T entity, float sinage) {
        sinage = !((AbstractValkyrie)entity).isEntityOnGround() ? (sinage *= 0.75f) : (sinage *= 0.15f);
        return sinage;
    }
}

